<#--如果图表存在引用和取值-->
<#if isQuoteOrGetValue??>
<#elseif importName?? && importName != "">
  <#if queryAttr??>
    const ${importName!}Obj = {
    ${queryAttr}
    <#if orders??>
      ${orders}
    </#if>
    <#if dims?? && (dims?size>0) >
      dims:[
        <#list dims as dim>
          "${dim}"<#if dim_has_next>,</#if>
        </#list>
      ],
    </#if>
    <#if targets?? && (targets?size>0) >
      targets:[
      <#list targets as target>
        {"columnName":"${target['columnName']!}","agg":"${target['agg']!}","asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
      </#list>
      ],
    </#if>
    };
    <#if isNewDataSet?? && isNewDataSet && isDataSetSearch>
      const queryConditions = self.${instanceKey}GetQueryConditions(${importName!}Obj);
      if (queryConditions && queryConditions.length) {
      ${importName!}Obj.superQueryConditionDto = queryConditions;
      }
    </#if>
  <#else>
    const ${importName!}Obj = {
    <#if orders??>
      ${orders}
    </#if>
    <#if dims?? && (dims?size>0) >
      dims:[
      <#list dims as dim>
        "${dim}"<#if dim_has_next>,</#if>
      </#list>
      ],
    </#if>
    <#if targets?? && (targets?size>0) >
      targets:[
      <#list targets as target>
        {"columnName":"${target['columnName']!}","agg":"${target['agg']!}","asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
      </#list>
      ]
    </#if>
    };
  </#if>
<#-- 设置数据模型后请求数据 -->
<#-- 绑定的是新的数据集模型 -->
<#if isNewDataSet?? && isNewDataSet>
  ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
  if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
  const dataBaseArray = res.data.data;
  const dimArr = [
  <#if dims?? && (dims?size>0) >
    <#list dims as dim>
      "${dim}Dim"<#if dim_has_next>,</#if>
    </#list>
  </#if>
  ];
  const metricsArr = [
  <#if targets?? && (targets?size>0) >
    <#list targets as target>
      <#if target['agg']??>
        "${target['asAlias']!}"<#if target_has_next>,</#if>
      </#if>
    </#list>
  </#if>
  ];
  ${optionData!}.seriesResult = dataBaseArray.map((item) => ({
  name: item[dimArr[0]] || item[dimArr[0].toLowerCase()] || item[dimArr[0].toUpperCase()],
  value: item[metricsArr[0]] || item[metricsArr[0].toLowerCase()] || item[metricsArr[0].toUpperCase()],
  }));
  ${optionData!}.legendData = dataBaseArray.map((item) => item[dimArr[0]] || item[dimArr[0].toLowerCase()] || item[dimArr[0].toUpperCase()]);
  } else {
  HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
  }
  }).catch(function() {
  HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
  })
<#else>
  ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
    if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
      ${optionData!}.seriesResult = [];
      ${optionData!}.legendData = [];
      res.data.data.forEach((item) => {
        ${optionData!}.seriesResult.push({value: item.${seriesCols!}, name: item.${xAxisCols!}})
        ${optionData!}.legendData.push(item.${xAxisCols!})
      });
      if (self.$refs.${instanceKey!}Ref) {
          self.$refs.${instanceKey!}Ref.initEcharts();
      }
    } else {
      HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
    }
  }).catch(function() {
      HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
  })
</#if>
<#--没有设置数据模型时-->
<#elseif isDataSetType??>
<#-- START +++++++++++++++++++++++++++++++++ 请求数据集数据接口 +++++++++++++++++++++++++++++++ -->
  const modelFields = {
  dataModelId: '${dataModelId!}',
  dim: [
  <#list dims! as item>
    {
    field: '${item.field!}',
    fieldAlias: '${item.fieldAlias!}'
    },
  </#list>
  ],
  metrics: [
  <#list metrics! as item>
    {
    field: '${item.field!}',
    fieldAlias: '${item.fieldAlias!}',
    function: '${item.function!}',
    },
  </#list>
  ]
  };
  const dataSetSort = [
  <#list dataSetSort! as item>
    {
    column: '${item.column!}',
    asc: ${item.asc?string("true", "false")}
    }
  </#list>
  ];
  const superQuery = [
  ${DataSetQueryCondition!}
  ];
  const dataSetQuery = dataSetResolve.changeDataSetQuery(superQuery);
  const dataModelProperty = dataSetResolve.resolveDataSetChartProperty(modelFields, dataSetSort, dataSetQuery);
  chartApi.getChartDataSetViews(dataModelProperty).then((res) => {
  if (res && res.code === 10000 && res.data) {
  const dimArr = modelFields.dim.map((item) => <#noparse>`${item.fieldAlias}Dim`</#noparse>);
  const metricsArr = modelFields.metrics.map((item) => <#noparse>`${item.fieldAlias}Metrics`</#noparse>);
  self.${instanceKey!}OptionData.seriesResult = res.data.data.map((item) => ({
  name: item[dimArr[0]],
  value: item[metricsArr[0]],
  }));
  self.${instanceKey!}OptionData.legendData = res.data.data.map((item) => item[dimArr[0]]);
  }
  }).catch(function () {
  HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
  });
<#else>
  <#if isDefaultValue?? && isDefaultValue == false>
    if(${optionData!}.seriesResult.length === 0 && ${optionData!}.legendData.length === 0){
    ${optionData!} = {
    seriesResult: [
    { value: 335, name: '[图例1]' },
    { value: 150, name: '[图例2]' },
    { value: 20, name: '[图例3]' },
    { value: 310, name: '[图例4]' },
    { value: 310, name: '[图例5]' },
    ],
    legendData: ['[图例1]', '[图例2]', '[图例3]', '[图例4]', '[图例5]']
    }
    }
  </#if>
</#if>
