<#--如果图表存在引用和取值-->
<#if isQuoteOrGetValue??>
    self.${instanceKey}importName = 'notDefaultData';
    this.$nextTick(() => {
      self.$refs.${instanceKey}Ref?.initChart();
    });
<#elseif importName?? && importName != "">
    self.${instanceKey}importName = 'notDefaultData';
    const ${importName!}Obj = {
    <#if queryAttr??>
    ${queryAttr}
    </#if>
    <#if orders??>
      ${orders}
    </#if>
    <#if dims?? && (dims?size>0) >
      dims:[
      <#list dims as dim>
        "${dim}"<#if dim_has_next>,</#if>
      </#list>
      ],
    </#if>
    <#if targets?? && (targets?size>0) >
      targets:[
      <#list targets as target>
        {"columnName":"${target['columnName']!}","agg":"${target['agg']!}","asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
      </#list>
      ]
    </#if>
    };
      <#if isNewDataSet?? && isNewDataSet && isDataSetSearch>
          const queryConditions = self.${instanceKey}GetQueryConditions(${importName!}Obj);
          if (queryConditions && queryConditions.length) {
              ${importName!}Obj.superQueryConditionDto = queryConditions;
          }
    </#if>
    <#-- 绑定的是新的数据集模型 -->
     <#if isNewDataSet?? && isNewDataSet>
     ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
         if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
           const dataBaseArray = res.data.data;
           const dimArr = [
           <#if dims?? && (dims?size>0) >
             <#list dims as dim>
               "${dim}Dim"<#if dim_has_next>,</#if>
             </#list>
           </#if>
           ];
           const metricsArr = [
           <#if targets?? && (targets?size>0) >
             <#list targets as target>
               <#if target['agg']??>
                 "${target['asAlias']!}"<#if target_has_next>,</#if>
               </#if>
             </#list>
           </#if>
           ];
           self.${instanceKey}OptionData = dataBaseArray.map((item) => ({
           label: item[dimArr[0]] || item[dimArr[0].toLowerCase()] || item[dimArr[0].toUpperCase()],
           value: item[metricsArr[0]] || item[metricsArr[0].toLowerCase()] || item[metricsArr[0].toUpperCase()],
           }));
           self.$nextTick(() => {
               self.$refs.${instanceKey}Ref?.initChart();
               self.${instanceKey!}PropsData.isNewDataSet = false;
           });
         } else {
           HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
         }
       }).catch(function() {
         HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
       })
     <#else>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
        if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
            self.${instanceKey}OptionData = [];
            res.data.data.forEach(item => {
              self.${instanceKey}OptionData.push({ label: item.${province}, value: item.${rate} });
            });
            self.$nextTick(() => {
                self.$refs.${instanceKey}Ref?.initChart();
                self.${instanceKey!}PropsData.isNewDataSet = false;
            });
        }else{
          HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
        }
    }).catch(function() {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
    })
    </#if>
    <#elseif isDataSetType??>
        self.${instanceKey}importName = 'notDefaultData';
        const modelFields = {
        dataModelId: '${dataModelId!}',
            metrics: [
                <#list metrics! as item>
                    {
                    fieldName: '${item.fieldName!}',
                    cityName: '${item.cityName!}',
                    function: '${item.function!}',
                    latitude: '${item.latitude!}',
                    legendName: '${item.legendName!}',
                    longitude: '${item.longitude!}',
                    },
                </#list>
            ]
        };
        const dataSetSort = [
            <#list dataSetSort! as item>
                {
                column: '${item.column!}',
                asc: ${item.asc?string("true", "false")}
                }
            </#list>
        ];
        const superQuery = [
        ${DataSetQueryCondition!}
        ];
        const dataSetQuery = dataSetResolve.changeDataSetQuery(superQuery);
        const dataSetFields = dataSetResolve.setDataSetScatterMap(modelFields);
        const dataModelProperty = dataSetResolve.resolveDataSetScatterMapChartProperty(dataSetFields, dataSetSort, dataSetQuery);
        chartApi.getChartDataSetViews(dataModelProperty).then((res) => {
            if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
                self.${instanceKey}OptionData = [];
                res.data.data.forEach(item => {
                  self.${instanceKey}OptionData.push({ label: item.${province}, value: item.${rate} });
                });
            self.$nextTick(() => {
                self.$refs.${instanceKey}Ref?.initChart();
                self.${instanceKey!}PropsData.isNewDataSet = false;
            });
            }else{
              HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
            }
        }).catch(function () {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
        });
    <#else>
        <#if result?? && result != "''">
            const obj = ${result};
            self.${instanceKey}importName = 'notDefaultData';
            this.$nextTick(() => {
            self.$refs.${instanceKey}Ref?.initChart();
            });
       <#else>
        self.${instanceKey}importName = 'defaultData';
        this.$nextTick(() => {
        self.$refs.${instanceKey}Ref && self.$refs.${instanceKey}Ref?.initChart();
        });
    </#if>
</#if>