<#--如果图表存在引用和取值-->
<#if isQuoteOrGetValue??>
  self.${instanceKey}Data = self.$echarts.init(document.getElementById('${instanceKey}Ref'));
<#elseif importName?? && importName != "">
    <#if queryAttr??>
        const ${importName!}Obj = {
        ${queryAttr}
        <#if orders??>
            ${orders}
        </#if>
        dims:[
        <#if dims?? && (dims?size>0) >
           <#list dims as dim>
               "${dim['convertName']!}",
           </#list>
        </#if>
        <#if outDim?? && (outDim?size>0) >
           <#list outDim as out>
               "${out['convertName']!}",
           </#list>
        </#if>
        ],
        targets:[
            <#list metrics! as metric>
                {"columnName":"${metric['convertName']!}","agg":"${metric['function']!}","asAlias":"${metric['asAlias']!}"},
            </#list>
            <#list dims! as dim>
                {"columnName":"${dim['convertName']!}","agg":"","asAlias":"${dim['asAlias']!}"},
            </#list>
            <#list outDim! as dim>
                {"columnName":"${dim['convertName']!}","agg":"","asAlias":"${dim['asAlias']!}"},
            </#list>
        ]
        };
        <#if isNewDataSet?? && isNewDataSet && isDataSetSearch>
            const queryConditions = self.${instanceKey}GetQueryConditions(${importName!}Obj);
            if (queryConditions && queryConditions.length) {
                ${importName!}Obj.superQueryConditionDto = queryConditions;
            }
        </#if>
    <#else>
     const ${importName!}Obj = {
            <#if orders??>
                ${orders}
            </#if>
             dims:[
                <#if dims?? && (dims?size>0) >
                   <#list dims as dim>
                       "${dim['convertName']!}",
                   </#list>
                </#if>
                <#if outDim?? && (outDim?size>0) >
                   <#list outDim as out>
                       "${out['convertName']!}",
                   </#list>
                </#if>
                ],
                targets:[
                    <#list metrics! as metric>
                        {"columnName":"${metric['convertName']!}","agg":"${metric['function']!}","asAlias":"${metric['asAlias']!}"},
                    </#list>
                    <#list dims! as dim>
                        {"columnName":"${dim['convertName']!}","agg":"","asAlias":"${dim['asAlias']!}"},
                    </#list>
                    <#list outDim! as dim>
                        {"columnName":"${dim['convertName']!}","agg":"","asAlias":"${dim['asAlias']!}"},
                    </#list>
                ]
        };
    </#if>
    <#-- 绑定的是新的数据集模型 -->
    <#if isNewDataSet?? && isNewDataSet>
      const metricsArray = [
          <#list metrics! as item>
             "${item['asAlias']!}"<#if item_has_next>,</#if>
          </#list>
      ];
      const outDimArr = [
        <#list outDim! as item>
             "${item['asAlias']!}"<#if item_has_next>,</#if>
        </#list>
      ];
      const dimArr = [
        <#list dims as item>
             "${item['asAlias']!}"<#if item_has_next>,</#if>
        </#list>
      ];
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
        if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
          const dataBaseArray = res.data.data;
          ${optionData!}.inNameData = dataBaseArray.map((item) => item[dimArr[0]] || item[outDimArr[0].toLowerCase()] || item[outDimArr[0].toUpperCase()]);
          ${optionData!}.seriesData = dataBaseArray.map((item) => item[metricsArray[0]] || item[metricsArray[0].toLowerCase()] || item[metricsArray[0].toUpperCase()]);
          ${optionData!}.outNameData = dataBaseArray.map((item) => item[outDimArr[0]] || item[outDimArr[0].toLowerCase()] || item[outDimArr[0].toUpperCase()]);
          ${optionData!}.outValueData = dataBaseArray.map((item) => item[metricsArray[0]] || item[metricsArray[0].toLowerCase()] || item[metricsArray[0].toUpperCase()]);
        } else {
          HussarRouter.showMsg(self, "数据请求失败", 'error');
        }
      }).catch(function() {
        HussarRouter.showMsg(self, "数据请求异常", 'error');
      })
    <#else>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
    if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
        const dataBaseArray = res.data.data;
        const outNameData = dataBaseArray.map(item => item.${outCols!});
        ${optionData!}.inNameData = [];
        ${optionData!}.outValueData = [];
        ${optionData!}.seriesData = [];
        ${optionData!}.outNameData = [...new Set(outNameData)];
        ${optionData!}.outNameData.forEach((outNameData) => {
            let count = 0;
            dataBaseArray.forEach((item) => {
                if (outNameData === item.${outCols!}) {
                   ${optionData!}.inNameData.push(item.${inCols!});
                   ${optionData!}.seriesData.push(item.${seriesCols!});
                    count += parseInt(item.${seriesCols!}, 10);
                }
             });
            ${optionData!}.outValueData.push(count);
        })
    } else {
        HussarRouter.showMsg(self, "数据请求失败", 'error');
    }
    }).catch(function() {
        HussarRouter.showMsg(self, "数据请求异常", 'error');
    })
    return self.${instanceKey!}OptionData;
    </#if>
<#--    没有设置数据模型时-->
<#elseif isDataSetType??>
    const modelFields = {
    dataModelId: '${dataModelId!}',
    dim: [
    <#list dims! as item>
        {
        field: '${item.field!}',
        fieldAlias: '${item.fieldAlias!}'
        },
    </#list>
    ],
    metrics: [
    <#list metrics! as item>
        {
        field: '${item.field!}',
        fieldAlias: '${item.fieldAlias!}',
        function: '${item.function!}',
        rename: '${item.rename!}'
        },
    </#list>
    ],
    outDim: [
    <#list outDim! as item>
        {
        field: '${item.field!}',
        fieldAlias: '${item.fieldAlias!}'
        },
    </#list>
    ]
    };
    const dataSetSort = [
    <#list dataSetSort! as item>
        {
        column: '${item.column!}',
        asc: ${item.asc?string("true", "false")}
        }
    </#list>
    ];
    const superQuery = [
    ${DataSetQueryCondition!}
    ];
    const dataSetQuery = dataSetResolve.changeDataSetQuery(superQuery);
    const dataModelProperty = dataSetResolve.resolveDataSetNestedPiesChartProperty(modelFields, dataSetSort, dataSetQuery);
    chartApi.getChartDataSetViews(dataModelProperty).then((res) => {
    if (res && res.code === 10000 && res.data) {
    const dimArr = modelFields.dim.map((item) => <#noparse>`${item.fieldAlias}Dim`</#noparse>);
    const metricsArr = modelFields.metrics.map((item) => <#noparse>`${item.fieldAlias}Metrics`</#noparse>);
    const outDimArr = modelFields.outDim.map((item) => <#noparse>`${item.fieldAlias}OutDim`</#noparse>);
    ${optionData!} = {
    outNameData: res.data.data.map((item) => item[outDimArr[0]]),
    outValueData: res.data.data.map((item) => item[metricsArr[0]]),
    inNameData: res.data.data.map((item) => item[dimArr[0]]),
    seriesData: res.data.data.map((item) => item[metricsArr[0]])
    }
    }
    }).catch(function () {
    HussarRouter.showMsg(self, '数据请求异常', 'error');
    });
<#else>
    <#if isDefaultValue?? && isDefaultValue == false>
        if(${optionData!}.outNameData.length === 0 && ${optionData!}.outValueData.length === 0 && ${optionData!}.inNameData.length === 0 && ${optionData!}.seriesData.length === 0){
        ${optionData!} = {
        outNameData: ['[内图例1]', '[内图例2]'],
        outValueData: [680, 700],
        inNameData: ['[外图例3]', '[外图例4]', '[外图例5]', '[外图例6]'],
        seriesData: [360, 320, 600, 100]
        }
        }
    </#if>
</#if>