<#--如果图表存在引用和取值-->
<#if isQuoteOrGetValue??>
<#elseif importName?? && importName != "">
    <#if queryAttr??>
        const ${importName!}Obj = {
        ${queryAttr}
        <#if orders??>
            ${orders}
        </#if>
        <#if dims?? && (dims?size>0) >
            dims:[
                <#list dims as dim>
                    "${dim}"<#if dim_has_next>,</#if>
                </#list>
            ],
        </#if>
        <#if targets?? && (targets?size>0) >
        targets:[
            <#list targets as target>
                {"columnName":"${target['columnName']!}","agg":"${target['agg']!}","asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
            </#list>
        ]
        </#if>
        };
        <#if isNewDataSet?? && isNewDataSet && isDataSetSearch>
            const queryConditions = self.${instanceKey}GetQueryConditions(${importName!}Obj);
            if (queryConditions && queryConditions.length) {
                ${importName!}Obj.superQueryConditionDto = queryConditions;
            }
        </#if>
    <#else>
    const ${importName!}Obj = {
        <#if orders??>
            ${orders}
        </#if>
        <#if dims?? && (dims?size>0) >
            dims:[
                <#list dims as dim>
                    "${dim}"<#if dim_has_next>,</#if>
                </#list>
            ],
        </#if>
        <#if targets?? && (targets?size>0) >
            targets:[
                <#list targets as target>
                    {"columnName":"${target['columnName']!}","agg":"${target['agg']!}","asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
                </#list>
            ]
        </#if>
    };
    </#if>
    <#-- 绑定的是新的数据集模型 -->
    <#if isNewDataSet?? && isNewDataSet>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
        if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
          const dataBaseArray = res.data.data;
          const dimArr = [
            <#if dims?? && (dims?size>0) >
                <#list dims as dim>
                    "${dim}Dim"<#if dim_has_next>,</#if>
                </#list>
            </#if>
          ];
          const metricsArr = [
            <#if targets?? && (targets?size>0) >
                <#list targets as target>
                    <#if target['agg']??>
                        "${target['asAlias']!}"<#if target_has_next>,</#if>
                    </#if>
                </#list>
            </#if>
          ];
          const legendData = [
            <#if targets?? && (targets?size>0) >
                <#list targets as target>
                    <#if target['agg']??>
                        "${target['legendName']!}"<#if target_has_next>,</#if>
                    </#if>
                </#list>
            </#if>
          ];
          ${optionData!}.xAxisData = dataBaseArray.map((item) => item[dimArr[0]] || item[dimArr[0].toLowerCase()] || item[dimArr[0].toUpperCase()]);
          ${optionData!}.yAxisData = metricsArr.map((metric) => dataBaseArray.map((item) => item[metric] || item[metric.toLowerCase()] || item[metric.toUpperCase()]));
          ${optionData!}.legendData = legendData.map((item) => `[${'$'}{item}]`);
        } else {
          HussarRouter.showMsg(self, "数据请求失败", 'error');
        }
      }).catch(function() {
        HussarRouter.showMsg(self, "数据请求异常", 'error');
      })
    <#else>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
        if ((res.code === 200 || res.code === 10000) && res.data &&　res.data.data) {
            const dataBaseArray = res.data.data;
            const xAxisData = dataBaseArray.map(item => item.${xAxisCols!});
            const legendData = dataBaseArray.map(item => item.${legendCols!});
            ${optionData!}.yAxisData = [];
            ${optionData!}.xAxisData = [...new Set(xAxisData)];
            ${optionData!}.legendData = [...new Set(legendData)];
            ${optionData!}.legendData.forEach((lengendData) => {
                const yAxisData = [];
                ${optionData!}.xAxisData.forEach((xAxisData) => {
                    let num = 0;
                    dataBaseArray.forEach((item) => {
                        if (lengendData === item.${legendCols!} && xAxisData === item.${xAxisCols!}) {
                            yAxisData.push(item.${seriesCols!});
                            return;
                        }
                        num++;
                        if (num === dataBaseArray.length) {
                            yAxisData.push(null);
                        }
                     })
                });
                ${optionData!}.yAxisData.push(yAxisData);
            })
        } else {
            HussarRouter.showMsg(self, "数据请求失败", 'error');
        }
    }).catch(function() {
        HussarRouter.showMsg(self, "数据请求异常", 'error');
    })
    </#if>
<#--    没有设置数据模型时-->
<#else>
    <#if isDefaultValue?? && isDefaultValue == false>
        if (${optionData!}.xAxisData.length == 0 && ${optionData!}.yAxisData.length == 0 && ${optionData!}.legendData.length == 0) {
        ${optionData!}.xAxisData = ['[名称1]', '[名称2]', '[名称3]', '[名称4]', '[名称5]', '[名称6]', '[名称7]'];
        ${optionData!}.yAxisData = [[305, 420, 330, 360, 320, 430, 300], [230, 400, 250, 240, 250, 210, 250], [100, 320, 150, 210, 199, 130, 76]];
        ${optionData!}.legendData = ['[图例1]', '[图例2]', '[图例3]'];
        }
    </#if>
</#if>
