<#--如果图表存在引用和取值-->
<#if isQuoteOrGetValue??>
<#elseif importName?? && importName != "">
  <#-- 查询数据库赋值 -->
  <#if queryAttr??>
    let ${importName!}Obj = {
    ${queryAttr}
    <#if orders??>
      ${orders}
    </#if>
    <#if dims?? && (dims?size>0) >
      dims:[
      <#list dims as dim>
        "${dim}"<#if dim_has_next>,</#if>
      </#list>
      ],
    </#if>
    <#if targets?? && (targets?size>0) >
      targets:[
      <#list targets as target>
        {"columnName":"${target['columnName']!}","agg":"${target['agg']!}","legendName":"${target['legendName']!}","asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
      </#list>
      ],
    </#if>
    };
    <#if isNewDataSet?? && isNewDataSet && isDataSetSearch>
      const queryConditions = self.${instanceKey}GetQueryConditions(${importName!}Obj);
      if (queryConditions && queryConditions.length) {
      ${importName!}Obj.superQueryConditionDto = queryConditions;
      }
    </#if>
  <#else>
    let ${importName!}Obj = {
    <#if orders??>
      ${orders}
    </#if>
    <#if dims?? && (dims?size>0) >
      dims:{
      <#list dims?keys as key>
        "${key!}":"${dims[key]!}"<#if key_has_next>,</#if>
      </#list>
      },
    </#if>
    <#if targets?? && (targets?size>0) >
      targets:[
      <#list targets as target>
        {"columnName":"${target['columnName']}","agg":"${target['agg']}","asAlias":"${target['asAlias']!}", "legendName":"${target['legendName']}"}<#if target_has_next>,</#if>
      </#list>
      ]
    </#if>
    };
  </#if>
  <#-- 绑定的是新的数据集模型 -->
<#if isNewDataSet?? && isNewDataSet>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
    if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
    const dataBaseArray = res.data.data;
    const dimArr = [
    <#if dims?? && (dims?size>0) >
      <#list dims as dim>
        "${dim}Dim"<#if dim_has_next>,</#if>
      </#list>
    </#if>
    ];
    const metricsArr = [
    <#if targets?? && (targets?size>0) >
        <#list targets as target>
          <#if target['agg']??>
            "${target['asAlias']!}"<#if target_has_next>,</#if>
          </#if>
        </#list>
    </#if>
    ];
    self.${instanceKey!}OptionData.value = String(dataBaseArray.map((item) => item[metricsArr[0]] || item[metricsArr[0].toLowerCase()] || item[metricsArr[0].toUpperCase()]));
    self.${instanceKey!}PropsData.targetTitle = ${importName!}Obj.targets[0].legendName;
    } else {
    HussarRouter.showMsg(self, "数据请求失败", 'error');
    }
    }).catch(function() {
    HussarRouter.showMsg(self, "数据请求异常", 'error');
    })
<#else>
  <#-- 设置数据模型后请求数据 -->
  ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
    if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
      const dataBaseArray = res.data.data;
      const xAxisData = dataBaseArray.map(item => item.${xAxisCols!});
      const legendData = dataBaseArray.map(item => item.${legendCols!});
      ${curPropsData!}.yAxisData = [];
      ${curPropsData!}.xAxisData = [...new Set(xAxisData)];
      ${curPropsData!}.legendData = [...new Set(legendData)];
      ${curPropsData!}.legendData.forEach((lengendData) => {
        const yAxisData = [];
        ${curPropsData!}.xAxisData.forEach((xAxisData) => {
          let num = 0;
          dataBaseArray.forEach((item) => {
            if (lengendData === item.${legendCols!} && xAxisData === item.${xAxisCols!}) {
              yAxisData.push(item.${seriesCols!});
              return;
            }
            num++;
            if (num === dataBaseArray.length) {
              yAxisData.push(null);
            }
          })
        });
        ${curPropsData!}.yAxisData.push(yAxisData);
      });
      self.${instanceKey!}OptionData = {
      yAxisData: self.${instanceKey!}PropsData.yAxisData,
      xAxisData: self.${instanceKey!}PropsData.xAxisData,
      legendData: self.${instanceKey!}PropsData.legendData
      };
      self.$refs.${instanceKey!}Ref && self.$refs.${instanceKey!}Ref.OptionItem();
    } else {
      HussarRouter.showMsg(self, "数据请求失败", 'error');
    }
  }).catch(function() {
    HussarRouter.showMsg(self, "数据请求异常", 'error');
  })
</#if>
<#elseif isDataSetType??>
  const modelFields = {
  dataModelId: '${dataModelId!}',
  metrics: [
  <#list metrics! as item>
    {
    field: '${item.field!}',
    fieldAlias: '${item.fieldAlias!}',
    function: '${item.function!}',
    rename: '${item.rename!}'
    },
  </#list>
  ]
  };
  const dataSetSort = [
  <#list dataSetSort! as item>
    {
    column: '${item.column!}',
    asc: ${item.asc?string("true", "false")}
    }
  </#list>
  ];
  const superQuery = [
  ${DataSetQueryCondition!}
  ];
  const dataSetQuery = dataSetResolve.changeDataSetQuery(superQuery);
  const dataModelProperty = dataSetResolve.resolveDataSetGaugeProperty(modelFields, dataSetSort, dataSetQuery);
  chartApi.getChartDataSetViews(dataModelProperty).then((res) => {
  if (res && res.code === 10000 && res.data) {
  const metricsArr = modelFields.metrics.map((item) => <#noparse>`${item.fieldAlias}Metrics`</#noparse>);
  self.${instanceKey!}OptionData.value = String(res.data.data.map((item) => item[metricsArr[0]]));
  self.${instanceKey!}PropsData.targetTitle = modelFields.metrics[0].rename;
  }
  }).catch(function () {
  HussarRouter.showMsg(self, '数据请求异常', 'error');
  });






<#--    没有设置数据模型时-->
<#else>
  <#-- 当配置数据处理时，给optionData重新赋值 -->
  if (!self.${instanceKey!}OptionData.value) {
  <#if isDefaultValue?? && isDefaultValue == false>
    self.${instanceKey!}OptionData.value = '0';
  </#if>
  }
</#if>