<#--如果图表存在引用和取值-->
<#if isQuoteOrGetValue??>
<#elseif importName?? && importName != "">
    <#if queryAttr??>
        const ${importName!}Obj = {
        ${queryAttr}
        <#if orders??>
            ${orders}
        </#if>
        <#if dims?? && (dims?size>0) >
            dims:[
            <#list dims as dim>
                "${dim}"<#if dim_has_next>,</#if>
            </#list>
            ],
        </#if>
        <#if targets?? && (targets?size>0) >
            targets:[
            <#list targets as target>
                {"columnName":"${target['columnName']}","agg":"${target['agg']}","legendName":"${target['legendName']}", "asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
            </#list>
            ],
        </#if>
        };
        <#if isNewDataSet?? && isNewDataSet && isDataSetSearch>
            const queryConditions = self.${instanceKey}GetQueryConditions(${importName!}Obj);
            if (queryConditions && queryConditions.length) {
            ${importName!}Obj.superQueryConditionDto = queryConditions;
            }
        </#if>
    <#else>
        const ${importName!}Obj = {
        <#if orders??>
            ${orders}
        </#if>
        <#if dims?? && (dims?size>0) >
            dims:[
            <#list dims as dim>
                "${dim}"<#if dim_has_next>,</#if>
            </#list>
            ],
        </#if>
        <#if targets?? && (targets?size>0) >
            targets:[
            <#list targets as target>
                {"columnName":"${target['columnName']}","agg":"${target['agg']}", "legendName":"${target['legendName']}", "asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
            </#list>
            ]
        </#if>
        };
    </#if>
<#-- 绑定的是新的数据集模型 -->
<#if isNewDataSet?? && isNewDataSet>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
    if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
    const dataBaseArray = res.data.data;
    const dimArr = [
    <#if dims?? && (dims?size>0) >
        <#list dims as dim>
            "${dim}Dim"<#if dim_has_next>,</#if>
        </#list>
    </#if>
    ];
    const metricsArr = [
    <#if targets?? && (targets?size>0) >
        <#list targets as target>
            <#if target['agg']??>
                "${target['asAlias']!}"<#if target_has_next>,</#if>
            </#if>
        </#list>
    </#if>
    ];
    self.${instanceKey!}OptionData = {
    xAxisData: dataBaseArray.map((item) => item[metricsArr[0]] || item[metricsArr[0].toLowerCase()] || item[metricsArr[0].toUpperCase()]),
    seriesData: ${importName!}Obj.targets[0].legendName,
    }
    } else {
    HussarRouter.showMsg(self, "数据请求失败", 'error');
    }
    }).catch(function() {
    HussarRouter.showMsg(self, "数据请求异常", 'error');
    })
<#else>
    ${importName!}.${importMethod!}(${importName!}Obj).then(res => {
    if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
    ${optionData!}.xAxisData = [];
    ${optionData!}.seriesData = [];
    res.data.data.forEach((item,index) => {
    if (index === 0){
    self.${instanceKey!}OptionData.xAxisData.push(item.${seriesValue!});
    self.${instanceKey!}OptionData.seriesData.push(item.${seriesName!});
    }
    });
    } else {
    HussarRouter.showMsg(self, "数据请求失败", 'error');
    }
    }).catch(function() {
    HussarRouter.showMsg(self, "数据请求异常", 'error');
    })
</#if>
<#elseif isDataSetType??>
    const modelFields = {
    dataModelId: '${dataModelId!}',
    metrics: [
    <#list metrics! as item>
        {
        field: '${item.field!}',
        fieldAlias: '${item.fieldAlias!}',
        function: '${item.function!}',
        rename: '${item.rename!}'
        },
    </#list>
    ]
    };
    const dataSetSort = [
    <#list dataSetSort! as item>
        {
        column: '${item.column!}',
        asc: ${item.asc?string("true", "false")}
        }
    </#list>
    ];
    const superQuery = [
    ${DataSetQueryCondition!}
    ];
    const dataSetQuery = dataSetResolve.changeDataSetQuery(superQuery);
    const dataModelProperty = dataSetResolve.resolveDataSetGaugeProperty(modelFields, dataSetSort, dataSetQuery);
    chartApi.getChartDataSetViews(dataModelProperty).then((res) => {
    if (res && res.code === 10000 && res.data) {
    const metricsArr = modelFields.metrics.map((item) => <#noparse>`${item.fieldAlias}Metrics`</#noparse>);
    self.${instanceKey!}OptionData = {
    xAxisData: res.data.data.map((item) => item[metricsArr[0]]),
    seriesData: modelFields.metrics[0].rename,
    }
    }
    }).catch(function () {
    HussarRouter.showMsg(self, '数据请求异常', 'error');
    });
<#--    没有设置数据模型时-->
<#else>
    <#if isDefaultValue?? && isDefaultValue == false>
        if(${optionData!}.xAxisData.length === 0 && ${optionData!}.seriesData.length === 0){
        self.${instanceKey!}OptionData = {
        xAxisData: [50],
        seriesData: ['仪表盘名称']
        }
        }
    </#if>
</#if>
