#!/bin/bash

# 检查参数数量是否正确
if [ $# -ne 1 ]; then
    echo "Usage: $0 <port>"
    exit 1
fi

# 获取端口号参数
port=$1

# 在 netstat 输出中查找指定端口的监听情况，并提取对应的 PID
pid=$(lsof -i :$port | grep LISTEN | awk '{print $2}')
if [ -z "$pid" ]; then
    echo 0
    exit 0
fi
# 输出 PID
echo 1