#!/bin/bash

# 获取服务器名称
server_name=$(hostname)

# 获取IP地址
ip_address=$(hostname -I | awk '{print $1}')

# 获取操作系统信息
os_info=$(cat /etc/os-release | grep PRETTY_NAME | cut -d '"' -f 2)

# 获取CPU使用率
cpu_usage=$(top -bn1 | grep "Cpu(s)" | sed "s/.*, *\([0-9.]*\)%* id.*/\1/" | awk '{print 100 - $1}')

# 获取内存使用情况
mem_info=$(free -h | grep Mem | awk '{print "Total: " $2 ", Used: " $3 ", Free: " $4}')

# 获取存储空间
disk_info=$(df -h --total | grep total | awk '{print "Total: " $2 ", Used: " $3 ", Free: " $4}')

# 打印所有信息
echo "serverName: $server_name"
echo "IP: $ip_address"
echo "os system: $os_info"
echo "CPU usage rate: $cpu_usage%"
echo "memory usage status: $mem_info"
echo "memory space: $disk_info"