/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.devtools.invocation.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.devtools.compile.dto.RunnerStatus;
import com.jxdinfo.hussar.formdesign.devtools.compile.service.CompileService;
import com.jxdinfo.hussar.formdesign.devtools.compile.util.PathUtil;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.service.IGitlabService;
import com.jxdinfo.hussar.formdesign.devtools.invocation.dto.StartVariables;
import com.jxdinfo.hussar.formdesign.devtools.invocation.properties.DeployToolsProperties;
import com.jxdinfo.hussar.formdesign.devtools.invocation.service.CompileInvokeHelper;
import com.jxdinfo.hussar.formdesign.devtools.invocation.tool.ClassPathResolver;
import com.jxdinfo.hussar.formdesign.devtools.invocation.tool.ShellScriptExecutor;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.devtools.invocation.service.impl.CompileInvokeServiceImpl")
public class CompileInvokeServiceImpl
implements CompileInvokeHelper {
    @Resource
    private CompileService compileService;
    @Resource
    private DeployToolsProperties deployToolsProperties;
    @Resource
    private IGitlabService gitlabService;
    private static final Logger LOGGER = LoggerFactory.getLogger(CompileInvokeServiceImpl.class);

    public ApiResponse<?> compile(String pkgName, String pathSegments) throws Exception {
        return this.compileService.compile(pkgName, pathSegments);
    }

    public ApiResponse<?> reRun(String pathSegments, StartVariables startVariables) throws Exception {
        this.executeMethodTwice(2, startVariables.getBackPort());
        this.onlyRun(pathSegments, startVariables);
        return ApiResponse.success();
    }

    private void executeMethodTwice(int remainingAttempts, String port) {
        if (remainingAttempts > 0) {
            this.stop(port);
            this.executeMethodTwice(remainingAttempts - 1, port);
        }
    }

    public ApiResponse<?> compileModule(String appCode, String pkgName, String pathSegments) throws Exception {
        return this.compileService.compileModule(this.deployToolsProperties.getWorkspace(), appCode, pkgName, pathSegments);
    }

    private void onlyRun(String pathSegments, StartVariables startVariables) throws Exception {
        HussarThreadPoolConfiguration pool = (HussarThreadPoolConfiguration)SpringContextHolder.getBean(HussarThreadPoolConfiguration.class);
        Executor asyncExecutor = pool.getAsyncExecutor();
        String backPort = startVariables.getBackPort();
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        if (ObjectUtils.isNotEmpty((Object)backPort) && ((String)this.isActive(backPort).getData()).equals("0")) {
            String backScriptPath = ShellScriptExecutor.pathAapt(PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getScriptPath(), "start_back"}));
            if (ShellScriptExecutor.notExist(backScriptPath)) {
                throw new HussarException("\u8bf7\u90e8\u7f72\u540e\u7aef\u542f\u52a8\u811a\u672c\u81f3\u5bf9\u5e94\u7684\u76ee\u5f55\uff01");
            }
            String devUser = startVariables.getDevUser();
            String nacosGroup = startVariables.getNacosGroup();
            String redisHost = this.deployToolsProperties.getRedisHost();
            String redisPwd = this.deployToolsProperties.getRedisPwd();
            String redisPort = this.deployToolsProperties.getRedisPort();
            String backParentPath = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), pathSegments, tenantCode + "-web"});
            String backProjectPath = PathUtil.posixPath((String[])new String[]{backParentPath, this.deployToolsProperties.getBackProjectPath()});
            String classPath = PathUtil.systemPath((String[])new String[]{ClassPathResolver.classPath(startVariables.getAppCodes(), backParentPath, new ArrayList<String>())});
            String shortCommand = ClassPathResolver.shortCommand(BaseSecurityUtil.getUser().getAccount(), backProjectPath, classPath);
            String springBootApplication = this.deployToolsProperties.getSpringBootApplication();
            String springConfigLocation = PathUtil.posixPath((String[])new String[]{backProjectPath, "src", "main", "resources", "bootstrap.yml"});
            CompletionStage back = CompletableFuture.supplyAsync(() -> {
                ShellScriptExecutor.asyncRunLongArg(backScriptPath, classPath, ClassPathResolver.catVariables(redisHost, redisPwd, redisPort, backParentPath, backProjectPath, backPort, devUser, tenantCode, springConfigLocation, springBootApplication, shortCommand), this.deployToolsProperties.getScriptPath());
                return "";
            }, asyncExecutor).exceptionally(e -> {
                throw new HussarException("spring boot\u9879\u76ee\u542f\u52a8\u5931\u8d25", e);
            });
            ((CompletableFuture)back).thenApply(result -> result);
        }
    }

    public ApiResponse<Boolean> start(String pathSegments, StartVariables startVariables) throws HussarException {
        HussarThreadPoolConfiguration pool = (HussarThreadPoolConfiguration)SpringContextHolder.getBean(HussarThreadPoolConfiguration.class);
        Executor asyncExecutor = pool.getAsyncExecutor();
        String backPort = startVariables.getBackPort();
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        ArrayList<String> exceptionCatcher = new ArrayList<String>();
        try {
            if (ObjectUtils.isNotEmpty((Object)backPort) && ((String)this.isActive(backPort).getData()).equals("0")) {
                String backScriptPath = ShellScriptExecutor.pathAapt(PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getScriptPath(), "start_back"}));
                if (ShellScriptExecutor.notExist(backScriptPath)) {
                    return ApiResponse.fail((String)"\u8bf7\u90e8\u7f72\u540e\u7aef\u542f\u52a8\u811a\u672c\u81f3\u5bf9\u5e94\u7684\u76ee\u5f55\uff01");
                }
                String devUser = startVariables.getDevUser();
                String nacosGroup = startVariables.getNacosGroup();
                String redisHost = this.deployToolsProperties.getRedisHost();
                String redisPwd = this.deployToolsProperties.getRedisPwd();
                String redisPort = this.deployToolsProperties.getRedisPort();
                String backParentPath = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), pathSegments, tenantCode + "-web"});
                String backProjectPath = PathUtil.posixPath((String[])new String[]{backParentPath, this.deployToolsProperties.getBackProjectPath()});
                String classPath = PathUtil.systemPath((String[])new String[]{ClassPathResolver.classPath(startVariables.getAppCodes(), backParentPath, exceptionCatcher)});
                String shortCommand = ClassPathResolver.shortCommand(BaseSecurityUtil.getUser().getAccount(), backProjectPath, classPath);
                String springBootApplication = this.deployToolsProperties.getSpringBootApplication();
                String springConfigLocation = PathUtil.posixPath((String[])new String[]{backProjectPath, "src", "main", "resources", "bootstrap.yml"});
                CompletionStage back = CompletableFuture.supplyAsync(() -> {
                    ShellScriptExecutor.asyncRunLongArg(backScriptPath, classPath, ClassPathResolver.catVariables(redisHost, redisPwd, redisPort, backParentPath, backProjectPath, backPort, devUser, tenantCode, springConfigLocation, springBootApplication, shortCommand), this.deployToolsProperties.getScriptPath());
                    return "";
                }, asyncExecutor).exceptionally(e -> {
                    throw new HussarException("spring boot\u9879\u76ee\u542f\u52a8\u5931\u8d25", e);
                });
                ((CompletableFuture)back).thenApply(result -> result);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return ApiResponse.success((Object)false, (String)e2.getMessage());
        }
        String frontPort = startVariables.getFrontPort();
        try {
            if (ObjectUtils.isNotEmpty((Object)frontPort) && ((String)this.isActive(frontPort).getData()).equals("0")) {
                String frontScriptPath = ShellScriptExecutor.pathAapt(PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getScriptPath(), "start_front"}));
                if (ShellScriptExecutor.notExist(frontScriptPath)) {
                    return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)false, (String)"\u8bf7\u90e8\u7f72\u524d\u7aef\u542f\u52a8\u811a\u672c\u81f3\u5bf9\u5e94\u7684\u76ee\u5f55\uff01");
                }
                String frontProjectPath = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), pathSegments, tenantCode + "-front", this.deployToolsProperties.getFrontProjectPath()});
                this.writeDevUser(frontProjectPath, startVariables.getDevUser());
                CompletionStage front = CompletableFuture.supplyAsync(() -> {
                    ShellScriptExecutor.CallBack call = ShellScriptExecutor.call(frontScriptPath, ClassPathResolver.catVariables(frontProjectPath, frontPort, this.deployToolsProperties.getNpmRegistry()), this.deployToolsProperties.getScriptPath());
                    if (call.getExitCode() == 1) {
                        exceptionCatcher.add("");
                        exceptionCatcher.addAll(call.getRes());
                    }
                    return "";
                }, asyncExecutor).exceptionally(e -> {
                    throw new HussarException("vue\u9879\u76ee\u542f\u52a8\u5931\u8d25", e);
                });
                ((CompletableFuture)front).thenApply(result -> result);
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
            return ApiResponse.success((Object)false, (String)e3.getMessage());
        }
        if (ObjectUtils.isEmpty(exceptionCatcher)) {
            return ApiResponse.success((Object)true, (String)"\u542f\u52a8\u7a0b\u5e8f\u5df2\u6267\u884c\uff0c\u8bf7\u7b49\u5f85\u2026\u2026");
        }
        return ApiResponse.success((Object)false, (String)String.join((CharSequence)",", exceptionCatcher));
    }

    public ApiResponse<Boolean> stop(String port) {
        String scriptPath = ShellScriptExecutor.pathAapt(PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getScriptPath(), "kill_service"}));
        if (ShellScriptExecutor.notExist(scriptPath)) {
            return ApiResponse.fail((String)"\u8bf7\u90e8\u7f72\u542f\u52a8\u811a\u672c\u81f3\u5bf9\u5e94\u7684\u76ee\u5f55\uff01");
        }
        ShellScriptExecutor.call(scriptPath, port);
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<String> isActive(String port) {
        DeployToolsProperties deployToolsProperties = (DeployToolsProperties)SpringContextHolder.getBean(DeployToolsProperties.class);
        String scriptPath = ShellScriptExecutor.pathAapt(PathUtil.posixPath((String[])new String[]{deployToolsProperties.getScriptPath(), "find_pid"}));
        if (ShellScriptExecutor.notExist(scriptPath)) {
            return ApiResponse.fail((String)"\u8bf7\u90e8\u7f72\u542f\u52a8\u811a\u672c\u81f3\u5bf9\u5e94\u7684\u76ee\u5f55\uff01");
        }
        ShellScriptExecutor.CallBack call = ShellScriptExecutor.call(scriptPath, port);
        if (ObjectUtils.isEmpty((Object)call) || call.getExitCode() == 1) {
            throw new HussarException("\u6267\u884c\u5b58\u6d3b\u7aef\u53e3\u67e5\u8be2\u811a\u672c\u3010find_pid\u3011\u5f02\u5e38");
        }
        return ApiResponse.success((Object)call.getRes().get(0), (String)"");
    }

    public boolean isCodeComparison() {
        return this.deployToolsProperties.isCodeComparison();
    }

    public ApiResponse<List<RunnerStatus>> runnerStatus(String tenantCode, String userId) throws HussarException {
        String backPath = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), tenantCode, userId, tenantCode + "-web", this.deployToolsProperties.getBackProjectPath(), "runnerStatus.log"});
        String frontPath = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), tenantCode, userId, tenantCode + "-front", this.deployToolsProperties.getFrontProjectPath(), "runnerStatus.log"});
        ArrayList<RunnerStatus> runnerStatuses = new ArrayList<RunnerStatus>();
        try {
            RunnerStatus runnerStatus;
            RunnerStatus runnerStatusObj;
            if (new File(backPath).exists()) {
                runnerStatusObj = (RunnerStatus)JSONObject.parseObject((String)FileUtils.readFileToString((File)new File(backPath)), RunnerStatus.class);
                runnerStatus = new RunnerStatus(runnerStatusObj.getStatus(), runnerStatusObj.getException(), runnerStatusObj.getType());
                runnerStatuses.add(runnerStatus);
            }
            if (new File(frontPath).exists()) {
                runnerStatusObj = (RunnerStatus)JSONObject.parseObject((String)FileUtils.readFileToString((File)new File(frontPath)), RunnerStatus.class);
                runnerStatus = new RunnerStatus(runnerStatusObj.getStatus(), runnerStatusObj.getException(), runnerStatusObj.getType());
                runnerStatuses.add(runnerStatus);
            }
        }
        catch (IOException e) {
            throw new HussarException("\u83b7\u53d6\u670d\u52a1\u542f\u52a8\u72b6\u6001\u5f02\u5e38", (Throwable)e);
        }
        return ApiResponse.success(runnerStatuses);
    }

    public ApiResponse<Boolean> aliveTry() {
        ApiResponse aliveTry = new ApiResponse();
        try {
            aliveTry = this.compileService.aliveTry();
        }
        catch (Exception e) {
            LOGGER.info("\u4e1a\u52a1\u670d\u52a1\u672a\u542f\u52a8~");
        }
        return aliveTry;
    }

    private void writeDevUser(String frontPath, String devUser) {
        try {
            File env = new File(PathUtil.posixPath((String[])new String[]{frontPath, ".env.development"}));
            String originalContent = FileUtils.readFileToString((File)env, (Charset)StandardCharsets.UTF_8);
            SecurityUser loginUser = BaseSecurityUtil.getUser();
            String tenantCode = loginUser.getTenantCode();
            String appDevUser = "VUE_APP_DEV_USER";
            String appTcode = "VUE_APP_TCODE";
            String vueAppDevUser = String.format("%s=%s", appDevUser, devUser);
            String tCode = String.format("%s=%s", appTcode, tenantCode);
            String[] orgContentList = originalContent.split("\n");
            StringBuilder sb = new StringBuilder();
            for (String s : orgContentList) {
                if (s.contains(appDevUser) || s.contains(appTcode)) continue;
                sb.append(s).append("\n");
            }
            sb.append(vueAppDevUser).append("\n").append(tCode).append("\n");
            FileUtils.writeStringToFile((File)env, (String)sb.toString(), (boolean)false);
            this.gitlabService.pushVfgCode(".env.development\u6587\u4ef6\u4e2d\u7684dev_user\u548ctcode", Collections.singletonList(frontPath), "");
        }
        catch (IOException e) {
            LOGGER.error("\u524d\u7aef\u73af\u5883\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u9879\u76ee\u4ee3\u7801\u5df2\u62c9\u53d6\u6210\u529f\uff01");
            throw new HussarException("\u5199\u5165\u524d\u7aefDEV_USER\u5931\u8d25\uff01", (Throwable)e);
        }
    }
}

