#!/bin/bash
# 获取端口号参数
port=$1

# 检查端口是否在监听
pid=$(lsof -i :$port | grep LISTEN | awk '{print $2}')
if [ -z "$pid" ]; then
    echo "No service is running on port $port"
    exit 1
fi

# 停止服务
kill $pid
echo "Service running on port $port has been stopped"