/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.devtools.invocation.tool;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.devtools.compile.util.PathUtil;
import com.jxdinfo.hussar.formdesign.devtools.invocation.properties.DeployToolsProperties;
import com.jxdinfo.hussar.formdesign.devtools.invocation.service.impl.CompileInvokeServiceImpl;
import com.jxdinfo.hussar.formdesign.devtools.invocation.tool.ShellScriptExecutor;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompileInvokeServiceImpl.class);
    private static final int MAX_LINE_LENGTH = 72;

    public static String classPath(String appCode, String backParentPath, List<String> exceptionCatcher) throws HussarException {
        String clearLastQuoto;
        DeployToolsProperties deployToolsProperties = (DeployToolsProperties)SpringContextHolder.getBean(DeployToolsProperties.class);
        String scriptPath = ShellScriptExecutor.pathAapt(PathUtil.posixPath((String[])new String[]{deployToolsProperties.getScriptPath(), "classPath"}));
        if (ShellScriptExecutor.notExist(scriptPath)) {
            LOGGER.error("\u8bf7\u90e8\u7f72\u542f\u52a8\u811a\u672c\u81f3\u5bf9\u5e94\u7684\u76ee\u5f55");
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ClassPathResolver.jreLibPath());
        String backProjectPath = PathUtil.posixPath((String[])new String[]{backParentPath, deployToolsProperties.getBackProjectPath()});
        builder.append(PathUtil.systemPath((String[])new String[]{backProjectPath, "target\\classes\\"})).append(ClassPathResolver.splitOs());
        ShellScriptExecutor.CallBack call = ShellScriptExecutor.call(scriptPath, ClassPathResolver.catVariables(backProjectPath, backParentPath), deployToolsProperties.getScriptPath());
        if (ObjectUtils.isNotEmpty((Object)call) && call.getExitCode() != 1) {
            String[] allLineBuilder = new StringBuilder();
            for (String line : call.getRes()) {
                LOGGER.info("\u6bcf\u4e00\u884c\u7684\u6253\u5370\uff1a{}", (Object)line);
                allLineBuilder.append(line);
            }
            String startPrefix = "[INFO]Dependenciesclasspath:";
            String endSuffix = ".jar[INFO]";
            String allLine = allLineBuilder.toString().replaceAll("\\s", "");
            if (allLine.contains(startPrefix.trim())) {
                LOGGER.info("\u5904\u7406\u524d\u7684maven path:{}", (Object)allLine);
                int startIndex = allLine.indexOf(startPrefix) + startPrefix.length();
                int endIndex = allLine.indexOf(endSuffix) + 4;
                String classPaths = allLine.substring(startIndex, endIndex);
                if (ObjectUtils.isNotEmpty((Object)classPaths)) {
                    String trim = PathUtil.systemPath((String[])new String[]{ClassPathResolver.cleanJar(classPaths, appCode)});
                    LOGGER.info("\u5904\u7406\u540e\u7684maven path:{}", (Object)trim);
                    if (!trim.endsWith(ClassPathResolver.splitOs())) {
                        builder.append(trim).append(ClassPathResolver.splitOs());
                    } else {
                        builder.append(trim);
                    }
                }
            }
        } else {
            exceptionCatcher.add("\u540e\u7aef\u7f16\u8bd1\u9636\u6bb5\u5f02\u5e38\uff0c\u53ef\u80fd\u5b58\u5728\u4ee5\u4e0b\u60c5\u51b5\uff1a1\u3001maven\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff1b2\u3001\u4e2a\u4eba\u73af\u5883\u540e\u7aef\u9879\u76ee\u4f9d\u8d56\u662f\u5426\u6b63\u786e\uff1b2\u3001\u751f\u6210\u4ee3\u7801\u662f\u5426\u5b58\u5728\u8bed\u6cd5\u9519\u8bef");
            exceptionCatcher.addAll(call.getRes());
        }
        if (ObjectUtils.isNotEmpty((Object)appCode)) {
            for (String s : appCode.split(",")) {
                String appModule = PathUtil.systemPath((String[])new String[]{backParentPath, s, String.format("%s-server", s), "target\\classes\\"});
                String appApiModule = PathUtil.systemPath((String[])new String[]{backParentPath, s, String.format("%s-api", s), "target\\classes\\"});
                builder.append(appModule).append(ClassPathResolver.splitOs()).append(appApiModule).append(ClassPathResolver.splitOs());
            }
        }
        if ((clearLastQuoto = builder.toString()).endsWith(ClassPathResolver.splitOs())) {
            clearLastQuoto = clearLastQuoto.substring(0, clearLastQuoto.lastIndexOf(ClassPathResolver.splitOs()));
        }
        return clearLastQuoto;
    }

    public static String shortCommand(String author, String backProjectPath, String originalClassPath) {
        try {
            DeployToolsProperties deployToolsProperties = (DeployToolsProperties)SpringContextHolder.getBean(DeployToolsProperties.class);
            if (ClassPathResolver.splitOs().equals(":")) {
                return "do_not_shorten";
            }
            File shortenJar = new File(PathUtil.systemPath((String[])new String[]{backProjectPath, "shortenClassPath.jar"}));
            if (shortenJar.exists()) {
                try {
                    FileUtils.forceDelete((File)shortenJar);
                }
                catch (IOException e) {
                    throw new HussarException("\u5220\u9664" + shortenJar.getAbsolutePath() + "\u5931\u8d25", (Throwable)e);
                }
            }
            FileUtils.writeStringToFile((File)new File(PathUtil.systemPath((String[])new String[]{backProjectPath, "MANIFEST.MF"})), (String)ClassPathResolver.formatManiFestMf(author, originalClassPath), (Charset)StandardCharsets.UTF_8);
            String scriptPath = ShellScriptExecutor.pathAapt(PathUtil.posixPath((String[])new String[]{deployToolsProperties.getScriptPath(), "shortenCommand"}));
            ShellScriptExecutor.CallBack call = ShellScriptExecutor.call(scriptPath, backProjectPath, deployToolsProperties.getScriptPath());
            if (shortenJar.exists()) {
                return "do_shorten";
            }
            LOGGER.error("\u6267\u884c\u3010\u6267\u884cjar -cvf shortenClassPath.jar MANIFEST.MF\u3011 \u5931\u8d25\uff0c\u4ee5\u5168classPath\u542f\u52a8\uff01:{}", (Object)call);
            return "do_not_shorten";
        }
        catch (IOException e) {
            throw new HussarException((Throwable)e);
        }
    }

    private static String formatManiFestMf(String author, String originalClassPath) {
        String[] paths = originalClassPath.split(ClassPathResolver.splitOs());
        StringBuilder manifestContent = new StringBuilder();
        manifestContent.append("Manifest-Version: 1.0\r\n");
        manifestContent.append(String.format("Created-By: %s\r\n", author));
        StringBuilder classPaths = new StringBuilder();
        classPaths.append("Class-Path: ");
        for (String s : paths) {
            String path = s.trim();
            classPaths.append("file:/").append(path).append(ClassPathResolver.splitOs());
        }
        manifestContent.append(ClassPathResolver.shortClassPathLine(classPaths.toString()));
        return manifestContent.toString().replaceAll("\\\\", "/");
    }

    public static String shortClassPathLine(String classPath) {
        StringBuilder formattedPath = new StringBuilder();
        String[] paths = classPath.split(";");
        StringBuilder currentLine = new StringBuilder();
        block0: for (String path : paths) {
            path = path + " ";
            while (!path.isEmpty()) {
                if (currentLine.length() + path.length() + 1 > 72) {
                    int remainingLength = 72 - currentLine.length();
                    currentLine.append(path, 0, remainingLength);
                    path = path.substring(remainingLength);
                    formattedPath.append((CharSequence)currentLine).append("\n ");
                    currentLine.setLength(0);
                    continue;
                }
                currentLine.append(path);
                continue block0;
            }
        }
        if (currentLine.length() > 0) {
            formattedPath.append((CharSequence)currentLine).append("\n");
        }
        return formattedPath.toString();
    }

    private static String cleanJar(String classPath, String appCodes) {
        if (ObjectUtils.isEmpty((Object)appCodes)) {
            return classPath;
        }
        for (String s : appCodes.split(",")) {
            classPath = ClassPathResolver.match(classPath, ClassPathResolver.osReg("server", s), ClassPathResolver.osReg("api", s));
        }
        return classPath;
    }

    private static String osReg(String type, String appCode) {
        if (ClassPathResolver.splitOs().equals(";")) {
            return String.format(";[A-Z]:(\\\\[^;]*\\\\%s\\\\%s-%s\\\\[^;]*\\.jar)", appCode, appCode, type);
        }
        return String.format(":(/[^:]*/%s/%s-%s/[^:]*\\.jar)", appCode, appCode, type);
    }

    private static String match(String origin, String ... regs) {
        for (String reg : regs) {
            Pattern pattern = Pattern.compile(reg);
            Matcher matcher = pattern.matcher(origin);
            if (!matcher.find()) continue;
            origin = matcher.replaceAll("");
        }
        return origin;
    }

    private static String jreLibPath() {
        String jreLibPath = PathUtil.systemPath((String[])new String[]{System.getProperty("java.home"), "lib"});
        String jreLibExtPath = PathUtil.systemPath((String[])new String[]{System.getProperty("java.home"), "lib", "ext"});
        File jreLibDir = new File(jreLibPath);
        File jreLibExtDir = new File(jreLibExtPath);
        StringBuilder builder = new StringBuilder();
        if (jreLibDir.exists() && jreLibDir.isDirectory()) {
            File[] files = (File[])ArrayUtils.addAll((Object[])jreLibDir.listFiles(), (Object[])jreLibExtDir.listFiles());
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                    builder.append(file.getAbsolutePath()).append(ClassPathResolver.splitOs());
                }
            } else {
                System.out.println("No files found in " + jreLibPath);
            }
        } else {
            System.out.println("Invalid JDK installation directory: " + jreLibPath);
        }
        return builder.toString();
    }

    private static String splitOs() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return ";";
        }
        if (os.contains("nix") || os.contains("nux") || os.contains("aix") || os.contains("mac")) {
            return ":";
        }
        return ";";
    }

    public static String catVariables(String ... vars) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return String.format("\"%s\"", String.join((CharSequence)",", vars));
        }
        if (os.contains("nix") || os.contains("nux") || os.contains("aix") || os.contains("mac")) {
            return String.format("%s", String.join((CharSequence)",", vars));
        }
        return String.format("\"%s\"", String.join((CharSequence)",", vars));
    }
}

