/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.devtools.gitlab.service.impl;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.devtools.compile.util.PathUtil;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.model.GitDto;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.service.IGitlabService;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.GitlabUtil;
import com.jxdinfo.hussar.formdesign.devtools.invocation.properties.DeployToolsProperties;
import com.jxdinfo.hussar.formdesign.devtools.utils.FilePathConvertUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.example.git.service.impl.GitlabServiceImpl")
public class GitlabServiceImpl
implements IGitlabService {
    private static final Logger logger = LoggerFactory.getLogger(GitlabServiceImpl.class);
    @Resource
    private DeployToolsProperties deployToolsProperties;

    public ApiResponse<Boolean> createProject(GitDto gitDto) {
        return GitlabUtil.createProject((GitDto)gitDto);
    }

    public ApiResponse<String> pushToGit(GitDto gitDto) {
        return GitlabUtil.pushToGit((GitDto)gitDto);
    }

    public ApiResponse<String> pushSpecifiedToGit(GitDto gitDto) {
        return GitlabUtil.pushSpecifiedToGit((GitDto)gitDto);
    }

    public ApiResponse<String> pullToLocal(GitDto gitDto) {
        return GitlabUtil.pullToLocal((GitDto)gitDto);
    }

    public ApiResponse<String> createLocalBranch(GitDto gitDto) {
        return GitlabUtil.createLocalBranch((GitDto)gitDto);
    }

    public ApiResponse<String> createRemoteBranch(GitDto gitDto) {
        return GitlabUtil.createRemoteBranch((GitDto)gitDto);
    }

    public ApiResponse<String> checkoutBranch(GitDto gitDto) {
        return GitlabUtil.checkoutBranch((GitDto)gitDto);
    }

    public ApiResponse<Boolean> branchExist(GitDto gitDto) {
        return GitlabUtil.branchExist((GitDto)gitDto);
    }

    public ApiResponse<Boolean> remoteMerge(GitDto gitDto) {
        return GitlabUtil.remoteMerge((GitDto)gitDto);
    }

    public ApiResponse<Boolean> getGroupOrProjectId(GitDto gitDto) {
        return GitlabUtil.getGroupOrProjectId((GitDto)gitDto);
    }

    public ApiResponse<Boolean> revertOrRemove(List<String> fileToRevert) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String localDir = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), user.getTenantCode(), String.valueOf(user.getId())});
        return GitlabUtil.revertOrRemove((File)new File(localDir), fileToRevert);
    }

    public ApiResponse<String> pushVfgCode(String commitMsg, List<String> fileToAdd, String systemDir) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Map extendUserMap = user.getExtendUserMap();
        String localDir = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), user.getTenantCode(), String.valueOf(user.getId())});
        ArrayList<String> convertPath = new ArrayList<String>();
        for (String file : fileToAdd) {
            convertPath.add(FilePathConvertUtil.getRealFileByPath(file, systemDir).getAbsolutePath());
        }
        GitDto gitDto = new GitDto.Builder().branch(user.getAccount()).path(localDir).commitMsg(commitMsg).filesToAdd(convertPath).tenantCode(user.getTenantCode()).accessToken((String)extendUserMap.get("gitToken")).gitUri((String)extendUserMap.get("gitUrl")).build();
        HussarThreadPoolConfiguration pool = (HussarThreadPoolConfiguration)SpringContextHolder.getBean(HussarThreadPoolConfiguration.class);
        Executor asyncExecutor = pool.getAsyncExecutor();
        CompletionStage push = CompletableFuture.supplyAsync(() -> {
            GitlabUtil.pushSpecifiedToGitSync((GitDto)gitDto);
            return "";
        }, asyncExecutor).exceptionally(e -> {
            throw new RuntimeException((Throwable)e);
        });
        ((CompletableFuture)push).thenApply(result -> result);
        return ApiResponse.success((Object)"\u63a8\u9001\u6210\u529f", (String)"");
    }
}

