/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.devtools.compile.service.impl;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.devtools.compile.service.CompileService;
import com.jxdinfo.hussar.formdesign.devtools.compile.util.DynamicCompiler;
import com.jxdinfo.hussar.formdesign.devtools.compile.util.PathUtil;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.PublishLogUtil;
import com.jxdinfo.hussar.formdesign.devtools.properties.DevToolsProperties;
import com.jxdinfo.hussar.formdesign.devtools.stop.ApplicationEventPublisherService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.devtools.compile.service.impl.CompileServiceImpl")
public class CompileServiceImpl
implements CompileService {
    @Resource
    DevToolsProperties devToolsProperties;
    @Resource
    private ApplicationEventPublisherService eventPublisherService;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String TARGET_CLASSES_DIR = "\\target\\classes\\";
    private static final Logger LOGGER = LoggerFactory.getLogger(CompileServiceImpl.class);

    public void trigger(String applicationPath) {
        String triggerFilePath = PathUtil.posixPath((String[])new String[]{applicationPath, PathUtil.pathFormatterByOs((String)"\\src\\main\\resources\\.reloadtrigger")});
        try (FileWriter fileWriter = new FileWriter(triggerFilePath);){
            fileWriter.write(LocalDateTime.now().format(DateTimeFormatter.ofPattern(DATE_FORMAT)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ApiResponse<?> compile(String pkgName, String pathSegments) throws Exception {
        String javaCodePath = this.devToolsProperties.getJavaCodePath();
        String javaPath = this.devToolsProperties.getJavaPath();
        String applicationPath = PathUtil.posixPath((String[])new String[]{this.devToolsProperties.getWorkspace(), pathSegments, this.devToolsProperties.getBackProjectPath()});
        String sourceCodePath = PathUtil.posixPath((String[])new String[]{applicationPath, javaCodePath, javaPath});
        StringBuilder sourcePaths = new StringBuilder();
        if (ObjectUtils.isNotEmpty((Object)pkgName)) {
            String[] pkgnames = pkgName.split(",");
            for (int i = 0; i < pkgnames.length; ++i) {
                if (i != pkgnames.length - 1) {
                    sourcePaths.append(PathUtil.posixPath((String[])new String[]{sourceCodePath, pkgnames[i]})).append(",");
                    continue;
                }
                sourcePaths.append(PathUtil.posixPath((String[])new String[]{sourceCodePath, pkgnames[i]}));
            }
        } else {
            sourcePaths.append(sourceCodePath);
        }
        String targetClassPath = PathUtil.posixPath((String[])new String[]{applicationPath, PathUtil.pathFormatterByOs((String)TARGET_CLASSES_DIR)});
        String javaCodeAbsolute = PathUtil.posixPath((String[])new String[]{applicationPath, javaCodePath});
        DynamicCompiler.compile(sourcePaths.toString(), targetClassPath, javaCodeAbsolute, this.options(targetClassPath), () -> null, null);
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<?> compileModule(String workspace, String appCode, String pkgName, String pathSegments, String branch) throws Exception {
        PublishLogUtil.Log publishLog = new PublishLogUtil.Log(null, null, "\u7f16\u8bd1", "\u5f00\u59cb\u7f16\u8bd1\u540e\u7aef\u670d\u52a1...", null, "1", null, null, branch);
        PublishLogUtil.writePublishLog((PublishLogUtil.Log)publishLog);
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String modulePath = PathUtil.posixPath((String[])new String[]{workspace, pathSegments, tenantCode + "-web", appCode});
        String applicationPath = PathUtil.posixPath((String[])new String[]{workspace, pathSegments, tenantCode + "-web", this.devToolsProperties.getBackProjectPath()});
        String javaCodePath = this.devToolsProperties.getJavaCodePath();
        String javaPath = this.devToolsProperties.getJavaPath();
        String sourceCodePath = PathUtil.posixPath((String[])new String[]{modulePath, javaCodePath, javaPath});
        String moduleTargetPath = PathUtil.systemPath((String[])new String[]{modulePath, PathUtil.pathFormatterByOs((String)TARGET_CLASSES_DIR), javaPath});
        StringBuilder sourcePaths = new StringBuilder();
        StringBuilder targetPathsFoeDel = new StringBuilder();
        if (ObjectUtils.isNotEmpty((Object)pkgName)) {
            String[] pkgnames = pkgName.split(",");
            for (int i = 0; i < pkgnames.length; ++i) {
                if (i != pkgnames.length - 1) {
                    sourcePaths.append(PathUtil.posixPath((String[])new String[]{sourceCodePath, pkgnames[i]})).append(",");
                    targetPathsFoeDel.append(PathUtil.posixPath((String[])new String[]{moduleTargetPath, pkgnames[i]})).append(",");
                    continue;
                }
                sourcePaths.append(PathUtil.posixPath((String[])new String[]{sourceCodePath, pkgnames[i]}));
                targetPathsFoeDel.append(PathUtil.posixPath((String[])new String[]{moduleTargetPath, pkgnames[i]}));
            }
        } else {
            sourcePaths.append(sourceCodePath);
            targetPathsFoeDel.append(moduleTargetPath);
        }
        String targetClassPath = PathUtil.posixPath((String[])new String[]{modulePath, PathUtil.pathFormatterByOs((String)TARGET_CLASSES_DIR)});
        String javaCodeAbsolute = PathUtil.posixPath((String[])new String[]{modulePath, javaCodePath});
        this.trigger(applicationPath);
        DynamicCompiler.compile(sourcePaths.toString(), targetClassPath, javaCodeAbsolute, this.options(targetClassPath), () -> "", branch);
        PublishLogUtil.Log restartLog = new PublishLogUtil.Log(null, null, "\u542f\u52a8", "\u5f00\u59cb\u91cd\u542f\u540e\u7aef\u670d\u52a1...", null, "1", null, null, branch);
        PublishLogUtil.writeRestartServeLog((PublishLogUtil.Log)restartLog);
        return ApiResponse.success((Object)true);
    }

    private String deleteClass(StringBuilder targetPathsFoeDel) throws IOException {
        if (ObjectUtils.isEmpty((Object)targetPathsFoeDel)) {
            return "\u65e0\u9700\u5220\u9664class";
        }
        for (String del : targetPathsFoeDel.toString().split(",")) {
            LOGGER.info("\u7f16\u8bd1\u6210\u529f\u540e\u5220\u9664\u91cd\u590dclass\uff1a{}", (Object)del);
            FileUtils.forceDelete((File)new File(del));
        }
        return "\u5220\u9664\u6210\u529f";
    }

    private List<String> options(String targetClassPath) {
        LOGGER.info("java.home:{}", (Object)System.getProperty("java.home"));
        JavaCompiler cmp = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = cmp.getStandardFileManager(null, null, StandardCharsets.UTF_8);
        StringBuilder pathBuilder = new StringBuilder();
        Iterable<? extends File> location = fileManager.getLocation(StandardLocation.CLASS_PATH);
        for (File file : location) {
            String locationPath = file.getPath();
            if ("shortenClassPath.jar".equals(locationPath)) continue;
            pathBuilder.append(DynamicCompiler.cleanTemporaryDirectory(locationPath)).append(this.splitOs());
        }
        LOGGER.info("\u5f53\u524d\u7f16\u8bd1classPath\uff1a{}", (Object)pathBuilder);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(targetClassPath);
        options.add("-classpath");
        options.add(pathBuilder.toString());
        options.add("-encoding");
        options.add(StandardCharsets.UTF_8.name());
        return options;
    }

    private String splitOs() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return ";";
        }
        if (os.contains("nix") || os.contains("nux") || os.contains("aix") || os.contains("mac")) {
            return ":";
        }
        return ";";
    }

    public void stop() {
        this.eventPublisherService.publishStopEvent();
    }

    public ApiResponse<Boolean> aliveTry() {
        return ApiResponse.success((Object)true, (String)"\u6210\u529f\u8bbf\u95ee");
    }
}

