/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.devtools.compile.util;

import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.utils.ObjectUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicCompiler {
    private static final String KEY_JAVA_FILE = "javaFile";
    private static final String KEY_OTHER_FILE = "otherFile";
    private static final Logger logger = LoggerFactory.getLogger(DynamicCompiler.class);

    public static void compile(String sourceCodePath, String targetClassPath, String javaCodeAbsolute, List<String> options, Supplier<String> supplier) throws Exception {
        List<File> otherFiles;
        List<File> javaFiles;
        long start;
        block18: {
            start = System.currentTimeMillis();
            logger.info("\u5f00\u59cb\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u5939\uff1a{}", (Object)targetClassPath);
            DynamicCompiler.mkDirs(targetClassPath);
            logger.info("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u5939\u6210\u529f\uff01");
            logger.info("\u5f00\u59cb\u8bfb\u53d6\u6e90\u4ee3\u7801\uff1a{}", (Object)sourceCodePath);
            Map<String, List<File>> allFiles = DynamicCompiler.getFiles(sourceCodePath);
            logger.info("\u6e90\u4ee3\u7801\u8bfb\u53d6\u6210\u529f\uff01");
            javaFiles = allFiles.get(KEY_JAVA_FILE);
            otherFiles = allFiles.get(KEY_OTHER_FILE);
            if (ObjectUtil.isEmpty(javaFiles) || javaFiles.isEmpty()) {
                logger.error("\u8def\u5f84\u4e0b\u672a\u627e\u5230\u6e90\u6587\u4ef6\uff1a{}\uff01", (Object)sourceCodePath);
            } else {
                logger.info("\u5f00\u59cb\u8c03\u7528jdk\u52a8\u6001\u7f16\u8bd1\u5668\u8fdb\u884c\u7f16\u8bd1\u2026\u2026");
                JavaCompiler cmp = ToolProvider.getSystemJavaCompiler();
                try (StandardJavaFileManager fileManager = cmp.getStandardFileManager(null, null, StandardCharsets.UTF_8);){
                    Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(javaFiles);
                    DiagnosticCollector diagnosticListener = new DiagnosticCollector();
                    Boolean call = cmp.getTask(null, fileManager, diagnosticListener, options, null, compilationUnits).call();
                    if (call.booleanValue()) {
                        logger.info("jdk\u52a8\u6001\u7f16\u8bd1\u5668\u7f16\u8bd1\u6210\u529f\uff01");
                        break block18;
                    }
                    logger.error("jdk\u52a8\u6001\u7f16\u8bd1\u5668\u7f16\u8bd1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6e90\u7801\uff01");
                    for (Diagnostic diagnostic : diagnosticListener.getDiagnostics()) {
                        StringBuilder errBuilder = new StringBuilder();
                        errBuilder.append("\u6e90\u7801\u6587\u4ef6\uff1a").append(((JavaFileObject)diagnostic.getSource()).getName()).append(" ").append((Object)diagnostic.getKind()).append(" \u884c\uff1a").append(diagnostic.getLineNumber()).append("\uff1b\u5217\uff1a").append(diagnostic.getColumnNumber()).append(" ").append(diagnostic.getMessage(null));
                        logger.error(errBuilder.toString());
                    }
                    throw new HussarException("jdk\u52a8\u6001\u7f16\u8bd1\u5668\u7f16\u8bd1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6e90\u7801\uff01");
                }
                catch (Exception e) {
                    throw new HussarException("Java\u6e90\u7801\u7f16\u8bd1\u5931\u8d25", (Throwable)e);
                }
            }
        }
        logger.info("\u5f00\u59cb\u7f16\u8bd1\u975ejava\u6587\u4ef6");
        DynamicCompiler.copyOtherFiles(otherFiles, targetClassPath, javaCodeAbsolute);
        logger.info("\u975ejava\u6587\u4ef6\u7f16\u8bd1\u6210\u529f\uff01");
        logger.info("\u52a8\u6001\u7f16\u8bd1\u7ed3\u675f\uff0c\u7f16\u8bd1Java\u6587\u4ef6\u6570:{} \u4e2a\uff1b\u7f16\u8bd1\u975ejava\u6587\u4ef6\u6570\uff1a{} \u4e2a\uff0c\u603b\u8017\u65f6 : {} ms", new Object[]{javaFiles.size(), otherFiles.size(), System.currentTimeMillis() - start});
        supplier.get();
    }

    private static void copyOtherFiles(List<File> files, String dest, String javaCodeAbsolute) throws IOException {
        for (File file : files) {
            String fileAbsolutePath = file.getAbsolutePath();
            String destPath = dest + fileAbsolutePath.substring(javaCodeAbsolute.length());
            FileUtils.copyFile((File)file, (File)new File(destPath), (boolean)true);
        }
    }

    private static Map<String, List<File>> getFiles(String src) {
        ArrayList<File> files = new ArrayList<File>();
        for (String path : src.split(",")) {
            files.addAll(DynamicCompiler.getAllFiles(path));
        }
        String suffix = ".java";
        HashMap<String, List<File>> map = new HashMap<String, List<File>>();
        ArrayList<File> javaFile = new ArrayList<File>();
        ArrayList<File> otherFile = new ArrayList<File>();
        for (File file : files) {
            String fileName = file.getName();
            if (fileName.endsWith(suffix)) {
                javaFile.add(file);
                continue;
            }
            otherFile.add(file);
        }
        map.put(KEY_JAVA_FILE, javaFile);
        map.put(KEY_OTHER_FILE, otherFile);
        return map;
    }

    private static List<File> getAllFiles(String path) {
        ArrayList<File> files = new ArrayList<File>();
        File file = new File(path);
        if (file.exists() && !file.isHidden()) {
            if (file.isDirectory()) {
                File[] fs = file.listFiles();
                if (ObjectUtils.isNotEmpty((Object)fs)) {
                    for (File f : fs) {
                        if (file.isHidden()) continue;
                        if (f.isDirectory()) {
                            files.addAll(DynamicCompiler.getAllFiles(path + File.separator + f.getName()));
                        }
                        if (!f.isFile()) continue;
                        files.add(f);
                    }
                }
            } else if (file.isFile()) {
                files.add(file);
            }
        }
        return files;
    }

    private static void copy(String from, String to) {
        try (FileInputStream in = new FileInputStream(from);
             FileOutputStream out = new FileOutputStream(to);){
            int len;
            byte[] buff = new byte[1024];
            while ((len = ((InputStream)in).read(buff)) != -1) {
                ((OutputStream)out).write(buff, 0, len);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void mkDirs(String path) {
        File destFile = new File(path);
        if (!destFile.exists()) {
            destFile.mkdirs();
        }
    }

    public static String cleanTemporaryDirectory(String classPath) {
        String tempDirectory = String.format("%sfile:%s", System.getProperty("java.io.tmpdir"), File.separator);
        return classPath.replace(tempDirectory, "");
    }

    private String getJarFiles(String jarPath) {
        File sourceFile = new File(jarPath);
        String[] jars = new String[]{""};
        if (sourceFile.exists() && sourceFile.isDirectory()) {
            sourceFile.listFiles(pathname -> {
                if (pathname.isDirectory()) {
                    return true;
                }
                String name = pathname.getName();
                if (name.endsWith(".jar") && !pathname.getPath().contains("spring-cloud-openfeign-core-2.2.9.RELEASE.jar")) {
                    jars[0] = jars[0] + pathname.getPath() + ";";
                    return true;
                }
                return false;
            });
        }
        return jars[0];
    }
}

