/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.database.tool.sqlserver.filter;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.querysql.QuerySqlModel;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.dao.FormDesignBaseMapper;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.filter.SqlExecuteHandler;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlPublicMethodUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="datasource.sql_server")
public class SqlServerFilter
implements SqlExecuteHandler {
    private static final Logger logger = LoggerFactory.getLogger(SqlServerFilter.class);
    private static final String DEFAULT_SCHEMA = "dbo";
    @Resource
    private FormDesignBaseMapper formDesignBaseMapper;

    public List<TableInfo> selectBatch(DataSourceConfig dataSourceConfig, String type) {
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername().toUpperCase());
        if (dataSourceConfig.getSchemaname() != null) {
            dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname().toUpperCase());
        }
        String dbName = DEFAULT_SCHEMA;
        if (ToolUtil.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dbName);
        }
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        List tableList = this.formDesignBaseMapper.selectList(tableSql);
        List fieldList = this.formDesignBaseMapper.selectList(fieldSql);
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        return SqlPublicMethodUtil.combinedBatch(tableInfoList, fieldInfo);
    }

    public Optional<TableInfo> selectOne(DataSourceConfig dataSourceConfig, String type, String tableName) throws LcdpException {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return Optional.empty();
        }
        String tableSql = null;
        String fieldSql = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername().toUpperCase());
        if (dataSourceConfig.getSchemaname() != null) {
            dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname().toUpperCase());
        }
        String dbName = DEFAULT_SCHEMA;
        if (ToolUtil.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        tableSql = querySqlModel.getSingleTableTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        List tableList = this.formDesignBaseMapper.execute(tableSql);
        List fieldList = this.formDesignBaseMapper.execute(fieldSql);
        if (ToolUtil.isEmpty((Object)tableList)) {
            return Optional.empty();
        }
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        return Optional.ofNullable(SqlPublicMethodUtil.combined((TableInfo)((TableInfo)tableInfoList.get(0)), fieldInfo));
    }

    private void dealFieldResultMap(List<TableField> fieldInfo, List<Map<String, Object>> fieldList) {
        for (Map<String, Object> stringObjectMap : fieldList) {
            TableField tableField = new TableField();
            tableField.setTableName((String)stringObjectMap.get("TABLENAME"));
            tableField.setName((String)stringObjectMap.get("COLUMNNAME"));
            tableField.setComment((String)stringObjectMap.get("COMMENTS"));
            Object dataLength = Optional.ofNullable(stringObjectMap.get("DATALENGTH")).orElse("0");
            if ("nvarchar".equals(stringObjectMap.get("TTYPE")) && "-1".equals(dataLength)) {
                tableField.setType("nvarchar(max)");
            } else {
                tableField.setType((String)stringObjectMap.get("TTYPE"));
            }
            if ("nvarchar".equals(stringObjectMap.get("TTYPE"))) {
                tableField.setDataLength(Integer.parseInt(String.valueOf(dataLength)) / 2);
            } else {
                tableField.setDataLength(Integer.parseInt(String.valueOf(dataLength)));
            }
            tableField.setDataDefaultValue((String)stringObjectMap.get("DATADEFAULT"));
            tableField.setDataIsEmpty("0".equalsIgnoreCase((String)stringObjectMap.get("DATAISEMPTY")));
            tableField.setPrimarys((String)stringObjectMap.get("PRIMARYS"));
            tableField.setDataDot(Integer.parseInt(String.valueOf(stringObjectMap.get("DATADOT"))));
            fieldInfo.add(tableField);
        }
    }

    private void dealTableResultMap(List<TableInfo> tableInfoList, List<Map<String, Object>> tableResultSet) {
        tableResultSet.forEach(stringObjectMap -> {
            TableInfo tableInfo = new TableInfo();
            tableInfo.setName((String)stringObjectMap.get("NAME"));
            tableInfo.setComment((String)stringObjectMap.get("TCOMMENT"));
            String type = (String)stringObjectMap.get("TABLETYPE");
            tableInfo.setType(type);
            tableInfo.setView(!"BASE TABLE".equalsIgnoreCase(type));
            tableInfoList.add(tableInfo);
        });
    }
}

