/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.database.tool.oscar.filter;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.querysql.QuerySqlModel;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.dao.FormDesignBaseMapper;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.filter.SqlExecuteHandler;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableIndex;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlPublicMethodUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="datasource.oscar")
public class OscarFilter
implements SqlExecuteHandler {
    private static final Logger logger = LoggerFactory.getLogger(OscarFilter.class);
    @Resource
    private FormDesignBaseMapper formDesignBaseMapper;

    public List<TableInfo> selectBatch(DataSourceConfig dataSourceConfig, String type) {
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        ArrayList<TableIndex> indexInfo = new ArrayList<TableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername().toUpperCase());
        if (dataSourceConfig.getSchemaname() != null) {
            dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname().toUpperCase());
        }
        if (querySqlModel != null) {
            tableSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getTableSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getTableSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (querySqlModel != null) {
            fieldSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getFieldSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getFieldSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (querySqlModel != null) {
            indexSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getIndexSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getIndexSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "v").replace("${tableType1}", "v");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "r").replace("${tableType1}", "r");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "v").replace("${tableType1}", "r");
                }
            }
        }
        List tableList = this.formDesignBaseMapper.selectList(tableSql);
        List fieldList = this.formDesignBaseMapper.selectList(fieldSql);
        List indexList = this.formDesignBaseMapper.selectList(indexSql);
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return SqlPublicMethodUtil.combinedBatch(tableInfoList, fieldInfo, indexInfo);
    }

    public Optional<TableInfo> selectOne(DataSourceConfig dataSourceConfig, String type, String tableName) {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return Optional.empty();
        }
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername().toUpperCase());
        if (dataSourceConfig.getSchemaname() != null) {
            dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname().toUpperCase());
        }
        if (dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null) {
            tableSql = querySqlModel.getSingleTableTemplate().replace("${dbName}", dataSourceConfig.getUsername()).replace("${tableName}", tableName);
            fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dataSourceConfig.getUsername()).replace("${tableName}", tableName);
            indexSql = querySqlModel.getSingleIndexSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()).replace("${tableName}", tableName);
        } else {
            tableSql = querySqlModel.getSingleTableTemplate().replace("${dbName}", dataSourceConfig.getSchemaname()).replace("${tableName}", tableName);
            fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dataSourceConfig.getSchemaname()).replace("${tableName}", tableName);
            indexSql = querySqlModel.getSingleIndexSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname()).replace("${tableName}", tableName);
        }
        List tableList = this.formDesignBaseMapper.execute(tableSql);
        List fieldList = this.formDesignBaseMapper.execute(fieldSql);
        List indexList = this.formDesignBaseMapper.execute(indexSql);
        if (ToolUtil.isEmpty((Object)tableList)) {
            return Optional.empty();
        }
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        ArrayList<TableIndex> indexInfo = new ArrayList<TableIndex>();
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return Optional.ofNullable(SqlPublicMethodUtil.combined((TableInfo)((TableInfo)tableInfoList.get(0)), fieldInfo, indexInfo));
    }

    public List<TableInfo> selectTableBatch(DataSourceConfig dataSourceConfig, String type) throws LcdpException {
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate();
        }
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        if (ToolUtil.isEmpty((Object)querySqlModel)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_SUPPORT_DATA_BASE, dataSourceConfig.getUrl());
        }
        List tableList = this.formDesignBaseMapper.selectList(tableSql);
        if (tableList.size() <= 0) {
            return tableInfoList;
        }
        this.dealTableResultMap(tableInfoList, tableList);
        return tableInfoList;
    }

    public List<TableInfo> selectTableInfoBatch(DataSourceConfig dataSourceConfig, String type, List<String> tableNames) {
        List tableList;
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return tableInfoList;
        }
        dataSourceConfig.setUsername(dataSourceConfig.getUsername().toUpperCase());
        StringBuilder inTableName = new StringBuilder();
        if (HussarUtils.isEmpty(tableNames)) {
            return tableInfoList;
        }
        inTableName.append("'").append(tableNames.get(0)).append("'");
        for (int i = 1; i < tableNames.size(); ++i) {
            inTableName.append(",'").append(tableNames.get(i)).append("'");
        }
        String tableSql = querySqlModel.getTableBatchSqlTemplate().replace("${dbName}", dataSourceConfig.getDbName()).replace("${tableName}", inTableName);
        String fieldSql = querySqlModel.getFieldBatchSqlTemplate().replace("${dbName}", dataSourceConfig.getDbName()).replace("${tableName}", inTableName);
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        if (ToolUtil.isEmpty((Object)(tableList = this.formDesignBaseMapper.execute(tableSql)))) {
            return tableInfoList;
        }
        List fieldList = this.formDesignBaseMapper.execute(fieldSql);
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        return SqlPublicMethodUtil.combinedBatch(tableInfoList, fieldInfo, null);
    }

    private void dealFieldResultMap(List<TableField> fieldInfo, List<Map<String, Object>> fieldList) {
        for (Map<String, Object> stringObjectMap : fieldList) {
            TableField tableField = new TableField();
            tableField.setTableName((String)stringObjectMap.get("TABLENAME"));
            tableField.setName((String)stringObjectMap.get("COLUMNNAME"));
            tableField.setComment((String)stringObjectMap.get("COMMENTS"));
            String type = String.valueOf(stringObjectMap.get("TTYPE"));
            if ("BPCHAR".equals(type)) {
                type = "CHAR";
            }
            if ("HPFLOAT".equals(type)) {
                type = "FLOAT";
            }
            tableField.setType(type);
            Optional.ofNullable(stringObjectMap.get("DATADOT")).ifPresent(dataDto -> tableField.setDataDot(Integer.parseInt(String.valueOf(dataDto))));
            Integer dataLength = (Integer)Optional.ofNullable(stringObjectMap.get("DATALENGTH")).orElse(0);
            if ("NUMERIC".equals(type)) {
                dataLength = dataLength - 2;
            }
            if ("FLOAT".equals(type)) {
                dataLength = tableField.getDataDot();
            }
            tableField.setDataLength(Integer.parseInt(String.valueOf(dataLength)));
            if ("NUMERIC".equals(type) || "FLOAT".equals(type)) {
                tableField.setDataDot(0);
            }
            tableField.setDataDefaultValue((String)stringObjectMap.get("DATADEFAULT"));
            tableField.setDataIsEmpty("N".equalsIgnoreCase((String)stringObjectMap.get("DATAISEMPTY")));
            tableField.setPrimarys((String)stringObjectMap.get("PRIMARYS"));
            fieldInfo.add(tableField);
        }
    }

    private void dealIndexResultMap(List<TableIndex> indexInfo, List<Map<String, Object>> indexList) {
        if (HussarUtils.isEmpty(indexList)) {
            return;
        }
        for (Map<String, Object> stringObjectMap : indexList) {
            if (Integer.valueOf(stringObjectMap.get("ISPRIMARYINDEX").toString()) == 1) continue;
            TableIndex tableIndex = new TableIndex();
            tableIndex.setIndexName((String)stringObjectMap.get("INDEXNAME"));
            tableIndex.setIndexType((String)stringObjectMap.get("INDEXTYPE"));
            tableIndex.setTableName((String)stringObjectMap.get("TABLENAME"));
            tableIndex.setTableSchema((String)stringObjectMap.get("TABLESCHEMA"));
            tableIndex.setColumnName((String)stringObjectMap.get("COLUMNNAME"));
            tableIndex.setIsNonUnique(Integer.parseInt(stringObjectMap.get("ISNONUNIQUE").toString()));
            indexInfo.add(tableIndex);
        }
    }

    private void dealTableResultMap(List<TableInfo> tableInfoList, List<Map<String, Object>> tableResultSet) {
        tableResultSet.forEach(stringObjectMap -> {
            TableInfo tableInfo = new TableInfo();
            tableInfo.setName((String)stringObjectMap.get("NAME"));
            tableInfo.setComment((String)stringObjectMap.get("TCOMMENT"));
            String type = (String)stringObjectMap.get("TABLETYPE");
            tableInfo.setType(type);
            tableInfo.setView(!"BASE TABLE".equalsIgnoreCase(type));
            tableInfoList.add(tableInfo);
        });
    }
}

