/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.database.tool.kingbase.filter;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.querysql.QuerySqlModel;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.dao.FormDesignBaseMapper;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.filter.SqlExecuteHandler;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableIndex;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlPublicMethodUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="datasource.kingbase")
public class KingBaseFilter
implements SqlExecuteHandler {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseFilter.class);
    private static final String DEFAULT_SCHEMA = "public";
    @Resource
    private FormDesignBaseMapper formDesignBaseMapper;

    public List<TableInfo> selectBatch(DataSourceConfig dataSourceConfig, String type) {
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        ArrayList<TableIndex> indexInfo = new ArrayList<TableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        String dbName = DEFAULT_SCHEMA;
        if (ToolUtil.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dbName);
            indexSql = querySqlModel.getIndexSqlTemplate().replace("${dbName}", dbName);
            tableSqlWithTask = querySqlModel.getTableSqlWithTaskTemplate();
        }
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        List tableList = this.formDesignBaseMapper.selectList(tableSql);
        List fieldList = this.formDesignBaseMapper.selectList(fieldSql);
        List indexList = this.formDesignBaseMapper.selectList(indexSql);
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return SqlPublicMethodUtil.combinedBatch(tableInfoList, fieldInfo, indexInfo);
    }

    public Optional<TableInfo> selectOne(DataSourceConfig dataSourceConfig, String type, String tableName) {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return Optional.empty();
        }
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        String dbName = DEFAULT_SCHEMA;
        if (ToolUtil.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        tableSql = querySqlModel.getSingleTableTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        indexSql = querySqlModel.getSingleIndexSqlTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        List tableList = this.formDesignBaseMapper.execute(tableSql);
        List fieldList = this.formDesignBaseMapper.execute(fieldSql);
        List indexList = this.formDesignBaseMapper.execute(indexSql);
        if (ToolUtil.isEmpty((Object)tableList)) {
            return Optional.empty();
        }
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        ArrayList<TableIndex> indexInfo = new ArrayList<TableIndex>();
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return Optional.ofNullable(SqlPublicMethodUtil.combined((TableInfo)((TableInfo)tableInfoList.get(0)), fieldInfo, indexInfo));
    }

    public List<TableInfo> selectTableBatch(DataSourceConfig dataSourceConfig, String type) throws LcdpException {
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate();
        }
        String dbName = DEFAULT_SCHEMA;
        if (ToolUtil.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        tableSql = tableSql.replace("${dbName}", dbName);
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        if (ToolUtil.isEmpty((Object)querySqlModel)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_SUPPORT_DATA_BASE, dataSourceConfig.getUrl());
        }
        List tableList = this.formDesignBaseMapper.selectList(tableSql);
        if (tableList.size() <= 0) {
            return tableInfoList;
        }
        this.dealTableResultMap(tableInfoList, tableList);
        return tableInfoList;
    }

    public List<TableInfo> selectTableInfoBatch(DataSourceConfig dataSourceConfig, String type, List<String> tableNames) {
        List tableList;
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return tableInfoList;
        }
        dataSourceConfig.setUsername(dataSourceConfig.getUsername().toUpperCase());
        StringBuilder inTableName = new StringBuilder();
        if (HussarUtils.isEmpty(tableNames)) {
            return tableInfoList;
        }
        inTableName.append("'").append(tableNames.get(0)).append("'");
        for (int i = 1; i < tableNames.size(); ++i) {
            inTableName.append(",'").append(tableNames.get(i)).append("'");
        }
        String tableSql = querySqlModel.getTableBatchSqlTemplate().replace("${dbName}", dataSourceConfig.getDbName()).replace("${tableName}", inTableName);
        String fieldSql = querySqlModel.getFieldBatchSqlTemplate().replace("${dbName}", dataSourceConfig.getDbName()).replace("${tableName}", inTableName);
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        if (ToolUtil.isEmpty((Object)(tableList = this.formDesignBaseMapper.execute(tableSql)))) {
            return tableInfoList;
        }
        List fieldList = this.formDesignBaseMapper.execute(fieldSql);
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        return SqlPublicMethodUtil.combinedBatch(tableInfoList, fieldInfo, null);
    }

    private void dealFieldResultMap(List<TableField> fieldInfo, List<Map<String, Object>> fieldList) {
        for (Map<String, Object> stringObjectMap : fieldList) {
            TableField tableField = new TableField();
            tableField.setTableName((String)stringObjectMap.get("table_name"));
            tableField.setName((String)stringObjectMap.get("column_name"));
            tableField.setComment((String)stringObjectMap.get("des"));
            String type = String.valueOf(stringObjectMap.get("data_type"));
            String precision = String.valueOf(stringObjectMap.get("datetime_precision"));
            switch (type) {
                case "boolean": {
                    type = "BOOLEAN";
                    break;
                }
                case "bpchar": {
                    type = "CHAR";
                    break;
                }
                case "varchar": {
                    type = "VARCHAR";
                    break;
                }
                case "text": {
                    type = "TEXT";
                    break;
                }
                case "numeric": {
                    type = "NUMERIC";
                    break;
                }
                case "real": {
                    type = "FLOAT4";
                    break;
                }
                case "double precision": {
                    type = "FLOAT8";
                    break;
                }
                case "date": {
                    type = "DATE";
                    break;
                }
                case "time without time zone": {
                    type = "TIME";
                    break;
                }
                case "timestamp without time zone": {
                    if ("0".equals(precision)) {
                        type = "DATE";
                        break;
                    }
                    type = "TIMESTAMP";
                    break;
                }
            }
            tableField.setType(type);
            Object dataLength = Optional.ofNullable(stringObjectMap.get("collength")).orElse("0");
            switch (type) {
                case "BOOLEAN": {
                    dataLength = 1;
                    break;
                }
                case "TEXT": {
                    dataLength = 0;
                    break;
                }
                case "FLOAT4": {
                    dataLength = 7;
                    break;
                }
                case "FLOAT8": {
                    dataLength = 15;
                    break;
                }
                case "DATE": {
                    dataLength = 8;
                    break;
                }
                case "TIME": {
                    dataLength = 8;
                    break;
                }
                case "TIMESTAMP": {
                    dataLength = 8;
                    break;
                }
            }
            tableField.setDataLength(Integer.parseInt(String.valueOf(dataLength)));
            tableField.setDataDefaultValue((String)stringObjectMap.get("defaultvalue"));
            tableField.setDataIsEmpty((Integer)stringObjectMap.get("isempty") == 0);
            tableField.setPrimarys((Integer)stringObjectMap.get("pk_id") == 0 ? null : "PRI");
            Optional.ofNullable(stringObjectMap.get("numeric_scale")).ifPresent(dataDto -> tableField.setDataDot(Integer.parseInt(String.valueOf(dataDto))));
            fieldInfo.add(tableField);
        }
    }

    private void dealIndexResultMap(List<TableIndex> indexInfo, List<Map<String, Object>> indexList) {
        if (HussarUtils.isEmpty(indexList)) {
            return;
        }
        for (int i = 0; i < indexList.size(); ++i) {
            if (Integer.valueOf(indexList.get(i).get("isprimarykey").toString()) == 1) continue;
            TableIndex tableIndex = new TableIndex();
            tableIndex.setIndexName((String)indexList.get(i).get("indexname"));
            tableIndex.setIndexType((String)indexList.get(i).get("indextype"));
            tableIndex.setTableName((String)indexList.get(i).get("tablename"));
            tableIndex.setTableSchema((String)indexList.get(i).get("tableschema"));
            tableIndex.setColumnName((String)indexList.get(i).get("columnname"));
            tableIndex.setIsNonUnique(Integer.parseInt(indexList.get(i).get("isnonunique").toString()));
            indexInfo.add(tableIndex);
        }
    }

    private void dealTableResultMap(List<TableInfo> tableInfoList, List<Map<String, Object>> tableResultSet) {
        tableResultSet.forEach(stringObjectMap -> {
            TableInfo tableInfo = new TableInfo();
            tableInfo.setName((String)stringObjectMap.get("name"));
            tableInfo.setComment((String)stringObjectMap.get("comment"));
            String type = (String)stringObjectMap.get("type");
            tableInfo.setType(type);
            tableInfo.setView(!"BASE TABLE".equalsIgnoreCase(type));
            tableInfoList.add(tableInfo);
        });
    }
}

