/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.database.tool.kingbase.filter;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.querysql.QuerySqlModel;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.dao.FormDesignBaseMapper;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.filter.SqlExecuteHandler;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlPublicMethodUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="datasource.kingbase")
public class KingBaseFilter
implements SqlExecuteHandler {
    private static final Logger logger = LoggerFactory.getLogger(KingBaseFilter.class);
    @Resource
    private FormDesignBaseMapper formDesignBaseMapper;

    public List<TableInfo> selectBatch(DataSourceConfig dataSourceConfig, String type) {
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername());
        }
        if (querySqlModel != null) {
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername());
        }
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        List tableList = this.formDesignBaseMapper.selectList(tableSql);
        List fieldList = this.formDesignBaseMapper.selectList(fieldSql);
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        return SqlPublicMethodUtil.combinedBatch(tableInfoList, fieldInfo);
    }

    public Optional<TableInfo> selectOne(DataSourceConfig dataSourceConfig, String type, String tableName) {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return Optional.empty();
        }
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        String tableSql = querySqlModel.getSingleTableTemplate().replace("${dbName}", dataSourceConfig.getUsername()).replace("${tableName}", tableName);
        String fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dataSourceConfig.getUsername()).replace("${tableName}", tableName);
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        List tableList = this.formDesignBaseMapper.execute(tableSql);
        List fieldList = this.formDesignBaseMapper.execute(fieldSql);
        if (ToolUtil.isEmpty((Object)tableList)) {
            return Optional.empty();
        }
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        return Optional.ofNullable(SqlPublicMethodUtil.combined((TableInfo)((TableInfo)tableInfoList.get(0)), fieldInfo));
    }

    private void dealFieldResultMap(List<TableField> fieldInfo, List<Map<String, Object>> fieldList) {
        for (Map<String, Object> stringObjectMap : fieldList) {
            TableField tableField = new TableField();
            tableField.setTableName((String)stringObjectMap.get("table_name"));
            tableField.setName((String)stringObjectMap.get("column_name"));
            tableField.setComment((String)stringObjectMap.get("des"));
            String type = String.valueOf(stringObjectMap.get("data_type"));
            String precision = String.valueOf(stringObjectMap.get("datetime_precision"));
            switch (type) {
                case "boolean": {
                    type = "BOOLEAN";
                    break;
                }
                case "bpchar": {
                    type = "CHAR";
                    break;
                }
                case "varchar": {
                    type = "VARCHAR";
                    break;
                }
                case "text": {
                    type = "TEXT";
                    break;
                }
                case "numeric": {
                    type = "NUMERIC";
                    break;
                }
                case "real": {
                    type = "FLOAT4";
                    break;
                }
                case "double precision": {
                    type = "FLOAT8";
                    break;
                }
                case "date": {
                    type = "DATE";
                    break;
                }
                case "time without time zone": {
                    type = "TIME";
                    break;
                }
                case "timestamp without time zone": {
                    if ("0".equals(precision)) {
                        type = "DATE";
                        break;
                    }
                    type = "TIMESTAMP";
                    break;
                }
            }
            tableField.setType(type);
            Object dataLength = Optional.ofNullable(stringObjectMap.get("collength")).orElse("0");
            switch (type) {
                case "BOOLEAN": {
                    dataLength = 1;
                    break;
                }
                case "TEXT": {
                    dataLength = 0;
                    break;
                }
                case "FLOAT4": {
                    dataLength = 7;
                    break;
                }
                case "FLOAT8": {
                    dataLength = 15;
                    break;
                }
                case "DATE": {
                    dataLength = 8;
                    break;
                }
                case "TIME": {
                    dataLength = 8;
                    break;
                }
                case "TIMESTAMP": {
                    dataLength = 8;
                    break;
                }
            }
            tableField.setDataLength(Integer.parseInt(String.valueOf(dataLength)));
            tableField.setDataDefaultValue((String)stringObjectMap.get("defaultvalue"));
            tableField.setDataIsEmpty((Integer)stringObjectMap.get("isempty") == 0);
            tableField.setPrimarys((Integer)stringObjectMap.get("pk_id") == 0 ? null : "PRI");
            Optional.ofNullable(stringObjectMap.get("numeric_scale")).ifPresent(dataDto -> tableField.setDataDot(Integer.parseInt(String.valueOf(dataDto))));
            fieldInfo.add(tableField);
        }
    }

    private void dealTableResultMap(List<TableInfo> tableInfoList, List<Map<String, Object>> tableResultSet) {
        tableResultSet.forEach(stringObjectMap -> {
            TableInfo tableInfo = new TableInfo();
            tableInfo.setName((String)stringObjectMap.get("name"));
            tableInfo.setComment((String)stringObjectMap.get("comment"));
            String type = (String)stringObjectMap.get("type");
            tableInfo.setType(type);
            tableInfo.setView(!"BASE TABLE".equalsIgnoreCase(type));
            tableInfoList.add(tableInfo);
        });
    }
}

