/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.database.tool.hg.filter;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.querysql.QuerySqlModel;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.dao.FormDesignBaseMapper;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.filter.SqlExecuteHandler;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlPublicMethodUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="datasource.highgo")
public class HgFilter
implements SqlExecuteHandler {
    private static final Logger logger = LoggerFactory.getLogger(HgFilter.class);
    @Resource
    private FormDesignBaseMapper formDesignBaseMapper;

    public List<TableInfo> selectBatch(DataSourceConfig dataSourceConfig, String type) {
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        if (querySqlModel != null) {
            tableSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getTableSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getTableSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (querySqlModel != null) {
            fieldSql = dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null ? querySqlModel.getFieldSqlTemplate().replace("${dbName}", dataSourceConfig.getUsername()) : querySqlModel.getFieldSqlTemplate().replace("${dbName}", dataSourceConfig.getSchemaname());
        }
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        List tableList = this.formDesignBaseMapper.selectList(tableSql);
        List fieldList = this.formDesignBaseMapper.selectList(fieldSql);
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        return SqlPublicMethodUtil.combinedBatch(tableInfoList, fieldInfo);
    }

    public Optional<TableInfo> selectOne(DataSourceConfig dataSourceConfig, String type, String tableName) {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return Optional.empty();
        }
        String tableSql = null;
        String fieldSql = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        if (dataSourceConfig.getUsername().equals(dataSourceConfig.getSchemaname()) || "".equals(dataSourceConfig.getSchemaname()) || dataSourceConfig.getSchemaname() == null) {
            tableSql = querySqlModel.getSingleTableTemplate().replace("${dbName}", dataSourceConfig.getUsername()).replace("${tableName}", tableName);
            fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dataSourceConfig.getUsername()).replace("${tableName}", tableName);
        } else {
            tableSql = querySqlModel.getSingleTableTemplate().replace("${dbName}", dataSourceConfig.getSchemaname()).replace("${tableName}", tableName);
            fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dataSourceConfig.getSchemaname()).replace("${tableName}", tableName);
        }
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        List tableList = this.formDesignBaseMapper.execute(tableSql);
        List fieldList = this.formDesignBaseMapper.execute(fieldSql);
        if (ToolUtil.isEmpty((Object)tableList)) {
            return Optional.empty();
        }
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        return Optional.ofNullable(SqlPublicMethodUtil.combined((TableInfo)((TableInfo)tableInfoList.get(0)), fieldInfo));
    }

    private void dealFieldResultMap(List<TableField> fieldInfo, List<Map<String, Object>> fieldList) {
        for (Map<String, Object> stringObjectMap : fieldList) {
            TableField tableField = new TableField();
            tableField.setTableName((String)stringObjectMap.get("table_name"));
            tableField.setName((String)stringObjectMap.get("column_name"));
            tableField.setComment((String)stringObjectMap.get("des"));
            String type = String.valueOf(stringObjectMap.get("data_type"));
            if ("real".equals(type)) {
                type = "FLOAT4";
            }
            if ("double precision".equals(type)) {
                type = "FLOAT8";
            }
            if ("time without time zone".equals(type)) {
                type = "TIME";
            }
            if ("timestamp without time zone".equals(type)) {
                type = "TIMESTAMP";
            }
            if ("character varying".equals(type)) {
                type = "VARCHAR";
            }
            if ("character".equals(type)) {
                type = "BPCHAR";
            }
            tableField.setType(type);
            Object dataLength = Optional.ofNullable(stringObjectMap.get("collength")).orElse("0");
            tableField.setDataLength(Integer.parseInt(String.valueOf(dataLength)));
            tableField.setDataDefaultValue((String)stringObjectMap.get("defaultvalue"));
            tableField.setDataIsEmpty(0 == (Integer)stringObjectMap.get("isempty"));
            tableField.setPrimarys((Integer)stringObjectMap.get("pk_id") == 0 ? null : "PRI");
            Optional.ofNullable(stringObjectMap.get("numeric_scale")).ifPresent(dataDto -> tableField.setDataDot(Integer.parseInt(String.valueOf(dataDto))));
            fieldInfo.add(tableField);
        }
    }

    private void dealTableResultMap(List<TableInfo> tableInfoList, List<Map<String, Object>> tableResultSet) {
        tableResultSet.forEach(stringObjectMap -> {
            TableInfo tableInfo = new TableInfo();
            tableInfo.setName((String)stringObjectMap.get("name"));
            tableInfo.setComment((String)stringObjectMap.get("comment"));
            String type = (String)stringObjectMap.get("type");
            tableInfo.setType(type);
            tableInfo.setView(!"BASE TABLE".equalsIgnoreCase(type));
            tableInfoList.add(tableInfo);
        });
    }
}

