/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.database.tool.gauss.filter;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.querysql.QuerySqlModel;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.dao.FormDesignBaseMapper;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.filter.SqlExecuteHandler;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableIndex;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlPublicMethodUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="datasource.gauss")
public class GaussFilter
implements SqlExecuteHandler {
    private static final Logger logger = LoggerFactory.getLogger(GaussFilter.class);
    private static final String DEFAULT_SCHEMA = "public";
    @Resource
    private FormDesignBaseMapper formDesignBaseMapper;

    public List<TableInfo> selectBatch(DataSourceConfig dataSourceConfig, String type) {
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        ArrayList<TableIndex> indexInfo = new ArrayList<TableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        String dbName = DEFAULT_SCHEMA;
        if (ToolUtil.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
        }
        if (querySqlModel != null) {
            tableSqlWithTask = querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dbName);
        }
        if (querySqlModel != null) {
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dbName);
        }
        if (querySqlModel != null) {
            indexSql = querySqlModel.getIndexSqlTemplate().replace("${dbName}", dbName);
        }
        if (ToolUtil.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    if (tableSqlWithTask == null) break;
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        List tableList = this.formDesignBaseMapper.selectList(tableSql);
        List fieldList = this.formDesignBaseMapper.selectList(fieldSql);
        List<Map<String, Object>> indexList = null;
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return SqlPublicMethodUtil.combinedBatch(tableInfoList, fieldInfo, indexInfo);
    }

    public Optional<TableInfo> selectOne(DataSourceConfig dataSourceConfig, String type, String tableName) {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return Optional.empty();
        }
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        dataSourceConfig.setUsername(dataSourceConfig.getUsername());
        dataSourceConfig.setSchemaname(dataSourceConfig.getSchemaname());
        String dbName = DEFAULT_SCHEMA;
        if (ToolUtil.isNotEmpty((Object)dataSourceConfig.getSchemaname())) {
            dbName = dataSourceConfig.getSchemaname();
        }
        tableSql = querySqlModel.getSingleTableTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        indexSql = querySqlModel.getSingleIndexSqlTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        List tableList = this.formDesignBaseMapper.execute(tableSql);
        List fieldList = this.formDesignBaseMapper.execute(fieldSql);
        List<Map<String, Object>> indexList = null;
        if (ToolUtil.isEmpty((Object)tableList)) {
            return Optional.empty();
        }
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        ArrayList<TableIndex> indexInfo = new ArrayList<TableIndex>();
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return Optional.ofNullable(SqlPublicMethodUtil.combined((TableInfo)((TableInfo)tableInfoList.get(0)), fieldInfo, indexInfo));
    }

    public List<TableInfo> selectTableBatch(DataSourceConfig dataSourceConfig, String type) throws LcdpException {
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate();
        }
        if (ToolUtil.isNotEmpty((Object)type) && tableSql != null) {
            tableSql = tableSql.replace("${dbName}", dataSourceConfig.getDbName());
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        if (ToolUtil.isEmpty((Object)querySqlModel)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_SUPPORT_DATA_BASE, dataSourceConfig.getUrl());
        }
        List tableList = this.formDesignBaseMapper.selectList(tableSql);
        if (tableList.size() <= 0) {
            return tableInfoList;
        }
        this.dealTableResultMap(tableInfoList, tableList);
        return tableInfoList;
    }

    public List<TableInfo> selectTableInfoBatch(DataSourceConfig dataSourceConfig, String type, List<String> tableNames) {
        List tableList;
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return tableInfoList;
        }
        dataSourceConfig.setUsername(dataSourceConfig.getUsername().toUpperCase());
        StringBuilder inTableName = new StringBuilder();
        if (HussarUtils.isEmpty(tableNames)) {
            return tableInfoList;
        }
        inTableName.append("'").append(tableNames.get(0)).append("'");
        for (int i = 1; i < tableNames.size(); ++i) {
            inTableName.append(",'").append(tableNames.get(i)).append("'");
        }
        String tableSql = querySqlModel.getTableBatchSqlTemplate().replace("${dbName}", dataSourceConfig.getDbName()).replace("${tableName}", inTableName);
        String fieldSql = querySqlModel.getFieldBatchSqlTemplate().replace("${dbName}", dataSourceConfig.getDbName()).replace("${tableName}", inTableName);
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        if (ToolUtil.isEmpty((Object)(tableList = this.formDesignBaseMapper.execute(tableSql)))) {
            return tableInfoList;
        }
        List fieldList = this.formDesignBaseMapper.execute(fieldSql);
        this.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        return SqlPublicMethodUtil.combinedBatch(tableInfoList, fieldInfo, null);
    }

    private void dealFieldResultMap(List<TableField> fieldInfo, List<Map<String, Object>> fieldList) {
        for (Map<String, Object> stringObjectMap : fieldList) {
            TableField tableField = new TableField();
            tableField.setTableName((String)stringObjectMap.get("table_name"));
            tableField.setName((String)stringObjectMap.get("column_name"));
            tableField.setComment((String)stringObjectMap.get("des"));
            String type = String.valueOf(stringObjectMap.get("data_type"));
            if ("real".equals(type)) {
                type = "FLOAT4";
            }
            if ("double precision".equals(type)) {
                type = "FLOAT8";
            }
            if ("time without time zone".equals(type)) {
                type = "TIME";
            }
            if ("timestamp without time zone".equals(type)) {
                type = "TIMESTAMP";
            }
            if ("character varying".equals(type)) {
                type = "VARCHAR";
            }
            if ("character".equals(type)) {
                type = "BPCHAR";
            }
            tableField.setType(type);
            Object dataLength = Optional.ofNullable(stringObjectMap.get("collength")).orElse("0");
            tableField.setDataLength(Integer.parseInt(String.valueOf(dataLength)));
            tableField.setDataDefaultValue((String)stringObjectMap.get("defaultvalue"));
            tableField.setDataIsEmpty(0 == (Integer)stringObjectMap.get("isempty"));
            tableField.setPrimarys((Integer)stringObjectMap.get("pk_id") == 0 ? null : "PRI");
            Optional.ofNullable(stringObjectMap.get("numeric_scale")).ifPresent(dataDto -> tableField.setDataDot(Integer.parseInt(String.valueOf(dataDto))));
            fieldInfo.add(tableField);
        }
    }

    private void dealIndexResultMap(List<TableIndex> indexInfo, List<Map<String, Object>> indexList) {
        if (HussarUtils.isEmpty(indexList)) {
            return;
        }
        for (int i = 0; i < indexList.size(); ++i) {
            TableIndex tableIndex = new TableIndex();
            tableIndex.setIndexName((String)indexList.get(i).get("index_name"));
            tableIndex.setIndexType((String)indexList.get(i).get("index_type"));
            tableIndex.setTableName((String)indexList.get(i).get("table_name"));
            tableIndex.setTableSchema((String)indexList.get(i).get("table_schema"));
            tableIndex.setColumnName((String)indexList.get(i).get("column_name"));
            tableIndex.setIsNonUnique((Boolean)indexList.get(i).get("is_non_unique") != false ? 1 : 0);
            indexInfo.add(tableIndex);
        }
    }

    private void dealTableResultMap(List<TableInfo> tableInfoList, List<Map<String, Object>> tableResultSet) {
        tableResultSet.forEach(stringObjectMap -> {
            TableInfo tableInfo = new TableInfo();
            tableInfo.setName((String)stringObjectMap.get("name"));
            tableInfo.setComment((String)stringObjectMap.get("comment"));
            String type = (String)stringObjectMap.get("type");
            tableInfo.setType(type);
            tableInfo.setView(!"BASE TABLE".equalsIgnoreCase(type));
            tableInfoList.add(tableInfo);
        });
    }
}

