/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import com.jxdinfo.hussar.formdesign.common.model.vuecode.CommentDirective;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class SectionGenerateUtil {
    private static final char[] ID_FORBIDDEN_CHARACTERS = new char[]{' ', '#', '\t', '\f', '\r', '\n', '\u000b'};
    private static final char[] NEWLINE_CHARACTERS = new char[]{'\r', '\n'};
    private static final String VUE_COMPONENT_COMMENT_OPEN = "<!-- ";
    private static final String VUE_COMPONENT_COMMENT_CLOSE = " -->";

    public static String wrapVueComponent(String id, String renderCode, String instanceKey, String description) {
        StringBuilder builder = new StringBuilder();
        String indent = CodeSplitUtil.indentOf(renderCode);
        String commentInstanceKey = instanceKey != null ? "[" + instanceKey + "]" : "";
        String commentBegin = Stream.of(commentInstanceKey, StringUtils.defaultString((String)description)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(" "));
        DirectivePair directives = SectionGenerateUtil.makeDirectivePair("custom:", id, true, commentBegin, commentInstanceKey);
        builder.append(indent);
        builder.append(VUE_COMPONENT_COMMENT_OPEN);
        builder.append(directives.getBegin());
        builder.append(VUE_COMPONENT_COMMENT_CLOSE);
        builder.append(System.lineSeparator());
        builder.append(StringUtils.defaultString((String)renderCode));
        if (!renderCode.endsWith("\n") && !renderCode.endsWith("\r") && StringUtils.isNotEmpty((CharSequence)renderCode)) {
            builder.append(System.lineSeparator());
        }
        builder.append(indent);
        builder.append(VUE_COMPONENT_COMMENT_OPEN);
        builder.append(directives.getEnd());
        builder.append(VUE_COMPONENT_COMMENT_CLOSE);
        builder.append(System.lineSeparator());
        return builder.toString();
    }

    public static DirectivePair customSlotDirectivePair(String id, boolean merge, String description) {
        return SectionGenerateUtil.makeDirectivePair("custom:slot:", id, merge, description, null);
    }

    public static DirectivePair customBlockDirectivePair(String id, boolean merge, String description) {
        return SectionGenerateUtil.makeDirectivePair("custom:block:", id, merge, description, null);
    }

    private static DirectivePair makeDirectivePair(String prefix, String id, boolean merge, String beginComment, String endComment) {
        if (StringUtils.isEmpty((CharSequence)id) || StringUtils.containsAny((CharSequence)id, (char[])ID_FORBIDDEN_CHARACTERS)) {
            throw new IllegalArgumentException("\u9884\u7559\u533a\u57df\u6807\u8bc6\u7b26\u975e\u6cd5: " + id);
        }
        if (StringUtils.containsAny((CharSequence)beginComment, (char[])NEWLINE_CHARACTERS)) {
            throw new IllegalArgumentException("\u9884\u7559\u533a\u57df\u8bf4\u660e\u975e\u6cd5: " + beginComment);
        }
        if (StringUtils.containsAny((CharSequence)endComment, (char[])NEWLINE_CHARACTERS)) {
            throw new IllegalArgumentException("\u9884\u7559\u533a\u57df\u8bf4\u660e\u975e\u6cd5: " + endComment);
        }
        CommentDirective begin = new CommentDirective("begin");
        if (merge) {
            begin.putFlag("merge", "");
        }
        begin.putArgument(prefix + id);
        begin.setComment(beginComment);
        CommentDirective end = new CommentDirective("end");
        end.putArgument(prefix + id);
        end.setComment(endComment);
        return new DirectivePair(begin.represent(), end.represent());
    }

    public static class DirectivePair {
        private String begin;
        private String end;

        public DirectivePair() {
        }

        public DirectivePair(String begin, String end) {
            this.begin = begin;
            this.end = end;
        }

        public String getBegin() {
            return this.begin;
        }

        public void setBegin(String begin) {
            this.begin = begin;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }
    }
}

