/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.runner.log;

import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.runner.log.RuntimeLog;
import com.jxdinfo.hussar.formdesign.common.runner.log.RuntimeLogEvent;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class RuntimeLogger {
    public static final String CACHE_NAME = "runtime_log";
    public static final String CACHE_KEY_PUBLISH = "runtime_log_publish";
    public static final String CACHE_KEY_SERVER = "runtime_log_server";

    public static void publish(String runType, String status) {
        RuntimeLogEvent runtimeLogEvent = new RuntimeLogEvent(runType, status, "RuntimeStatusEnum.getLog(status)");
        Collection<RuntimeLogEvent> runtimeLogEvents = RuntimeLogger.get(CACHE_KEY_PUBLISH);
        if (ObjectUtils.isEmpty(runtimeLogEvents)) {
            runtimeLogEvents = new ArrayList<RuntimeLogEvent>();
            RuntimeLogger.put(CACHE_KEY_PUBLISH, runtimeLogEvents);
        }
        runtimeLogEvents.add(runtimeLogEvent);
        RuntimeLogger.clear(CACHE_KEY_PUBLISH);
        RuntimeLogger.put(CACHE_KEY_PUBLISH, runtimeLogEvents);
    }

    public static RuntimeLog get(long currentTimestamp, long lastTimestamp) {
        Collection events = (Collection)HussarCacheUtil.get((String)CACHE_NAME, (Object)CACHE_KEY_PUBLISH, Collection.class);
        if (ObjectUtils.isEmpty((Object)events)) {
            return new RuntimeLog();
        }
        List sortedByTime = events.stream().sorted(Comparator.comparingLong(RuntimeLogEvent::getTimestamp)).collect(Collectors.toList());
        List<RuntimeLogEvent> currentEvents = sortedByTime.stream().filter(runtimeLogEvent -> runtimeLogEvent.getTimestamp() > lastTimestamp && runtimeLogEvent.getTimestamp() <= currentTimestamp).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(currentEvents)) {
            return new RuntimeLog();
        }
        RuntimeLogEvent lastEvent = (RuntimeLogEvent)currentEvents.get(currentEvents.size() - 1);
        if (RuntimeLogger.anyMatch(lastEvent.getStatus(), "PUBLISH_SUCCEED", "PUBLISH_FAILED")) {
            return new RuntimeLog(RuntimeLogger.app(), lastEvent.getStatus(), currentEvents);
        }
        return new RuntimeLog(RuntimeLogger.app(), "PUBLISH_EXECUTING", currentEvents);
    }

    public static boolean allMatch(String target, String ... conditions) {
        boolean and = true;
        for (String condition : conditions) {
            and = and && target.equals(condition);
        }
        return and;
    }

    private static boolean anyMatch(String target, String ... conditions) {
        boolean or = false;
        for (String condition : conditions) {
            or = or || target.equals(condition);
        }
        return or;
    }

    public static void clear(String type) {
        HussarCacheUtil.evict((String)CACHE_NAME, (Object)type);
    }

    private static Collection<RuntimeLogEvent> get(String type) {
        return (Collection)HussarCacheUtil.get((String)CACHE_NAME, (Object)type, Collection.class);
    }

    private static void put(String type, Collection<RuntimeLogEvent> runtimeLogEvents) {
        HussarCacheUtil.put((String)CACHE_NAME, (Object)type, runtimeLogEvents);
    }

    private static String app() {
        String appName = null;
        try {
            ISysApplicationBoService app = (ISysApplicationBoService)SpringContextHolder.getBean(ISysApplicationBoService.class);
            if (ObjectUtils.isNotEmpty((Object)AppContextUtil.getAppId())) {
                SysApplicationVo appDetail = app.getAppDetail(Long.valueOf(AppContextUtil.getAppId()));
                appName = ObjectUtils.isNotEmpty((Object)appDetail) ? appDetail.getAppName() : "";
            }
        }
        catch (Exception e) {
            appName = "";
        }
        return appName;
    }
}

