/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageConfiguration;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageEntity;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CodeEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class StorageServiceOfflineImpl
implements StorageService {
    private static final Logger logger = LoggerFactory.getLogger(StorageServiceOfflineImpl.class);
    private static final String ATTRIBUTE_WORKSPACE_REFRESHED = "storageWorkspaceRefreshed";
    private final String root;
    private final StorageCache cache;
    private final StorageConfiguration config;

    public StorageServiceOfflineImpl(String root, StorageConfiguration config) {
        this.root = root;
        this.cache = new StorageCache(root);
        this.config = config;
    }

    public StorageResult<Boolean> uploadByPath(String path, byte[] content, boolean retry) {
        CacheEntry entry;
        if (path == null || content == null) {
            throw new NullPointerException();
        }
        path = this.normalize(path);
        WorkspaceCache workspace = this.workspace();
        if (this.write(path, content) && workspace.saveOrUpdate(entry = new CacheEntry(CategoryEnum.PATH, null, path))) {
            return StorageResult.succeed((Object)true);
        }
        return StorageResult.failed((Object)false, (CodeEnum)CodeEnum.CODE_INTERNAL_ERROR);
    }

    public StorageResult<Boolean> uploadByUuid(CategoryEnum category, String uuid, String path, byte[] content, boolean retry) {
        CacheEntry entry;
        if (category == null || uuid == null || path == null || content == null) {
            logger.info("uploadByUuid\u65b9\u6cd5\u53c2\u6570\u9519\u8bef\uff0c\u629b\u51faNullPointerException\u3002category\uff1a{}\uff0cuuid\uff1a{}\uff0cpath\uff1a{}\uff0ccontent\uff1a{}", new Object[]{category, uuid, path, content});
            throw new NullPointerException();
        }
        if (category == CategoryEnum.PATH) {
            throw new IllegalArgumentException();
        }
        path = this.normalize(path);
        WorkspaceCache workspace = this.workspace();
        if (this.write(path, content) && workspace.saveOrUpdate(entry = new CacheEntry(category, uuid, path))) {
            return StorageResult.succeed((Object)true);
        }
        return StorageResult.failed((Object)false, (CodeEnum)CodeEnum.CODE_INTERNAL_ERROR);
    }

    public StorageResult<Boolean> uploadByUuidByAppId(CategoryEnum category, String uuid, String path, byte[] content, boolean retry, String appId) {
        CacheEntry entry;
        if (category == null || uuid == null || path == null || content == null) {
            logger.info("uploadByUuid\u65b9\u6cd5\u53c2\u6570\u9519\u8bef\uff0c\u629b\u51faNullPointerException\u3002category\uff1a{}\uff0cuuid\uff1a{}\uff0cpath\uff1a{}\uff0ccontent\uff1a{}", new Object[]{category, uuid, path, content});
            throw new NullPointerException();
        }
        if (category == CategoryEnum.PATH) {
            throw new IllegalArgumentException();
        }
        path = this.normalize(path);
        WorkspaceCache workspace = this.workspace(appId);
        if (this.write(path, content) && workspace.saveOrUpdate(entry = new CacheEntry(category, uuid, path))) {
            return StorageResult.succeed((Object)true);
        }
        return StorageResult.failed((Object)false, (CodeEnum)CodeEnum.CODE_INTERNAL_ERROR);
    }

    public StorageResult<byte[]> downloadByPath(String path) {
        byte[] content;
        if (path == null) {
            throw new NullPointerException();
        }
        path = this.normalize(path);
        WorkspaceCache workspace = this.workspace();
        CacheEntry entry = workspace.getByPath(new CacheEntry(path));
        if (entry != null && (content = this.read(path)) != null) {
            return StorageResult.succeed((Object)content);
        }
        return StorageResult.failed(null, (CodeEnum)CodeEnum.CODE_NOT_FILE_FOUND);
    }

    public StorageResult<byte[]> downloadByUuid(CategoryEnum category, String uuid) {
        String path;
        byte[] content;
        if (category == null || uuid == null) {
            throw new NullPointerException();
        }
        if (category == CategoryEnum.PATH) {
            throw new IllegalArgumentException();
        }
        WorkspaceCache workspace = this.workspace();
        CacheEntry entry = workspace.getByUuid(new CacheEntry(category, uuid));
        if (entry != null && entry.getPath() != null && (content = this.read(path = this.normalize(entry.getPath()))) != null) {
            return StorageResult.succeed((Object)content);
        }
        return StorageResult.failed(null, (CodeEnum)CodeEnum.CODE_NOT_FILE_FOUND);
    }

    public StorageResult<String> getFilePathByUuid(CategoryEnum category, String uuid) {
        if (category == null || uuid == null) {
            throw new NullPointerException();
        }
        if (category == CategoryEnum.PATH) {
            throw new IllegalArgumentException();
        }
        WorkspaceCache workspace = this.workspace();
        CacheEntry entry = workspace.getByUuid(new CacheEntry(category, uuid));
        if (entry != null && entry.getPath() != null) {
            String path = this.normalize(entry.getPath());
            return StorageResult.succeed((Object)path);
        }
        return StorageResult.failed(null, (CodeEnum)CodeEnum.CODE_NOT_FILE_FOUND);
    }

    public StorageResult<List<StorageEntity>> list(String pathStartWith, String pathEndWith, boolean content) {
        pathStartWith = this.normalize(pathStartWith);
        pathEndWith = this.normalize(pathEndWith);
        WorkspaceCache workspace = this.workspace();
        List<CacheEntry> list = workspace.list(pathStartWith, pathEndWith);
        ArrayList<StorageEntity> entities = new ArrayList<StorageEntity>(list.size());
        for (CacheEntry entry : list) {
            if (entry == null || entry.getPath() == null) {
                return StorageResult.failed(Collections.emptyList(), (CodeEnum)CodeEnum.CODE_INTERNAL_ERROR);
            }
            StorageEntity entity = new StorageEntity();
            entity.setType(entry.getType().getValue());
            entity.setUuid(entry.getUuid());
            entity.setPath(entry.getPath());
            if (content) {
                byte[] bytes = this.read(entry.getPath());
                if (bytes == null) {
                    return StorageResult.failed(Collections.emptyList(), (CodeEnum)CodeEnum.CODE_INTERNAL_ERROR);
                }
                entity.setContent(bytes);
            }
            entities.add(entity);
        }
        return StorageResult.succeed(entities);
    }

    public StorageResult<Boolean> deleteByPath(String path, boolean retry) {
        if (path == null) {
            throw new NullPointerException();
        }
        path = this.normalize(path);
        WorkspaceCache workspace = this.workspace();
        if (this.remove(path)) {
            workspace.deleteByPath(new CacheEntry(path));
            return StorageResult.succeed((Object)true);
        }
        return StorageResult.failed((Object)false, (CodeEnum)CodeEnum.CODE_NOT_FILE_FOUND);
    }

    public StorageResult<Boolean> deleteDirByPath(String path, boolean retry) {
        if (path == null) {
            throw new NullPointerException();
        }
        path = this.normalize(path);
        File workspace = new File(this.root, this.config.getWorkspace());
        File file = new File(workspace, FilenameUtils.normalize((String)path));
        if (file.exists() && file.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)file);
                return StorageResult.succeed((Object)true);
            }
            catch (IOException e) {
                return StorageResult.failed((Object)false, (int)10001, (String)e.getMessage());
            }
        }
        return StorageResult.succeed((Object)true, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
    }

    public StorageResult<Boolean> deleteByUuid(CategoryEnum category, String uuid, boolean retry) {
        if (category == null || uuid == null) {
            throw new NullPointerException();
        }
        if (category == CategoryEnum.PATH) {
            throw new IllegalArgumentException();
        }
        WorkspaceCache workspace = this.workspace();
        return workspace.computeSynchronized(ws -> {
            CacheEntry entry = ws.getByUuid(new CacheEntry(category, uuid));
            if (entry != null && this.remove(entry.getPath()) && ws.deleteByUuid(entry)) {
                return StorageResult.succeed((Object)true);
            }
            return StorageResult.failed((Object)false, (CodeEnum)CodeEnum.CODE_NOT_FILE_FOUND);
        });
    }

    public StorageResult<Boolean> rename(String source, String target, boolean retry) {
        if (source == null || target == null) {
            throw new NullPointerException();
        }
        String sourcePath = this.normalize(source);
        String targetPath = this.normalize(target);
        WorkspaceCache workspace = this.workspace();
        if (this.move(sourcePath, targetPath)) {
            return workspace.computeSynchronized(ws -> {
                CacheEntry entry = ws.getByPath(new CacheEntry(sourcePath));
                if (entry == null) {
                    return StorageResult.failed((Object)false, (CodeEnum)CodeEnum.CODE_NOT_FILE_FOUND);
                }
                entry.setPath(targetPath);
                ws.saveOrUpdate(entry);
                return StorageResult.succeed((Object)true);
            });
        }
        return StorageResult.failed((Object)false, (CodeEnum)CodeEnum.CODE_NOT_FILE_FOUND);
    }

    public StorageResult<Boolean> existsByPath(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        path = this.normalize(path);
        WorkspaceCache workspace = this.workspace();
        CacheEntry entry = workspace.getByPath(new CacheEntry(path));
        return StorageResult.succeed((Object)(entry != null ? 1 : 0));
    }

    public StorageResult<Boolean> existsByUuid(CategoryEnum category, String uuid) {
        if (category == null || uuid == null) {
            throw new NullPointerException();
        }
        if (category == CategoryEnum.PATH) {
            throw new IllegalArgumentException();
        }
        WorkspaceCache workspace = this.workspace();
        CacheEntry entry = workspace.getByUuid(new CacheEntry(category, uuid));
        return StorageResult.succeed((Object)(entry != null ? 1 : 0));
    }

    private String normalize(String path) {
        if (path == null) {
            return null;
        }
        String normalized = FilenameUtils.normalize((String)path, (boolean)true);
        if (normalized != null) {
            return normalized.startsWith("/") ? normalized.substring(1) : normalized;
        }
        List segments = Arrays.stream(path.split("[\\\\/]", -1)).filter(segment -> !segment.isEmpty() && ".".equalsIgnoreCase((String)segment)).collect(Collectors.toList());
        ArrayDeque<String> processed = new ArrayDeque<String>(segments.size());
        for (String segment2 : segments) {
            if ("..".equals(segment2)) {
                processed.pollLast();
                continue;
            }
            processed.addLast(segment2);
        }
        return String.join((CharSequence)"/", processed);
    }

    private boolean move(String source, String target) {
        File workspace = new File(this.root, this.config.getWorkspace());
        File sourceFile = new File(workspace, FilenameUtils.normalize((String)source));
        File targetFile = new File(workspace, FilenameUtils.normalize((String)target));
        try {
            FileUtils.moveFile((File)sourceFile, (File)targetFile);
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    private boolean remove(String path) {
        File workspace = new File(this.root, this.config.getWorkspace());
        File file = new File(workspace, FilenameUtils.normalize((String)path));
        return file.delete();
    }

    private synchronized byte[] read(String path) {
        File workspace = new File(this.root, this.config.getWorkspace());
        File file = new File(workspace, FilenameUtils.normalize((String)path));
        try {
            return FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            logger.error("failed to read workspace file", (Throwable)e);
            return null;
        }
    }

    private synchronized boolean write(String path, byte[] content) {
        File workspace = new File(this.root, this.config.getWorkspace());
        File file = new File(workspace, FilenameUtils.normalize((String)path));
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])content);
            return true;
        }
        catch (IOException e) {
            logger.error("failed to write workspace file", (Throwable)e);
            return false;
        }
    }

    private WorkspaceCache workspace() {
        String current = this.config.getWorkspace();
        WorkspaceCache workspace = this.cache.workspace(current);
        if (this.refreshOnce(current)) {
            workspace.refresh();
        }
        return workspace;
    }

    private WorkspaceCache workspace(String appId) {
        String current = HussarUtils.isBlank((CharSequence)appId) ? this.config.getDefaultWorkspace() : appId;
        WorkspaceCache workspace = this.cache.workspace(current);
        if (this.refreshOnce(current)) {
            workspace.refresh();
        }
        return workspace;
    }

    private boolean refreshOnce(String name) {
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        if (attrs == null) {
            return true;
        }
        HashSet<String> refreshed = (HashSet<String>)attrs.getAttribute(ATTRIBUTE_WORKSPACE_REFRESHED, 0);
        if (refreshed == null) {
            refreshed = new HashSet<String>();
            attrs.setAttribute(ATTRIBUTE_WORKSPACE_REFRESHED, refreshed, 0);
        }
        boolean required = !refreshed.contains(name);
        refreshed.add(name);
        return required;
    }

    private static class CacheEntry {
        private CategoryEnum type;
        private String uuid;
        private String path;

        public CacheEntry() {
        }

        public CacheEntry(String path) {
            this.path = path;
        }

        public CacheEntry(CategoryEnum type, String uuid) {
            this.type = type;
            this.uuid = uuid;
        }

        public CacheEntry(CategoryEnum type, String uuid, String path) {
            this.type = type;
            this.uuid = uuid;
            this.path = path;
        }

        public CategoryEnum getType() {
            return this.type;
        }

        public void setType(CategoryEnum type) {
            this.type = type;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    private static class WorkspaceCache {
        private final File workspace;
        private final NavigableMap<String, TypeUuidUnion> pathMappings = new TreeMap<String, TypeUuidUnion>();
        private final Map<TypeUuidUnion, String> uuidMappings = new HashMap<TypeUuidUnion, String>();

        public WorkspaceCache(File workspace) {
            this.workspace = workspace;
            this.refresh();
        }

        public synchronized void clear() {
            this.pathMappings.clear();
            this.uuidMappings.clear();
        }

        public synchronized void refresh() {
            try {
                List<CacheEntry> entries = this.searchLocal(this.workspace);
                this.clear();
                for (CacheEntry entry : entries) {
                    this.saveOrUpdate(entry);
                }
            }
            catch (IOException e) {
                logger.error("failed to refresh workspace", (Throwable)e);
            }
        }

        public synchronized <T> T computeSynchronized(Function<WorkspaceCache, T> operation) {
            return operation.apply(this);
        }

        public synchronized boolean saveOrUpdate(CacheEntry entry) {
            if (entry == null || entry.getType() == null || entry.getPath() == null) {
                throw new NullPointerException();
            }
            String path = entry.getPath();
            TypeUuidUnion union = TypeUuidUnion.fromCacheEntry(entry);
            if (entry.getType() == CategoryEnum.PATH) {
                this.pathMappings.put(path, union);
            } else {
                String uuidMapping;
                if (entry.getUuid() == null) {
                    throw new NullPointerException();
                }
                TypeUuidUnion pathMapping = (TypeUuidUnion)this.pathMappings.get(path);
                if (pathMapping == null == ((uuidMapping = this.uuidMappings.get(union)) == null)) {
                    this.pathMappings.put(path, union);
                    this.uuidMappings.put(union, path);
                } else if (pathMapping != null) {
                    this.uuidMappings.remove(pathMapping);
                    this.pathMappings.put(path, union);
                    this.uuidMappings.put(union, path);
                } else {
                    this.pathMappings.remove(uuidMapping);
                    this.pathMappings.put(path, union);
                    this.uuidMappings.put(union, path);
                }
            }
            return true;
        }

        public synchronized CacheEntry getByPath(CacheEntry entry) {
            if (entry == null || entry.getPath() == null) {
                throw new NullPointerException();
            }
            String path = entry.getPath();
            TypeUuidUnion union = (TypeUuidUnion)this.pathMappings.get(path);
            if (union == null) {
                return null;
            }
            return union.toCacheEntry(path);
        }

        public synchronized CacheEntry getByUuid(CacheEntry entry) {
            if (entry == null || entry.getType() == null || entry.getUuid() == null) {
                throw new NullPointerException();
            }
            if (entry.getType() == CategoryEnum.PATH) {
                throw new IllegalArgumentException();
            }
            TypeUuidUnion union = TypeUuidUnion.fromCacheEntry(entry);
            String path = this.uuidMappings.get(union);
            if (path == null) {
                return null;
            }
            return union.toCacheEntry(path);
        }

        public synchronized boolean deleteByPath(CacheEntry entry) {
            if (entry == null || entry.getPath() == null) {
                throw new NullPointerException();
            }
            String path = entry.getPath();
            TypeUuidUnion union = (TypeUuidUnion)this.pathMappings.get(path);
            if (union == null) {
                return false;
            }
            this.pathMappings.remove(path);
            this.uuidMappings.remove(union);
            return true;
        }

        public synchronized boolean deleteByUuid(CacheEntry entry) {
            if (entry == null || entry.getType() == null || entry.getUuid() == null) {
                throw new NullPointerException();
            }
            if (entry.getType() == CategoryEnum.PATH) {
                throw new IllegalArgumentException();
            }
            TypeUuidUnion union = TypeUuidUnion.fromCacheEntry(entry);
            String path = this.uuidMappings.get(union);
            if (path == null) {
                return false;
            }
            this.uuidMappings.remove(union);
            this.pathMappings.remove(path);
            return true;
        }

        public synchronized List<CacheEntry> list(String pathStartWith, String pathEndWith) {
            pathStartWith = Optional.ofNullable(pathStartWith).orElse("");
            pathEndWith = Optional.ofNullable(pathEndWith).orElse("");
            ArrayList<CacheEntry> list = new ArrayList<CacheEntry>();
            NavigableMap<String, TypeUuidUnion> since = this.pathMappings.tailMap(pathStartWith, true);
            for (Map.Entry entry : since.entrySet()) {
                if (!((String)entry.getKey()).startsWith(pathStartWith)) break;
                if (!((String)entry.getKey()).endsWith(pathEndWith)) continue;
                list.add(((TypeUuidUnion)entry.getValue()).toCacheEntry((String)entry.getKey()));
            }
            return list;
        }

        private List<CacheEntry> searchLocal(File workspace) throws IOException {
            if (!workspace.exists()) {
                return Collections.emptyList();
            }
            if (!workspace.isDirectory()) {
                throw new IOException("not a directory " + workspace);
            }
            Collection files = FileUtils.listFiles((File)workspace, null, (boolean)true);
            LinkedHashMap<String, MetaJsonPair> mapping = new LinkedHashMap<String, MetaJsonPair>();
            ArrayList<Object> phase1Remain = new ArrayList<Object>();
            for (Object file : files) {
                if (((File)file).getName().endsWith(".meta")) {
                    JSONObject jSONObject = this.parseJson((File)file);
                    String type = Optional.ofNullable(jSONObject).map(json -> json.get((Object)"type")).filter(v -> v instanceof String).orElse(null);
                    String uuid = Optional.ofNullable(jSONObject).map(json -> json.get((Object)"id")).filter(v -> v instanceof String).orElse(null);
                    if (uuid != null) {
                        String path = FilenameUtils.removeExtension((String)((File)file).getPath());
                        MetaJsonPair pair = new MetaJsonPair();
                        pair.setUuid(uuid);
                        pair.setMeta((File)file);
                        pair.setModule(Objects.equals(type, "Module"));
                        mapping.put(path, pair);
                        continue;
                    }
                }
                phase1Remain.add(file);
            }
            ArrayList<File> phase2Remain = new ArrayList<File>();
            for (File file : phase1Remain) {
                MetaJsonPair pair = (MetaJsonPair)mapping.get(file.getPath());
                if (pair != null) {
                    pair.setJson(file);
                    continue;
                }
                phase2Remain.add(file);
            }
            ArrayList<CacheEntry> list = new ArrayList<CacheEntry>();
            for (MetaJsonPair pair : mapping.values()) {
                CacheEntry metaEntry = new CacheEntry();
                metaEntry.setType(CategoryEnum.META);
                metaEntry.setUuid(pair.getUuid());
                metaEntry.setPath(this.stripePath(workspace, pair.getMeta()));
                list.add(metaEntry);
                if (pair.getJson() == null) continue;
                CacheEntry jsonEntry = new CacheEntry();
                jsonEntry.setType(CategoryEnum.JSON);
                jsonEntry.setUuid(pair.getUuid());
                jsonEntry.setPath(this.stripePath(workspace, pair.getJson()));
                list.add(jsonEntry);
            }
            for (File file : phase2Remain) {
                CacheEntry dataEntry = new CacheEntry();
                dataEntry.setType(CategoryEnum.PATH);
                dataEntry.setPath(this.stripePath(workspace, file));
                list.add(dataEntry);
            }
            return list;
        }

        private String stripePath(File base, File path) {
            String relative = FileUtil.removePathPrefixAndConvertPosix(base.getPath(), path.getPath());
            return FileUtil.posixPath("/", relative).substring(1);
        }

        private JSONObject parseJson(File file) {
            try {
                return JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
            }
            catch (JSONException | IOException e) {
                logger.error("failed to parse workspace json file", e);
                return null;
            }
        }

        private static class MetaJsonPair {
            private File meta;
            private File json;
            private String uuid;
            private boolean module;

            private MetaJsonPair() {
            }

            public File getMeta() {
                return this.meta;
            }

            public void setMeta(File meta) {
                this.meta = meta;
            }

            public File getJson() {
                return this.json;
            }

            public void setJson(File json) {
                this.json = json;
            }

            public String getUuid() {
                return this.uuid;
            }

            public void setUuid(String uuid) {
                this.uuid = uuid;
            }

            public boolean isModule() {
                return this.module;
            }

            public void setModule(boolean module) {
                this.module = module;
            }
        }

        private static class TypeUuidUnion {
            private CategoryEnum type;
            private String uuid;

            public TypeUuidUnion() {
            }

            public TypeUuidUnion(CategoryEnum type, String uuid) {
                this.type = type;
                this.uuid = uuid;
            }

            public static TypeUuidUnion fromCacheEntry(CacheEntry entry) {
                return new TypeUuidUnion(entry.getType(), entry.getUuid());
            }

            public CacheEntry toCacheEntry(String path) {
                return new CacheEntry(this.type, this.uuid, path);
            }

            public CategoryEnum getType() {
                return this.type;
            }

            public void setType(CategoryEnum type) {
                this.type = type;
            }

            public String getUuid() {
                return this.uuid;
            }

            public void setUuid(String uuid) {
                this.uuid = uuid;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TypeUuidUnion that = (TypeUuidUnion)o;
                return this.type == that.type && Objects.equals(this.uuid, that.uuid);
            }

            public int hashCode() {
                return Objects.hash(this.type, this.uuid);
            }
        }
    }

    private static class StorageCache {
        private final String root;
        private final Map<String, WorkspaceCache> workspaces = new ConcurrentHashMap<String, WorkspaceCache>();

        public StorageCache(String root) {
            this.root = root;
        }

        public WorkspaceCache workspace(String name) {
            return this.workspaces.computeIfAbsent(name, key -> new WorkspaceCache(new File(this.root, name)));
        }
    }
}

