/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util.mongo;

import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.scenes.model.FormDesignScenes;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.mongo.MongoTemplateCache;
import com.jxdinfo.hussar.formdesign.common.util.mongo.MongoTemplateUtil;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDbFactory;
import org.springframework.util.ObjectUtils;

public class MongoTemplateCacheRunner
implements ApplicationRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoTemplateCacheRunner.class);

    public void run(ApplicationArguments args) {
        MongoClient mongoClient;
        FormDesignScenes noCodeScenes = SpringUtil.getBean(FormDesignProperties.class).getNoCodeScenes();
        if (!noCodeScenes.isNoCodeMongo()) {
            return;
        }
        ArrayList<String> dbs = new ArrayList<String>();
        try {
            mongoClient = MongoTemplateUtil.mongoClient();
        }
        catch (Exception e) {
            LOGGER.info("\u521d\u59cb\u5316mongoTemplate\u5b9e\u4f8b\u7f13\u5b58\u5f02\u5e38\uff0c\u672a\u83b7\u53d6\u5230mongoClient\uff01");
            return;
        }
        for (String dbName : mongoClient.listDatabaseNames()) {
            SimpleMongoClientDbFactory simpleMongoDbFactory = new SimpleMongoClientDbFactory(mongoClient, dbName);
            MongoDatabase db = simpleMongoDbFactory.getMongoDatabase();
            if (ObjectUtils.isEmpty((Object)db)) continue;
            dbs.add(dbName);
            MongoTemplateCache.put(dbName, new MongoTemplate((MongoDatabaseFactory)simpleMongoDbFactory));
        }
        LOGGER.info("\u521d\u59cb\u5316mongoTemplate\u5b9e\u4f8b\u7f13\u5b58\u6210\u529f\uff0c\u5b9e\u4f8b\u6570\uff1a\uff08{}\uff09 \uff1a{}", (Object)dbs.size(), dbs);
    }
}

