/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import com.helger.css.ECSSVersion;
import com.helger.css.ICSSWriteable;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.reader.CSSReader;
import com.helger.css.writer.CSSWriter;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class VueCssSorterUtil {
    public static final List<String> TOP_CSS_KEY = Arrays.asList(".lcdp_axe_main", ".el-tooltip__popper");
    public static final List<String> END_CSS_KEY = Arrays.asList(".twinkle", "@-webkit-keyframes twinkle", "@keyframes twinkle");
    public static final String STYLE_REGEX = "<style[^>]*>(.*?)</style>";

    public static String sortVueCss(String content) {
        ArrayList<String> styles = new ArrayList<String>();
        ArrayList<String> styleBlocks = new ArrayList<String>();
        ArrayList<String> modifiedStyles = new ArrayList<String>();
        VueCssSorterUtil.initStyleList(content, styles, modifiedStyles, styleBlocks);
        if (HussarUtils.isNotEmpty(styles)) {
            for (int i = 0; i < styles.size(); ++i) {
                modifiedStyles.set(i, ((String)styles.get(i)).replace((CharSequence)modifiedStyles.get(i), VueCssSorterUtil.sortCssBlock((String)modifiedStyles.get(i))));
            }
        }
        return VueCssSorterUtil.buildContent(styles, modifiedStyles, styleBlocks);
    }

    private static String buildContent(List<String> styles, List<String> modifiedStyles, List<String> styleBlocks) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < styleBlocks.size(); ++i) {
            result.append(styleBlocks.get(i));
            if (i < modifiedStyles.size()) {
                result.append(modifiedStyles.get(i));
                continue;
            }
            if (i >= styles.size()) continue;
            result.append(styles.get(i));
        }
        return result.toString();
    }

    private static void initStyleList(String content, List<String> styles, List<String> modifiedStyles, List<String> styleBlocks) {
        Pattern pattern = Pattern.compile(STYLE_REGEX, 32);
        Matcher matcher = pattern.matcher(content);
        int lastEnd = 0;
        while (matcher.find()) {
            styles.add(matcher.group());
            styleBlocks.add(content.substring(lastEnd, matcher.start()));
            modifiedStyles.add(matcher.group(1));
            lastEnd = matcher.end();
        }
        styleBlocks.add(content.substring(lastEnd));
    }

    private static String sortCssBlock(String cssContent) {
        cssContent = cssContent.replace("/deep/", "v-deep");
        CascadingStyleSheet styleSheet = CSSReader.readFromString((String)cssContent, (ECSSVersion)ECSSVersion.LATEST);
        ArrayList<CSSStyleRule> topRules = new ArrayList<CSSStyleRule>();
        ArrayList<CSSStyleRule> rules = new ArrayList<CSSStyleRule>();
        ArrayList<CSSStyleRule> endRules = new ArrayList<CSSStyleRule>();
        HashMap<String, Integer> selectorOrderMap = new HashMap<String, Integer>();
        int orderIndex = 0;
        if (HussarUtils.isEmpty((Object)styleSheet)) {
            return cssContent.replace("v-deep", "/deep/");
        }
        for (ICSSTopLevelRule rule : styleSheet.getAllRules()) {
            if (!(rule instanceof CSSStyleRule)) continue;
            CSSStyleRule styleRule = (CSSStyleRule)rule;
            String selector = VueCssSorterUtil.getSelectorString(styleRule);
            if (TOP_CSS_KEY.contains(selector.trim())) {
                topRules.add(styleRule);
                continue;
            }
            if (END_CSS_KEY.contains(selector.trim())) {
                endRules.add(styleRule);
                continue;
            }
            if (!selectorOrderMap.containsKey(selector)) {
                selectorOrderMap.put(selector, orderIndex++);
            }
            rules.add(styleRule);
        }
        VueCssSorterUtil.sortRules(rules, selectorOrderMap);
        return VueCssSorterUtil.generatorCss(topRules, rules, endRules);
    }

    @SafeVarargs
    private static String generatorCss(List<CSSStyleRule> ... genRules) {
        CSSWriter writer = new CSSWriter();
        StringBuilder sortedCss = new StringBuilder();
        for (List<CSSStyleRule> rules : genRules) {
            if (!HussarUtils.isNotEmpty(rules)) continue;
            for (CSSStyleRule rule : rules) {
                sortedCss.append(writer.getCSSAsString((ICSSWriteable)rule)).append("\n");
            }
        }
        return sortedCss.toString().trim().replace("v-deep", "/deep/");
    }

    private static void sortRules(List<CSSStyleRule> rules, Map<String, Integer> selectorOrderMap) {
        rules.sort((r1, r2) -> {
            String selector2;
            String selector1 = VueCssSorterUtil.getSelectorString(r1);
            int cmp = selector1.compareToIgnoreCase(selector2 = VueCssSorterUtil.getSelectorString(r2));
            return cmp != 0 ? cmp : Integer.compare((Integer)selectorOrderMap.get(selector1), (Integer)selectorOrderMap.get(selector2));
        });
    }

    private static String getSelectorString(CSSStyleRule rule) {
        if (HussarUtils.isEmpty((Object)rule) || HussarUtils.isEmpty((Object)rule.getAllSelectors())) {
            return "";
        }
        return rule.getAllSelectors().stream().map(ICSSWriteable::getAsCSSString).collect(Collectors.joining(" "));
    }
}

