/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl.resource;

import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.common.file.impl.resource.ResourcePathServiceImpl;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="FrontMicroBackMicroResourcePath")
public class FrontMicroBackMicroResourcePath
extends ResourcePathServiceImpl {
    @Autowired
    ISysApplicationBoService iSysApplicationBoService;

    @Override
    public ResourcePath projectStore(String ... pathSegments) {
        this.getPrefix();
        String localPrefix = this.localProjectStore();
        String remotePrefix = StringUtils.removeStart((String)FileUtil.posixPath(this.projectRootPath), (String)"/");
        return ResourcePath.of(FileUtil.posixPath(FileUtil.posixPath(pathSegments)), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath projectStoreCode(String ... pathSegments) {
        this.getPrefix();
        String localPrefix = this.getProjectAndCodePath();
        String remotePrefix = this.convertToRemoteProjectStore(localPrefix);
        return ResourcePath.of(FileUtil.posixPath(FileUtil.posixPath(pathSegments)), localPrefix, remotePrefix);
    }

    @Override
    public SysApplicationVo projectAppName() {
        String serviceID = AppContextUtil.getServiceID();
        if (HussarUtils.isNotEmpty((Object)this.iSysApplicationBoService.getAppDetailByAppCode(serviceID))) {
            return this.iSysApplicationBoService.getAppDetailByAppCode(serviceID);
        }
        return null;
    }

    @Override
    public String getLocalPath(String pathSegments, String localPrefix) {
        this.getPrefix();
        return FileUtil.systemPath(FileUtil.systemPath(localPrefix, pathSegments).replace(".project-store", FileUtil.posixPath(this.prefix, ".project-store")));
    }
}

