/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl.java;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.file.JavaPathService;
import com.jxdinfo.hussar.formdesign.common.file.model.DataSourceAnnotationStrategy;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.Optional;

public abstract class JavaPathServiceImpl
implements JavaPathService {
    public static final String REMOTE_NOT_USED = "not-used";
    private static final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    public final String workspace = formDesignProperties.getWorkspace();
    public final String backProjectPath = formDesignProperties.getBackProjectPath();
    public final String javaPath = formDesignProperties.getJavaPath();
    public final String javaCodePath = formDesignProperties.getJavaCodePath();
    public final String workflowListenerPath = formDesignProperties.getWorkflowListenerPath();
    public String prefix;
    public final String HUSSAR_TOKEN_DS = "com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs";
    public final String HUSSAR_DS = "com.jxdinfo.hussar.support.datasource.annotations.HussarDs";

    public static String getDefaultDataSourceName() {
        return Optional.ofNullable(SpringUtil.getBean(DynamicDataSourceProperties.class).getPrimary()).orElse("");
    }

    void getPrefix() {
        this.prefix = ((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix();
    }

    @Override
    public String getDefaultBackProjectPath() {
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.workspace, this.backProjectPath));
    }

    @Override
    public String getBackProjectPath() {
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.workspace, this.backProjectPath));
    }

    @Override
    public String getJavaGeneratePath() {
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.getBackProjectPath(), this.javaCodePath, this.javaPath));
    }

    @Override
    public String getBpmListenerPath() {
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.getBackProjectPath(), this.javaCodePath, this.javaPath, this.workflowListenerPath));
    }

    @Override
    public ResourcePath backProject(String ... pathSegments) {
        String localPrefix = this.getBackProjectPath();
        String remotePrefix = FileUtil.posixPath(REMOTE_NOT_USED, "hussar-web");
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public String getNoConcatServiceID(String prefix, String ... suffix) {
        return FileUtil.posixPath(prefix, FileUtil.posixPath(suffix));
    }

    @Override
    public DataSourceAnnotationStrategy dataSourceAnnotationStrategy(String dataSourceName) {
        if (JavaPathServiceImpl.getDefaultDataSourceName().equals(dataSourceName)) {
            return new DataSourceAnnotationStrategy("@HussarTokenDs", "com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs");
        }
        return new DataSourceAnnotationStrategy("@HussarDs(\"" + dataSourceName + "\")", "com.jxdinfo.hussar.support.datasource.annotations.HussarDs");
    }
}

