/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.aspect;

import com.jxdinfo.hussar.formdesign.common.config.StorageContext;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignStorageProperties;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class StorageDebugAspect {
    @Autowired
    private StorageContext storageContext;
    @Autowired
    private FormDesignStorageProperties formDesignStorageProperties;

    @Pointcut(value="execution(* *(..)) && within(com.jxdinfo.hussar.formdesign.storage.client.service.impl.*)")
    public void pointcut() {
    }

    @AfterReturning(value="pointcut()", returning="returned", argNames="joinPoint,returned")
    public void after(JoinPoint joinPoint, Object returned) {
        if (this.formDesignStorageProperties.isDebug()) {
            Logger logger = LoggerFactory.getLogger((Class)joinPoint.getSignature().getDeclaringType());
            logger.info("{} -> {}", (Object)this.callInfo(joinPoint), (Object)this.returnInfo(returned));
        }
    }

    @AfterThrowing(value="pointcut()", throwing="threw", argNames="joinPoint,threw")
    public void after(JoinPoint joinPoint, Throwable threw) {
        Logger logger = LoggerFactory.getLogger((Class)joinPoint.getSignature().getDeclaringType());
        logger.error("{} throws {}", (Object)this.callInfo(joinPoint), (Object)threw);
    }

    private String returnInfo(Object returned) {
        if (returned instanceof StorageResult) {
            Object returnedData = ((StorageResult)returned).getData();
            if (returnedData instanceof byte[]) {
                return "<" + ((byte[])returnedData).length + " bytes>";
            }
            return Objects.toString(returnedData);
        }
        return Objects.toString(returned);
    }

    private String callInfo(JoinPoint joinPoint) {
        Object[] rawArgs = joinPoint.getArgs();
        ArrayList<String> args = new ArrayList<String>(rawArgs.length);
        for (Object rawArg : rawArgs) {
            String arg = rawArg instanceof byte[] ? "<" + ((byte[])rawArg).length + " bytes>" : Objects.toString(rawArg);
            args.add(arg);
        }
        return "[" + this.requestInfo() + " => " + this.storageInfo() + "] " + joinPoint.getSignature().getName() + "(" + String.join((CharSequence)", ", args) + ")";
    }

    private String storageInfo() {
        String addr = this.storageContext.getAddr();
        if (addr != null && addr.startsWith("localhost:")) {
            addr = ":" + StringUtils.removeStart((String)addr, (String)"localhost:");
        } else if (addr != null && addr.startsWith("127.0.0.1:")) {
            addr = ":" + StringUtils.removeStart((String)addr, (String)"127.0.0.1:");
        }
        String workspace = this.storageContext.getWorkspace();
        if (workspace != null && workspace.length() > 6) {
            workspace = workspace.substring(0, 6) + "..";
        }
        return addr + "/" + workspace;
    }

    private String requestInfo() {
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        if (!(attrs instanceof ServletRequestAttributes)) {
            throw new UnsupportedOperationException("StorageDebugAspect: not ServletRequestAttributes");
        }
        HttpServletRequest request = ((ServletRequestAttributes)attrs).getRequest();
        String method = request.getMethod();
        String uri = request.getRequestURI();
        String query = Optional.ofNullable(request.getQueryString()).map(qs -> qs.startsWith("?") ? qs : "?" + qs).orElse("");
        String requestLine = method + " " + uri + query;
        String mime = request.getContentType();
        int length = request.getContentLength();
        String body = length > 0 ? " <body: " + mime + " (" + length + " bytes)>" : "";
        return requestLine + body;
    }
}

