/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.file.filemapping.controller;

import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.speedcode.common.file.FileMappingService;
import com.jxdinfo.hussar.speedcode.common.response.SpeedCodeResponse;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speed/filemapping"})
public class FileMappingController {
    private final FileMappingService fileMappingService;

    @Autowired
    public FileMappingController(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    @GetMapping
    public SpeedCodeResponse<Map<String, String>> getFileMapping() throws IOException, LcdpException {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        speedCodeResponse.setData((Object)this.fileMappingService.fileMappingCache());
        return speedCodeResponse;
    }

    @GetMapping(value={"/path"})
    public SpeedCodeResponse<String> getFileRelativePath(String id) throws IOException, LcdpException {
        SpeedCodeResponse stringSpeedCodeResponse = new SpeedCodeResponse();
        stringSpeedCodeResponse.setData((Object)this.fileMappingService.getFormatPath(id));
        return stringSpeedCodeResponse;
    }

    @DeleteMapping
    public SpeedCodeResponse evictFileMappingCache() {
        SpeedCodeResponse speedCodeResponse = new SpeedCodeResponse();
        this.fileMappingService.fileMappingCacheEvict();
        speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_DONE.getCode());
        return speedCodeResponse;
    }
}

