/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.controller;

import com.jxdinfo.hussar.application.feign.RemoteSysApplicationBoService;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.PublishLogUtil;
import com.jxdinfo.hussar.formdesign.devtools.model.PublishLogVo;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.publish.model.PublishPageInfoVO;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/publishLog"})
public class PublishLogController {
    @Resource
    private PageInfoService pageInfoService;
    @Resource
    private RemoteSysApplicationBoService sysApplicationBoService;

    @GetMapping(value={"/getPublishLog"})
    public FormDesignResponse<List<PublishLogVo>> getPublishLog() {
        FormDesignResponse response = new FormDesignResponse();
        try {
            response = FormDesignResponse.success((Object)PublishLogUtil.getPublishLogList(null));
        }
        catch (Exception e) {
            response.setErrorCode(10001);
            response.setErrorMsg(e.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/cleanPublishLog"})
    public FormDesignResponse<String> cleanPublishLog() {
        FormDesignResponse response = new FormDesignResponse();
        try {
            PublishLogUtil.cleanPublishLog();
            response = FormDesignResponse.success((Object)"\u6e05\u9664\u65e5\u5fd7\u6210\u529f");
        }
        catch (Exception e) {
            response.setErrorCode(10001);
            response.setErrorMsg(e.getMessage());
        }
        return response;
    }

    @GetMapping(value={"/getPageInfoAndAppInfo"})
    public FormDesignResponse<PublishPageInfoVO> getPageInfoAndAppInfo(@RequestParam String resourceId, @RequestParam String appCode) {
        FormDesignResponse response = new FormDesignResponse();
        try {
            PageInfo pageInfo = (PageInfo)this.pageInfoService.get(resourceId);
            SysApplicationVo sysApp = this.sysApplicationBoService.getAppDetailByAppCode(appCode);
            response = FormDesignResponse.success((Object)new PublishPageInfoVO(pageInfo.getDesc(), sysApp.getAppName()));
        }
        catch (Exception e) {
            response.setErrorCode(10001);
            response.setErrorMsg(e.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/writePublishLog"})
    public FormDesignResponse<String> writePublishLog(@RequestBody PublishLogVo publishLog) {
        FormDesignResponse response = new FormDesignResponse();
        try {
            publishLog.setAppCode((String)SpringContextHolder.getBean((String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix()));
            PublishLogUtil.writeDirectPublishLog((PublishLogVo)publishLog);
            response = FormDesignResponse.success((Object)"\u5199\u5165\u65e5\u5fd7\u6210\u529f");
        }
        catch (Exception e) {
            response.setErrorCode(10001);
            response.setErrorMsg(e.getMessage());
        }
        return response;
    }
}

