/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelPublishAdapter;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.CodePublishTool;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolCacheUtile;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.PublishLogUtil;
import com.jxdinfo.hussar.formdesign.publish.model.PublishDTO;
import com.jxdinfo.hussar.formdesign.publish.model.WorkGenCodeResult;
import com.jxdinfo.hussar.formdesign.publish.service.BackPublishService;
import com.jxdinfo.hussar.formdesign.publish.service.ResourcePublishService;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionDataBaseStorage.class})
public class BackPublishDataBaseServiceImpl
implements BackPublishService {
    @Resource
    private SysMidFileCodeService sysMidFileCodeService;
    private static final Logger logger = LoggerFactory.getLogger(BackPublishDataBaseServiceImpl.class);
    @Resource
    private CodePublishTool codePublishTool;
    @Autowired(required=false)
    private ResourcePublishService resourcePublishService;
    @Resource
    private FilePublishService filePublishService;
    @Resource
    private VersionManageService versionManageService;
    @Resource
    private CodeMergeService codeMergeService;
    @Resource
    private PathStrategyService pathStrategy;

    @Override
    public void sync(Map<String, Object> param) throws IOException, LcdpException, CloneNotSupportedException {
    }

    @Override
    public List<CodeResult> publishBackCode(Map<String, Object> param) throws IOException, LcdpException, RuntimeException, CloneNotSupportedException {
        JSONObject modelData;
        JSONArray translates;
        long startTime = System.currentTimeMillis();
        String appCode = ((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix();
        if (VfgModeTool.isRemote()) {
            PublishLogUtil.writePublishToEnvStartLog((String)param.get("id").toString(), (String)appCode, (String)"\u6570\u636e\u6a21\u578b");
        }
        ArrayList<CodeResult> codeResults = new ArrayList<CodeResult>();
        HashSet<String> modelIds = new HashSet<String>();
        String id = param.get("id").toString();
        modelIds.add(id);
        SysMidFileCode fileInfo = this.sysMidFileCodeService.getMainFile(id);
        if (HussarUtils.isNotEmpty((Object)fileInfo) && ToolUtil.isNotEmpty((Object)(translates = (modelData = JSON.parseObject((String)fileInfo.getData())).getJSONArray("translate")))) {
            for (Object translateObj : translates) {
                JSONObject translate = (JSONObject)translateObj;
                if (!ToolUtil.isNotEmpty((Object)translate.getJSONArray("dataModelCondition"))) continue;
                modelIds.add(translate.getString("sourceId"));
            }
        }
        PublishCtx publishCtx = new PublishCtx();
        for (String modelId : modelIds) {
            SysMidFileCode metaFileInfo;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", modelId);
            params.put("publishIds", "WebPage");
            if (ToolUtil.isNotEmpty((Object)param.get("identity"))) {
                params.put("identity", param.get("identity"));
            }
            if (!ToolUtil.isNotEmpty(params) || !ToolUtil.isNotEmpty((Object)modelId)) continue;
            publishCtx.setBaseFile(null);
            publishCtx.addParams(params);
            ModelPublishAdapter.adaptor((String)modelId, (PublishCtx)publishCtx);
            codeResults.addAll(publishCtx.getGenCodeResults());
            PublishDTO publishDTO = ToolUtil.isEmpty((Object)publishCtx.getPublishDTO()) ? new PublishDTO() : publishCtx.getPublishDTO();
            publishDTO.setExtensionId(AppContextUtil.getUnionPrefix());
            boolean isConflict = false;
            for (CodeResult codeResult : codeResults) {
                if (!codeResult.isExistConflict()) continue;
                isConflict = true;
                break;
            }
            if (!isConflict) {
                this.codePublishTool.delayWrite(modelId);
                this.resourcePublishService.publishResource(publishDTO);
            } else {
                this.filePublishService.writePublishResourceToCache(modelId, null, publishDTO);
                this.filePublishService.writePublishSourceToCache(modelId, "dataModel");
            }
            if (!HussarUtils.isNotEmpty((Object)(metaFileInfo = this.sysMidFileCodeService.getMetaFile(id)))) continue;
            JSONObject metaFileData = JSON.parseObject((String)metaFileInfo.getData());
            metaFileData.put("isPublished", (Object)true);
            metaFileInfo.setData(JSON.toJSONString((Object)metaFileData));
            this.sysMidFileCodeService.updateById((Object)metaFileInfo);
        }
        Object isCompile = param.get("isCompile");
        Boolean codeChanges = (Boolean)Optional.ofNullable(publishCtx.getParam("codeChanges", Boolean.class)).orElse(false);
        logger.info("===========================\u6587\u4ef6\u662f\u5426\u6539\u52a8\uff1a{}==========================", (Object)codeChanges);
        if (ToolUtil.isEmpty((Object)isCompile)) {
            ModelPublishAdapter.compileAndPush(new ArrayList(modelIds), (String)"");
        }
        if (VfgModeTool.isRemote()) {
            PublishLogUtil.writePublishSuccessLog((String)param.get("id").toString(), (String)appCode, (String)"\u6570\u636e\u6a21\u578b", (String)"1");
        }
        long endTime = System.currentTimeMillis();
        String elapsedTime = ToolUtil.timeBetween((long)startTime, (long)endTime);
        logger.info("\u53d1\u5e03\u540e\u7aef\u4ee3\u7801\u603b\u8017\u65f6\uff1a{}", (Object)elapsedTime);
        return codeResults;
    }

    @Override
    public List<WorkGenCodeResult> publishBpmActivityVisitorCode(List<Map<String, String>> fileMessages, WorkflowInfo workflowInfo, String modelId) throws IOException, LcdpException {
        ArrayList<WorkGenCodeResult> results = new ArrayList<WorkGenCodeResult>();
        HashMap<String, String> writeNewFileLastPublish = new HashMap<String, String>();
        HashMap<String, String> writeNewFileCurrentFile = new HashMap<String, String>();
        HashMap<String, String> delayWriteLastPublish = new HashMap<String, String>();
        boolean isConflict = false;
        boolean codeChanges = false;
        String workflowId = workflowInfo.getId();
        for (Map<String, String> map : fileMessages) {
            MergeResult mergeResult;
            Iterator dataId = map.get("dataId");
            String newDataId = map.get("newDataId");
            String newFilePath = map.get("newFilePath");
            String oldFilePath = map.get("oldFilePath");
            String newFile = map.get("fileContent");
            if (ToolUtil.isEmpty((Object)oldFilePath)) {
                writeNewFileLastPublish.put(newDataId, newFile);
                writeNewFileCurrentFile.put(newFilePath, newFile);
                continue;
            }
            WorkGenCodeResult genCodeResult = new WorkGenCodeResult();
            String oldFile = this.filePublishService.readCurrentPublishedFile(oldFilePath);
            String versionCode = this.versionManageService.getAncestorCodeById(dataId);
            String lastFile = this.versionManageService.getLastFileCode(dataId);
            if (versionCode == null) {
                versionCode = oldFile;
            }
            if ((mergeResult = this.codeMergeService.textMerge(versionCode, oldFile, newFile, lastFile, false)).isConflict()) {
                isConflict = true;
                genCodeResult.setDataId((String)((Object)dataId));
                genCodeResult.setId(workflowId);
                genCodeResult.setExistConflict(true);
                genCodeResult.setMergeCode(mergeResult.getMergedCode());
                genCodeResult.setConflictCode(mergeResult.getConflictsCode());
                genCodeResult.setLastPublish(mergeResult.getLastPublish());
                genCodeResult.setCurrentFile(mergeResult.getCurrentFile());
                genCodeResult.setCurrentPublish(mergeResult.getCurrentPublish());
                genCodeResult.setMergeInfo(mergeResult.getMergeInfo());
                genCodeResult.setOriginCode(oldFile);
                genCodeResult.setNewCode(newFile);
                genCodeResult.setType("java");
                genCodeResult.setFilePath(newFilePath);
                genCodeResult.setResultType(ResultBeanEnum.MYSQL_RESULT);
                if (genCodeResult.isExistConflict()) {
                    this.filePublishService.writePublishResult((CodeResult)genCodeResult);
                    genCodeResult = genCodeResult.reduceCodeResult();
                }
                results.add(genCodeResult);
                continue;
            }
            this.filePublishService.writeStringToFile(mergeResult.getMergedCode(), newFilePath + "BPM", workflowId);
            delayWriteLastPublish.put(newDataId, newFile);
        }
        if (!isConflict) {
            String cacheKey;
            for (Map.Entry entry : delayWriteLastPublish.entrySet()) {
                this.versionManageService.saveLastPublishCode((String)entry.getKey(), (String)entry.getValue());
            }
            String cacheName = workflowId + "PublishCacheName";
            if (ToolCacheUtile.containKey((String)cacheName, (String)(cacheKey = workflowId + "PublishCacheKey"))) {
                this.codePublishTool.delayWrite(workflowId);
            }
            for (Map.Entry entry : writeNewFileLastPublish.entrySet()) {
                this.versionManageService.saveLastPublishCode((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : writeNewFileCurrentFile.entrySet()) {
                this.filePublishService.writeStringToFile((String)entry.getValue(), (String)entry.getKey());
            }
        } else {
            String lastPublishFilePath;
            for (Map.Entry entry : delayWriteLastPublish.entrySet()) {
                lastPublishFilePath = this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath() + "/publish/version/ancestor/" + ((String)entry.getKey()).replace("_", "/") + "/last_publish.version";
                this.filePublishService.writeStringToFile((String)entry.getValue(), lastPublishFilePath, workflowId);
            }
            for (Map.Entry entry : writeNewFileLastPublish.entrySet()) {
                lastPublishFilePath = this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath() + "/publish/version/ancestor/" + ((String)entry.getKey()).replace("_", "/") + "/last_publish.version";
                this.filePublishService.writeStringToFile((String)entry.getValue(), lastPublishFilePath, workflowId);
            }
        }
        String bpmvisitorPack = FileUtil.posixPath((String[])new String[]{"bpmvisitor", workflowInfo.getCategory(), workflowInfo.getIdentity()});
        if (Boolean.TRUE.equals(VfgModeTool.isActive().getData())) {
            ModelPublishAdapter.compileAndPush(Collections.singletonList(modelId), (String)bpmvisitorPack);
        }
        return results;
    }
}

