/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.controller;

import com.jxdinfo.hussar.application.properties.UserEvnProperties;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.PublishLogUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileLockManagerService;
import com.jxdinfo.hussar.formdesign.publish.service.BackPublishService;
import com.jxdinfo.hussar.formdesign.publish.service.PublishService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/back/publish"})
public class BackPublishController {
    @Autowired
    private BackPublishService backPublishService;
    @Autowired
    private UserEvnProperties userEvnProperties;
    @Autowired
    private FormDesignProperties formDesignProperties;
    @Autowired
    private PublishService publishService;
    @Autowired
    private FileLockManagerService lockManagerService;

    @RequestMapping(value={"/dataModel"})
    public FormDesignResponse<List<CodeResult>> publishDataModel(@RequestBody Map<String, Object> param) throws IOException, LcdpException, RuntimeException, CloneNotSupportedException {
        String modelId = String.valueOf(param.get("id"));
        ApiResponse response = this.lockManagerService.checkLockByResourceType(modelId, "DataModel");
        if (!response.isSuccess()) {
            FormDesignResponse formDesignResponse = new FormDesignResponse();
            formDesignResponse.setErrorCode(response.getCode());
            formDesignResponse.setData(response.getData());
            return formDesignResponse;
        }
        boolean startAuto = this.userEvnProperties.getStartAuto();
        if (VfgModeTool.startAutoNotActive((boolean)startAuto, (String)modelId, (String)"\u4e2a\u4eba\u73af\u5883", null, (String)"\u4e2a\u4eba\u670d\u52a1\u5b9e\u4f8b\u672a\u542f\u52a8\u6216\u6b63\u5728\u542f\u52a8\u4e2d\uff0c\u8bf7\u7a0d\u5019\u2026\u2026\uff01", (String)"3")) {
            return FormDesignResponse.fail(new ArrayList(), (String)"");
        }
        if (Boolean.FALSE.equals(VfgModeTool.isActive().getData())) {
            param.put("isCompile", Boolean.FALSE);
        }
        this.publishService.deleteCacheByIdBeforePublish(modelId);
        FormDesignResponse genCodeResultFormDesignResponse = new FormDesignResponse();
        this.backPublishService.sync(param);
        List<CodeResult> backCodeResult = null;
        try {
            backCodeResult = this.backPublishService.publishBackCode(param);
        }
        catch (RuntimeException e) {
            if (VfgModeTool.isRemote()) {
                PublishLogUtil.writePublishFailLog((String)modelId, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u6570\u636e\u6a21\u578b");
            }
            genCodeResultFormDesignResponse.setErrorCode(10001);
            genCodeResultFormDesignResponse.setErrorMsg(e.getMessage());
        }
        VfgModeTool.start((boolean)startAuto, (String)modelId, (String)"\u542f\u52a8", (String)"\u5f00\u59cb\u542f\u52a8\u670d\u52a1...", null, (String)"1");
        genCodeResultFormDesignResponse.setData(backCodeResult);
        return genCodeResultFormDesignResponse;
    }
}

