/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.controller;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.model.AdjustWorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.ModelCopyDto;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WorkflowService;
import com.jxdinfo.hussar.formdesign.publish.model.DeptProcessVO;
import com.jxdinfo.hussar.formdesign.publish.service.PublishService;
import com.jxdinfo.hussar.formdesign.publish.service.WorkFlowPublishService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import com.jxdinfo.hussar.workflow.manage.engine.DefinitionEngineService;
import java.io.IOException;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WorkFlowPublishController {
    private WorkFlowPublishService workFlowPublishService;
    private PublishService publishService;
    private GodAxeModelService godAxeModelService;
    private final FormDesignProperties formDesignProperties;
    private final IndexStorageLockService indexStorageLockService;
    private WorkflowService workflowService;

    @Autowired
    public WorkFlowPublishController(WorkFlowPublishService workFlowPublishService, PublishService publishService, FormDesignProperties formDesignProperties, IndexStorageLockService indexStorageLockService, WorkflowService workflowService, GodAxeModelService godAxeModelService) {
        this.workFlowPublishService = workFlowPublishService;
        this.publishService = publishService;
        this.formDesignProperties = formDesignProperties;
        this.indexStorageLockService = indexStorageLockService;
        this.workflowService = workflowService;
        this.godAxeModelService = godAxeModelService;
    }

    @RequestMapping(value={"/speedcode/publish/workflow"})
    public FormDesignResponse<?> workflowPublish(@RequestParam String id, @RequestParam boolean isOverride) throws CloneNotSupportedException {
        this.publishService.deleteCacheByIdBeforePublish(id);
        FormDesignResponse<Object> speedCodeResponse = new FormDesignResponse<Object>();
        try {
            speedCodeResponse = this.workFlowPublishService.publish(id, isOverride);
            if (speedCodeResponse.getErrorCode() == 500) {
                speedCodeResponse.setErrorCode(HttpStatus.OK.value());
            }
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printStackTrace();
        }
        catch (LcdpException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
            e.printInfo();
        }
        return speedCodeResponse;
    }

    @PostMapping(value={"/speed/workflowinfo/adjustProcess"})
    public FormDesignResponse<Object> adjustProcess(@RequestBody AdjustWorkflowInfo workflowInfo) throws IOException, LcdpException, CloneNotSupportedException {
        FormDesignResponse sharedStorage;
        this.publishService.deleteCacheByIdBeforePublish(workflowInfo.getId());
        if (this.formDesignProperties.getScenes().isSharedStorage() && (sharedStorage = this.isSharedStorage(String.valueOf(workflowInfo.getModelId()))).getErrorCode() != 200) {
            return sharedStorage;
        }
        boolean flag = DefinitionEngineService.queryIsPublish((String)workflowInfo.getIdentity());
        boolean publishNewOrganProcess = false;
        if (HussarUtils.isNotEmpty((Object)workflowInfo.getProcessTag())) {
            ApiResponse response = this.godAxeModelService.checkOrganProcessPublishState(workflowInfo.getIdentity(), workflowInfo.getProcessTag());
            if (response.isSuccess()) {
                if (response.getData() != null && response.getData() instanceof Integer && 14161 == (Integer)response.getData()) {
                    return FormDesignResponse.fail(null, (String)response.getMsg());
                }
                if (response.getData() == null || !(response.getData() instanceof Integer) || 14162 != (Integer)response.getData()) {
                    publishNewOrganProcess = true;
                }
            } else {
                return FormDesignResponse.fail(null, (String)response.getMsg());
            }
        }
        FormDesignResponse<Object> speedCodeResponse = new FormDesignResponse<Object>();
        if (HussarUtils.isNotEmpty((Object)workflowInfo.getData())) {
            if (!flag) {
                try {
                    speedCodeResponse = this.workFlowPublishService.publish(workflowInfo.getId(), workflowInfo.getOverride());
                }
                catch (IOException e) {
                    speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
                    e.printStackTrace();
                }
                catch (LcdpException e) {
                    speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
                    e.printInfo();
                }
                return speedCodeResponse;
            }
            if (HussarUtils.isNotEmpty((Object)workflowInfo.getProcessTag()) && publishNewOrganProcess) {
                FormDesignResponse<Object> formDesignResponse = null;
                try {
                    formDesignResponse = this.workFlowPublishService.publishDeptProcess(workflowInfo.getId(), workflowInfo.getProcessTag(), workflowInfo.getProcessTagName(), workflowInfo.getId());
                }
                catch (IOException e) {
                    formDesignResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
                }
                catch (LcdpException e) {
                    formDesignResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
                }
                return formDesignResponse;
            }
            try {
                return this.workflowService.adjustProcess(workflowInfo);
            }
            catch (HussarException e) {
                if (e.getExceptionCode() == 10010) {
                    speedCodeResponse.setErrorCode(e.getExceptionCode().intValue());
                    speedCodeResponse.setErrorMsg(e.getMessage());
                    return speedCodeResponse;
                }
                throw e;
            }
        }
        this.workflowService.updateFileMeta((BaseFile)workflowInfo);
        return new FormDesignResponse();
    }

    @PostMapping(value={"/speed/workflowinfo/publishDeptProcess"})
    public FormDesignResponse<Object> publishDeptProcess(@RequestBody DeptProcessVO deptProcessVO) throws IOException, LcdpException, CloneNotSupportedException {
        String processKey = deptProcessVO.getNewDesc();
        if (HussarUtils.isEmpty((Object)processKey)) {
            return FormDesignResponse.fail(null, null);
        }
        ArrayList<ModelCopyDto> modelCopyDtoList = new ArrayList<ModelCopyDto>();
        ArrayList<String> processKeys = new ArrayList<String>();
        ModelCopyDto modelCopyDto = new ModelCopyDto();
        modelCopyDto.setId(deptProcessVO.getId());
        modelCopyDto.setNewId(deptProcessVO.getNewId());
        modelCopyDto.setNewName(deptProcessVO.getNewName());
        modelCopyDto.setParentId(deptProcessVO.getParentId());
        modelCopyDto.setCategory(deptProcessVO.getCategory());
        modelCopyDto.setNewDesc(deptProcessVO.getNewDesc());
        modelCopyDto.seteName(deptProcessVO.getNewDesc() + "_" + deptProcessVO.getOrganId());
        modelCopyDtoList.add(modelCopyDto);
        processKeys.add(modelCopyDto.geteName());
        ApiResponse response = this.godAxeModelService.checkOrganProcessPublishState(deptProcessVO.getNewDesc(), deptProcessVO.getOrganId());
        if (!response.isSuccess()) {
            return FormDesignResponse.fail(null, (String)response.getMsg());
        }
        if (response.getData() != null && response.getData() instanceof Integer && (14162 == (Integer)response.getData() || 14161 == (Integer)response.getData())) {
            return FormDesignResponse.fail(null, (String)response.getMsg());
        }
        FormDesignResponse<Object> formDesignResponse = new FormDesignResponse<Object>();
        this.workflowService.publishWorkflowOnOrgan(modelCopyDtoList);
        try {
            formDesignResponse = this.workFlowPublishService.publishDeptProcess(deptProcessVO.getNewId(), deptProcessVO.getOrganId(), deptProcessVO.getOrganName(), deptProcessVO.getId());
        }
        catch (IOException e) {
            formDesignResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
        }
        catch (LcdpException e) {
            formDesignResponse.setErrorCode(LcdpExceptionEnum.FILE_ERROR.getCode());
        }
        return formDesignResponse;
    }

    private FormDesignResponse isSharedStorage(String id) {
        Long userId;
        StorageResult result;
        SecurityUser user = BaseSecurityUtil.getUser();
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        if (HussarUtils.isEmpty((Object)user)) {
            speedCodeResponse.setErrorCode(400);
            speedCodeResponse.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return speedCodeResponse;
        }
        if (this.formDesignProperties.isLockEnabled() && HussarUtils.isNotEmpty((Object)(result = this.indexStorageLockService.getOneLockByResource(id)).getData()) && (!HussarUtils.isNotEmpty((Object)(userId = ((StorageLockPO)result.getData()).getUserId())) || !userId.equals(user.getId()))) {
            speedCodeResponse.setErrorCode(403);
            speedCodeResponse.setErrorMsg(((StorageLockPO)result.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
            return speedCodeResponse;
        }
        return new FormDesignResponse();
    }
}

