/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.controller;

import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.publish.util.CompileUtil;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/preview"})
public class PreviewController {
    @Resource
    FormDesignProperties formDesignProperties;
    @Resource
    private PathStrategyService pathStrategy;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    @PostMapping(value={"/restart"})
    public FormDesignResponse<String> restart() throws IOException {
        FormDesignResponse response = new FormDesignResponse();
        String triggerFilePath = this.formDesignProperties.getProjectPath() + "\\src\\main\\resources\\restart.trigger";
        if (Boolean.parseBoolean(this.formDesignProperties.getRestart())) {
            try (FileWriter fileWriter = new FileWriter(triggerFilePath);){
                fileWriter.write(LocalDateTime.now().format(DateTimeFormatter.ofPattern(DATE_FORMAT)));
                response.setData((Object)"restart");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            response.setData((Object)"noRestart");
        }
        return response;
    }

    @PostMapping
    public FormDesignResponse<String> getRequest() {
        FormDesignResponse response = new FormDesignResponse();
        response.setErrorCode(200);
        return response;
    }

    @PostMapping(value={"/compile"})
    public FormDesignResponse<?> test(@RequestParam(required=false) String path) {
        FormDesignResponse response = new FormDesignResponse();
        String javaCodePath = this.formDesignProperties.getJavaCodePath();
        String javaPath = this.pathStrategy.javaPathService().getJavaPath();
        if (ToolUtil.isEmpty((Object)path)) {
            path = this.pathStrategy.javaPathService().getBackProjectPath() + javaCodePath + javaPath;
        }
        String dest = this.pathStrategy.javaPathService().getBackProjectPath() + "\\target\\classes\\";
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(dest);
        try {
            CompileUtil.compileAndCopyFiles(path, dest, options, "UTF-8", this.formDesignProperties.getProjectPath() + "\\src\\main\\java\\");
            response.setErrorCode(200);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setErrorCode(500);
            response.setErrorMsg("\u7f16\u8bd1\u5931\u8d25\uff01");
        }
        return response;
    }
}

