/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.service.impl.DatasourceDataServiceImpl;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.util.HEDataModelUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEModelBeanUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeEnginePushUtil;
import com.jxdinfo.hussar.formdesign.external.require.engine.enums.EngineMethodEnum;
import com.jxdinfo.hussar.formdesign.publish.service.ExcelReaderSaveService;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExcelReaderSaveServiceImpl
implements ExcelReaderSaveService {
    private static final Logger logger = LoggerFactory.getLogger(DatasourceDataServiceImpl.class);

    @Override
    public Map writeSaveByModelId(String modelId) throws LcdpException, IOException {
        this.sync(modelId);
        JSONObject json = DataModelUtil.getDataModelJson((String)modelId);
        String functionType = String.valueOf(json.get((Object)"functionType"));
        HeDataModelBase dataModelBase = HEModelBeanUtil.getFunctionModelVisitorBean((String)functionType).parseDataModel(json);
        HeBackCtx backCtx = new HeBackCtx();
        backCtx.setStrategy("HUSSAR_ENGINE");
        HEDataModelUtil.init((HeBackCtx)backCtx, (DataModelBase)dataModelBase);
        PushBackCtx engineCtx = HeEnginePushUtil.getEngineCtx((HeDataModelBase)dataModelBase);
        logger.info("{}\u65b9\u6cd5\u5f00\u59cb", (Object)"Excel\u5bfc\u5165\u6570\u636e");
        String currentModelId = backCtx.getUseDataModelBase().getId();
        HeDataModelBaseDTO dataModelBaseDTO = (HeDataModelBaseDTO)backCtx.getUseDataModelDtoMap().get(currentModelId);
        logger.info("\u63a8\u9001\u89e3\u6790\u5f15\u64ce");
        HeEnginePushUtil.pushInsertSave((String)EngineMethodEnum.SINGLE_TABLE_SAVE_BATCH_MORE.value.getName(), (PushBackCtx)engineCtx, (HeDataModelBaseDTO)dataModelBaseDTO, (String)EngineMethodEnum.SINGLE_TABLE_SAVE_BATCH_MORE.value.getName(), (String)EngineMethodEnum.SINGLE_TABLE_SAVE_BATCH_MORE.value.getDesc(), null);
        logger.info("\u63a8\u9001\u89e3\u6790\u5f15\u64ce\u5b8c\u6210");
        HeEnginePushUtil.pushApi((PushBackCtx)engineCtx);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", engineCtx.getCurrentApiNameDto().getBusinessId());
        return map;
    }

    public void sync(String modelId) throws LcdpException, IOException {
        Optional<DataModelBase> data = Optional.ofNullable(DataModelUtil.getDataModelBase((String)modelId));
        if (data.isPresent()) {
            HeDataModelBase transfer = HEDataModelUtil.transfer((DataModelBase)data.get());
            transfer.sync();
        }
    }

    @Override
    public boolean judgmentTableName(String tableName, String dataSourceName) throws IOException, LcdpException {
        Optional tableInfo = DataModelUtil.filterTable((String)dataSourceName, (String)"BASE TABLE", (String)tableName);
        return !tableInfo.isPresent();
    }
}

