/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelPublishAdapter;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.CodePublishTool;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolCacheUtile;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.publish.model.PublishDTO;
import com.jxdinfo.hussar.formdesign.publish.model.WorkGenCodeResult;
import com.jxdinfo.hussar.formdesign.publish.service.BackPublishService;
import com.jxdinfo.hussar.formdesign.publish.service.ResourcePublishService;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackPublishServiceImpl
implements BackPublishService {
    private final FilePublishService filePublishService;
    private final FileMappingService fileMappingService;
    private final VersionManageService versionManageService;
    private final FormDesignProperties formDesignProperties;
    private final CodeMergeService codeMergeService;
    private final CodePublishTool codePublishTool;
    @Autowired(required=false)
    private ResourcePublishService resourcePublishService;
    private static final Logger logger = LoggerFactory.getLogger(BackPublishServiceImpl.class);

    @Autowired
    public BackPublishServiceImpl(CodeMergeService codeMergeService, FilePublishService filePublishService, FileMappingService fileMappingService, VersionManageService versionManageService, FormDesignProperties formDesignProperties, ResourcePathService resourcePathService, CodePublishTool codePublishTool) {
        this.codeMergeService = codeMergeService;
        this.filePublishService = filePublishService;
        this.fileMappingService = fileMappingService;
        this.versionManageService = versionManageService;
        this.formDesignProperties = formDesignProperties;
        this.codePublishTool = codePublishTool;
    }

    @Override
    public void sync(Map<String, Object> param) throws IOException, LcdpException, CloneNotSupportedException {
        long start = System.currentTimeMillis();
        Object id = param.get("id");
        if (ToolUtil.isNotEmpty(param) && ToolUtil.isNotEmpty((Object)id)) {
            PublishCtx publishCtx = new PublishCtx();
            publishCtx.setBaseFile(null);
            publishCtx.addParams(param);
            ModelPublishAdapter.sync((String)id.toString());
        }
        long end = System.currentTimeMillis();
        String useTime = ToolUtil.timeBetween((long)start, (long)end);
        logger.info("\u540c\u6b65\u66f4\u65b0\u6570\u636e\u5e93\u540e\u7aef\u4ee3\u7801\u603b\u8017\u65f6\uff1a{}", (Object)useTime);
    }

    @Override
    public List<CodeResult> publishBackCode(Map<String, Object> param) throws IOException, LcdpException, CloneNotSupportedException {
        long start = System.currentTimeMillis();
        ArrayList<CodeResult> codeResults = new ArrayList<CodeResult>();
        String id = param.get("id").toString();
        HashSet<String> modelIds = new HashSet<String>();
        modelIds.add(id);
        String path = this.fileMappingService.getDataPath(id);
        if (ToolUtil.isNotEmpty((Object)path)) {
            JSONArray translates;
            File metaFile = new File(FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), this.formDesignProperties.getProjectCodePath(), path}));
            JSONObject modelObject = null;
            if (metaFile.exists() && ToolUtil.isNotEmpty((Object)(translates = (modelObject = JSON.parseObject((String)FileUtils.readFileToString((File)metaFile, (String)"UTF-8"))).getJSONArray("translate")))) {
                for (Object object : translates) {
                    JSONObject translate = (JSONObject)object;
                    if (!ToolUtil.isNotEmpty((Object)translate.getJSONArray("dataModelCondition"))) continue;
                    modelIds.add(translate.getString("sourceId"));
                }
            }
        }
        for (String modelId : modelIds) {
            String publishIds = "WebPage";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", modelId);
            params.put("publishIds", publishIds);
            if (ToolUtil.isNotEmpty((Object)param.get("identity"))) {
                params.put("identity", param.get("identity"));
            }
            if (!ToolUtil.isNotEmpty(params) || !ToolUtil.isNotEmpty((Object)modelId)) continue;
            PublishCtx publishCtx = new PublishCtx();
            publishCtx.setBaseFile(null);
            publishCtx.addParams(params);
            ModelPublishAdapter.adaptor((String)modelId, (PublishCtx)publishCtx);
            List Results = new ArrayList();
            Results = publishCtx.getGenCodeResults();
            for (CodeResult result : Results) {
                codeResults.add(result);
            }
            PublishDTO publishDTO = ToolUtil.isEmpty((Object)publishCtx.getPublishDTO()) ? new PublishDTO() : publishCtx.getPublishDTO();
            publishDTO.setExtensionId(AppContextUtil.getUnionPrefix());
            boolean isConflict = false;
            for (int i = 0; i < codeResults.size(); ++i) {
                if (!((CodeResult)codeResults.get(i)).isExistConflict()) continue;
                isConflict = true;
                break;
            }
            if (!isConflict) {
                this.codePublishTool.delayWrite(modelId);
                this.resourcePublishService.publishResource(publishDTO);
                continue;
            }
            this.filePublishService.writePublishResourceToCache(modelId, null, publishDTO);
            this.filePublishService.writePublishSourceToCache(modelId, "dataModel");
        }
        long end = System.currentTimeMillis();
        String useTime = ToolUtil.timeBetween((long)start, (long)end);
        logger.info("\u53d1\u5e03\u540e\u7aef\u4ee3\u7801\u603b\u8017\u65f6\uff1a{}", (Object)useTime);
        return codeResults;
    }

    @Override
    public List<WorkGenCodeResult> publishBpmActivityVisitorCode(List<Map<String, String>> fileMessages, String workflowId) throws IOException, LcdpException {
        ArrayList<WorkGenCodeResult> results = new ArrayList<WorkGenCodeResult>();
        HashMap<String, String> writeNewFileLastPublish = new HashMap<String, String>();
        HashMap<String, String> writeNewFileCurrentFile = new HashMap<String, String>();
        HashMap<String, String> delayWriteLastPublish = new HashMap<String, String>();
        boolean isConflict = false;
        for (Map<String, String> map : fileMessages) {
            MergeResult mergeResult;
            String dataId = map.get("dataId");
            String newFilePath = map.get("newFilePath");
            String oldFilePath = map.get("oldFilePath");
            String newFile = map.get("fileContent");
            if (ToolUtil.isEmpty((Object)oldFilePath)) {
                writeNewFileLastPublish.put(dataId, newFile);
                writeNewFileCurrentFile.put(newFilePath, newFile);
                continue;
            }
            WorkGenCodeResult genCodeResult = new WorkGenCodeResult();
            String oldFile = this.filePublishService.readCurrentPublishedFile(oldFilePath);
            String versionCode = this.versionManageService.getAncestorCodeById(dataId);
            String lastFile = this.versionManageService.getLastFileCode(dataId);
            if (versionCode == null) {
                versionCode = oldFile;
            }
            if ((mergeResult = this.codeMergeService.textMerge(versionCode, oldFile, newFile, lastFile, false)).isConflict()) {
                isConflict = true;
                genCodeResult.setDataId(dataId);
                genCodeResult.setId(workflowId);
                genCodeResult.setExistConflict(true);
                genCodeResult.setMergeCode(mergeResult.getMergedCode());
                genCodeResult.setConflictCode(mergeResult.getConflictsCode());
                genCodeResult.setLastPublish(mergeResult.getLastPublish());
                genCodeResult.setCurrentFile(mergeResult.getCurrentFile());
                genCodeResult.setCurrentPublish(mergeResult.getCurrentPublish());
                genCodeResult.setMergeInfo(mergeResult.getMergeInfo());
                genCodeResult.setOriginCode(oldFile);
                genCodeResult.setNewCode(newFile);
                genCodeResult.setType("java");
                genCodeResult.setFilePath(newFilePath);
                genCodeResult.setResultType(ResultBeanEnum.MYSQL_RESULT);
                results.add(genCodeResult);
                continue;
            }
            delayWriteLastPublish.put(dataId, mergeResult.getMergedCode());
        }
        if (!isConflict) {
            String string;
            for (Map.Entry entry : delayWriteLastPublish.entrySet()) {
                this.versionManageService.saveLastPublishCode((String)entry.getKey(), (String)entry.getValue());
            }
            String cacheName = workflowId + "PublishCacheName";
            if (ToolCacheUtile.containKey((String)cacheName, (String)(string = workflowId + "PublishCacheKey"))) {
                this.codePublishTool.delayWrite(workflowId);
            }
            for (Map.Entry entry : writeNewFileLastPublish.entrySet()) {
                this.versionManageService.saveLastPublishCode((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : writeNewFileCurrentFile.entrySet()) {
                this.filePublishService.writeStringToFile((String)entry.getValue(), (String)entry.getKey());
            }
        } else {
            String lastPublishFilePath;
            String projectPath = this.formDesignProperties.getProjectPath();
            String string = this.formDesignProperties.getProjectRootPath();
            for (Map.Entry entry : delayWriteLastPublish.entrySet()) {
                lastPublishFilePath = projectPath + string + "/publish/version/ancestor/" + ((String)entry.getKey()).replace("_", "/") + "/last_publish.version";
                this.filePublishService.writeStringToFile((String)entry.getValue(), lastPublishFilePath, workflowId);
            }
            for (Map.Entry entry : writeNewFileLastPublish.entrySet()) {
                lastPublishFilePath = projectPath + string + "/publish/version/ancestor/" + ((String)entry.getKey()).replace("_", "/") + "/last_publish.version";
                this.filePublishService.writeStringToFile((String)entry.getValue(), lastPublishFilePath, workflowId);
            }
        }
        return results;
    }
}

