/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.adapter;

import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.publish.service.ExtendPublishService;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class extendPublishAdapter {
    private static FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);
    private static SysQuoteRelationService sysQuoteRelationService = (SysQuoteRelationService)SpringUtil.getBean(SysQuoteRelationService.class);
    private static ExtendPublishService extendPublishService = (ExtendPublishService)SpringUtil.getBean(ExtendPublishService.class);

    public static void generator(PublishCtx<CodeResult> publishCtx, String pageType) throws LcdpException, IOException {
        switch (pageType) {
            case "WebPage": {
                extendPublishAdapter.getExtendInfo(publishCtx, "JsScript", "CssScript", "VueScript");
                break;
            }
            case "UniPage": {
                extendPublishAdapter.getExtendInfo(publishCtx, "UniJsScript", "UniCssScript", "UniVueScript");
                break;
            }
            case "MobilePage": {
                extendPublishAdapter.getExtendInfo(publishCtx, "MobileJsScript", "MobileCssScript", "MobileVueScript");
                break;
            }
        }
    }

    public static void getExtendInfo(PublishCtx<CodeResult> publishCtx, Object ... useType) throws LcdpException, IOException {
        Optional<Object> jsIdListOpt = Optional.ofNullable(sysQuoteRelationService.getQuoteIdListbyType(publishCtx.getBaseFile().getId(), useType).getData());
        if (jsIdListOpt.isPresent()) {
            List jsIds = ((List)jsIdListOpt.get()).stream().distinct().collect(Collectors.toList());
            for (String jsId : jsIds) {
                if (!fileMappingService.isFileExist(jsId)) continue;
                extendPublishService.publishScript(jsId);
            }
        }
    }
}

