/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.controller;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeVars;
import com.jxdinfo.hussar.formdesign.publish.service.ThemeVarsService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/themeVars"})
public class ThemeVarsController {
    private final ThemeVarsService themeVarsService;

    @Autowired
    public ThemeVarsController(ThemeVarsService themeVarsService) {
        this.themeVarsService = themeVarsService;
    }

    @GetMapping(value={""})
    public FormDesignResponse<ThemeVars> get() {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        try {
            ThemeVars themeVars = this.themeVarsService.get();
            speedCodeResponse.setData((Object)themeVars);
        }
        catch (IOException e) {
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @PostMapping(value={""})
    public FormDesignResponse<Void> save(@RequestBody ThemeVars themeVars) {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        try {
            this.themeVarsService.saveOrUpdate(themeVars);
        }
        catch (IOException e) {
            e.printStackTrace();
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @DeleteMapping(value={""})
    public FormDesignResponse<Void> delete() {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        try {
            this.themeVarsService.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @GetMapping(value={"/{name}"})
    public FormDesignResponse<ThemeVars> get(@PathVariable String name) {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        try {
            ThemeVars themeVars = this.themeVarsService.get(name);
            speedCodeResponse.setData((Object)themeVars);
        }
        catch (IOException e) {
            e.printStackTrace();
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @PostMapping(value={"/{name}"})
    public FormDesignResponse<Void> save(@PathVariable String name, @RequestBody ThemeVars themeVars) {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        try {
            this.themeVarsService.saveOrUpdate(name, themeVars);
        }
        catch (IOException e) {
            e.printStackTrace();
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @DeleteMapping(value={"/{name}"})
    public FormDesignResponse<Void> delete(@PathVariable String name) {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        try {
            this.themeVarsService.delete(name);
        }
        catch (IOException e) {
            e.printStackTrace();
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }
}

