/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.jxdinfo.hussar.formdesign.back.adapter.ModelPublishAdapter;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.CodePublishTool;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.result.VueCodeResult;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.constant.StrategyType;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.service.DefaultStyleCacheService;
import com.jxdinfo.hussar.formdesign.common.util.FrontClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.facade.theme.dto.DefaultStyleDTO;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.publish.service.PublishService;
import com.jxdinfo.hussar.formdesign.publish.service.ThemeVarsService;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.merge.util.StructuralMerger;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class PublishServiceImpl
implements PublishService {
    private final PageInfoService pageInfoService;
    private static final Logger logger = LoggerFactory.getLogger(PublishServiceImpl.class);
    private final DefaultStyleCacheService defaultStyleCacheService;
    private final ThemeVarsService themeVarsService;
    private final CodePublishTool codePublishTool;
    private final FilePublishService filePublishService;
    private final CodeMergeService codeMergeService;

    @Autowired
    public PublishServiceImpl(PageInfoService pageInfoService, DefaultStyleCacheService defaultStyleCacheService, ThemeVarsService themeVarsService, CodePublishTool codePublishTool, FilePublishService filePublishService, CodeMergeService codeMergeService) {
        this.pageInfoService = pageInfoService;
        this.defaultStyleCacheService = defaultStyleCacheService;
        this.themeVarsService = themeVarsService;
        this.codePublishTool = codePublishTool;
        this.filePublishService = filePublishService;
        this.codeMergeService = codeMergeService;
    }

    @Override
    public List<CodeResult> publish(String id) throws IOException, LcdpException, CloneNotSupportedException {
        long start = System.currentTimeMillis();
        PageInfo pageInfo = (PageInfo)this.pageInfoService.get(id);
        PublishCtx publishCtx = new PublishCtx();
        publishCtx.setBaseFile((BaseFile)pageInfo);
        publishCtx.setStrategy(StrategyType.analyse());
        ModelPublishAdapter.generator((PublishCtx)publishCtx);
        FrontClientConverter.getPublisher((String)ClientKindEnum.CLIENT_PUBLISH.kind(pageInfo.getType())).publish(publishCtx, this.themeVarsService.get());
        String useTime = ToolUtil.logTime((long)start);
        logger.info("{}\u53d1\u5e03\u603b\u8017\u65f6({})", (Object)pageInfo.getType(), (Object)useTime);
        return publishCtx.getGenCodeResults();
    }

    @Override
    public void defaultStyleGenerate(DefaultStyleDTO defaultStyleDTO) {
        this.defaultStyleCacheService.del(defaultStyleDTO);
        this.defaultStyleCacheService.update(defaultStyleDTO);
    }

    @Override
    public void writeMergeCode(List<CodeResult> results) throws IOException, LcdpException {
        String pageId = results.get(0).getId();
        this.codePublishTool.delayWrite(pageId);
        for (CodeResult result : results) {
            com.jxdinfo.hussar.formdesign.common.service.CodeMergeService codeMergeService = null;
            try {
                codeMergeService = (com.jxdinfo.hussar.formdesign.common.service.CodeMergeService)SpringUtil.getBean((String)result.getResultType().getBean());
            }
            catch (Exception e) {
                logger.error("\u5199\u5165\u51b2\u7a81\u6587\u4ef6\u65f6\u83b7\u53d6({})\u5b9e\u4f8b\u5931\u8d25", (Object)result.getResultType().getBean());
            }
            if (ObjectUtils.isEmpty((Object)codeMergeService)) {
                return;
            }
            codeMergeService.writeMergeCode(codeMergeService.parseData(result.getData()));
        }
    }

    @Override
    public List<VueCodeResult> acceptLeftNoConflictCode(List<VueCodeResult> vueCodeResults) {
        String path = vueCodeResults.get(0).getFilePath();
        String type = vueCodeResults.get(0).getType();
        ExtractFileType extractFileType = ExtractFileType.valueOf((String)type.toUpperCase());
        String lastPublish = vueCodeResults.get(0).getLastPublish();
        String currentFile = vueCodeResults.get(0).getCurrentFile();
        String currentPublish = vueCodeResults.get(0).getCurrentPublish();
        StructuralMerger.Result result = StructuralMerger.hybridMerge((String)path, (ExtractFileType)extractFileType, (String)currentFile, (String)lastPublish, (String)currentPublish, null);
        vueCodeResults.get(0).setCurrentFile(result.getMerged());
        return vueCodeResults;
    }

    @Override
    public List<VueCodeResult> acceptRightNoConflictCode(List<VueCodeResult> vueCodeResults) {
        String path = vueCodeResults.get(0).getFilePath();
        String type = vueCodeResults.get(0).getType();
        ExtractFileType extractFileType = ExtractFileType.valueOf((String)type.toUpperCase());
        String lastPublish = vueCodeResults.get(0).getLastPublish();
        String currentFile = vueCodeResults.get(0).getCurrentFile();
        String currentPublish = vueCodeResults.get(0).getCurrentPublish();
        StructuralMerger.Result result = StructuralMerger.hybridMerge((String)path, (ExtractFileType)extractFileType, (String)currentFile, (String)lastPublish, (String)currentPublish, null);
        vueCodeResults.get(0).setCurrentFile(result.getConflicts());
        return vueCodeResults;
    }

    @Override
    public VueCodeResult applyLeftCode(VueCodeResult vueCodeResult) {
        String path = vueCodeResult.getFilePath();
        String type = vueCodeResult.getType();
        ExtractFileType extractFileType = ExtractFileType.valueOf((String)type.toUpperCase());
        String currentFile = vueCodeResult.getCurrentFile();
        String currentPublish = vueCodeResult.getCurrentPublish();
        StructuralMerger.Result result = StructuralMerger.hybridMerge((String)path, (ExtractFileType)extractFileType, (String)currentFile, (String)currentFile, (String)currentPublish, null);
        vueCodeResult.setLastPublish(currentFile);
        vueCodeResult.setMergeInfo(result.getMergeInfo());
        return vueCodeResult;
    }

    @Override
    public VueCodeResult applyRightCode(VueCodeResult vueCodeResult) {
        String path = vueCodeResult.getFilePath();
        String type = vueCodeResult.getType();
        ExtractFileType extractFileType = ExtractFileType.valueOf((String)type.toUpperCase());
        String currentFile = vueCodeResult.getCurrentFile();
        String currentPublish = vueCodeResult.getCurrentPublish();
        StructuralMerger.Result result = StructuralMerger.hybridMerge((String)path, (ExtractFileType)extractFileType, (String)currentPublish, (String)currentFile, (String)currentPublish, null);
        vueCodeResult.setLastPublish(currentPublish);
        vueCodeResult.setMergeInfo(result.getMergeInfo());
        return vueCodeResult;
    }

    @Override
    public boolean isCodeConflict(List<VueCodeResult> vueCodeResults) {
        String lastPublish = vueCodeResults.get(0).getLastPublish();
        String currentFile = vueCodeResults.get(0).getCurrentFile();
        String currentPublish = vueCodeResults.get(0).getCurrentPublish();
        return this.codeMergeService.textMerge(lastPublish, currentFile, currentPublish, null, false).isConflict();
    }

    @Override
    public FormDesignResponse<String> deleteCacheByIdStopPublish(String id) throws LcdpException {
        FormDesignResponse response = new FormDesignResponse();
        if (HussarUtils.isNotEmpty((Object)id)) {
            this.filePublishService.deleteCacheById(id);
            response.setErrorCode(200);
            response.setErrorMsg("\u5df2\u7ec8\u6b62\u53d1\u5e03");
        } else {
            response.setErrorCode(10001);
            response.setErrorMsg("\u53d1\u5e03\u6807\u8bc6\u4e3a\u7a7a\uff0c\u7ec8\u6b62\u53d1\u5e03\u5931\u8d25");
        }
        return response;
    }

    @Override
    public void deleteCacheByIdBeforePublish(String id) {
        this.filePublishService.deleteCacheById(id);
    }
}

