/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.VueCodeGenerateService;
import com.jxdinfo.hussar.formdesign.common.annotation.ExceptionCatcher;
import com.jxdinfo.hussar.formdesign.common.annotation.StorageEnvironment;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.model.MicroAppInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ComponentLibStyleProfiles;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.StyleScheme;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeColorProfiles;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MicroAppInfoService;
import com.jxdinfo.hussar.formdesign.publish.service.StyleSchemeService;
import com.jxdinfo.hussar.formdesign.publish.service.ThemeVarsService;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@StorageEnvironment(value="${properties.workspace > '' ? properties.workspace : 'default'}")
public class StyleSchemeServiceImpl
implements StyleSchemeService {
    private static final String SCHEME_SUFFIX = ".css.scheme";
    private final FormDesignProperties speedCodeProperties;
    private final ResourcePathService resourcePathService;
    private final StorageService storageService;
    private final VueCodeGenerateService vueCodeGenerateService;
    private final MicroAppInfoService microAppInfoService;
    private final ThemeVarsService themeVarsService;
    private final FilePublishService filePublishService;

    @Autowired
    public StyleSchemeServiceImpl(FormDesignProperties speedCodeProperties, ResourcePathService resourcePathService, StorageService storageService, VueCodeGenerateService vueCodeGenerateService, MicroAppInfoService microAppInfoService, ThemeVarsService themeVarsService, FilePublishService filePublishService) {
        this.speedCodeProperties = speedCodeProperties;
        this.resourcePathService = resourcePathService;
        this.storageService = storageService;
        this.vueCodeGenerateService = vueCodeGenerateService;
        this.microAppInfoService = microAppInfoService;
        this.themeVarsService = themeVarsService;
        this.filePublishService = filePublishService;
    }

    @Override
    public void saveOrUpdate(StyleScheme styleScheme) throws IOException {
        String name = styleScheme.getName();
        String content = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)styleScheme);
        this.write(name, content);
    }

    @Override
    public void updateWebPartially(StyleScheme styleScheme) throws IOException {
        String name = styleScheme.getName();
        String originalJsonData = this.read(name);
        StyleScheme original = (StyleScheme)JSON.parseObject((String)originalJsonData, StyleScheme.class);
        ThemeColorProfiles themeColor = Optional.ofNullable(original.getThemeColor()).orElseGet(ThemeColorProfiles::new);
        themeColor.setWebPage((List)Optional.ofNullable(styleScheme.getThemeColor()).map(ThemeColorProfiles::getWebPage).orElse(null));
        original.setThemeColor(themeColor);
        ComponentLibStyleProfiles scssVars = Optional.ofNullable(original.getScssVars()).orElseGet(ComponentLibStyleProfiles::new);
        scssVars.setWebPage((Map)Optional.ofNullable(styleScheme.getScssVars()).map(ComponentLibStyleProfiles::getWebPage).orElse(null));
        original.setScssVars(scssVars);
        String content = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)original);
        this.write(name, content);
    }

    @Override
    public void updateMobilePartially(StyleScheme styleScheme) throws IOException {
        String name = styleScheme.getName();
        String originalJsonData = this.read(name);
        StyleScheme original = (StyleScheme)JSON.parseObject((String)originalJsonData, StyleScheme.class);
        ThemeColorProfiles themeColor = Optional.ofNullable(original.getThemeColor()).orElseGet(ThemeColorProfiles::new);
        themeColor.setMobilePage((List)Optional.ofNullable(styleScheme.getThemeColor()).map(ThemeColorProfiles::getMobilePage).orElse(null));
        original.setThemeColor(themeColor);
        ComponentLibStyleProfiles scssVars = Optional.ofNullable(original.getScssVars()).orElseGet(ComponentLibStyleProfiles::new);
        scssVars.setMobilePage((Map)Optional.ofNullable(styleScheme.getScssVars()).map(ComponentLibStyleProfiles::getMobilePage).orElse(null));
        original.setScssVars(scssVars);
        String content = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)original);
        this.write(name, content);
    }

    private String read(String name) throws IOException {
        if (this.speedCodeProperties.getScenes().isSharedStorage()) {
            return this.readRemote(name);
        }
        return this.readLocal(name);
    }

    private String readLocal(String name) throws IOException {
        String path = this.resourcePathService.projectStoreStyleScheme(new String[]{name + SCHEME_SUFFIX}).getLocalPath();
        return FileUtils.readFileToString((File)new File(path), (Charset)StandardCharsets.UTF_8);
    }

    private String readRemote(String name) throws IOException {
        String path = this.resourcePathService.projectStoreStyleScheme(new String[]{name + SCHEME_SUFFIX}).getRemotePath();
        StorageResult result = this.storageService.downloadByPath(path);
        if (result.isSuccess()) {
            return new String((byte[])result.getData(), StandardCharsets.UTF_8);
        }
        throw new FileNotFoundException("remote: " + path);
    }

    private void write(String name, String content) throws IOException {
        if (this.speedCodeProperties.getScenes().isSharedStorage()) {
            this.writeRemote(name, content);
        } else {
            this.writeLocal(name, content);
        }
    }

    private void writeLocal(String name, String content) throws IOException {
        String path = this.resourcePathService.projectStoreStyleScheme(new String[]{name + SCHEME_SUFFIX}).getLocalPath();
        FileUtils.writeStringToFile((File)new File(path), (String)content, (Charset)StandardCharsets.UTF_8);
    }

    private void writeRemote(String name, String content) throws IOException {
        String path = this.resourcePathService.projectStoreStyleScheme(new String[]{name + SCHEME_SUFFIX}).getRemotePath();
        StorageResult result = this.storageService.uploadByPath(path, content.getBytes(StandardCharsets.UTF_8), true);
        if (!result.isSuccess()) {
            throw new IOException("remote: " + path);
        }
    }

    @Override
    public void delete(String name) throws IOException {
        if (this.speedCodeProperties.getScenes().isSharedStorage()) {
            this.deleteRemote(name);
        } else {
            this.deleteLocal(name);
        }
    }

    private void deleteLocal(String name) throws IOException {
        String toDeleteFilePath = this.resourcePathService.projectStoreStyleScheme(new String[]{name + SCHEME_SUFFIX}).getLocalPath();
        if (!StringUtils.isEmpty((Object)toDeleteFilePath)) {
            File toDeleteFile = new File(toDeleteFilePath);
            FileUtils.forceDelete((File)toDeleteFile);
        }
    }

    private void deleteRemote(String name) {
        String toDeleteFilePath = this.resourcePathService.projectStoreStyleScheme(new String[]{name + SCHEME_SUFFIX}).getRemotePath();
        this.storageService.deleteByPath(toDeleteFilePath, true);
    }

    @Override
    public List<JSONObject> getList() throws IOException {
        if (this.speedCodeProperties.getScenes().isSharedStorage()) {
            return this.getListRemote();
        }
        return this.getListLocal();
    }

    private List<JSONObject> getListLocal() throws IOException {
        ArrayList<JSONObject> styleSchemes = new ArrayList<JSONObject>();
        File directory = new File(this.resourcePathService.projectStoreStyleScheme(new String[0]).getLocalPath());
        if (directory.exists()) {
            Collection styleSchemeFiles = FileUtils.listFiles((File)directory, null, (boolean)false);
            for (File styleSchemeFile : styleSchemeFiles) {
                if (!styleSchemeFile.getName().endsWith(SCHEME_SUFFIX)) continue;
                String styleSchemeJson = FileUtils.readFileToString((File)styleSchemeFile, (Charset)StandardCharsets.UTF_8);
                JSONObject scheme = JSON.parseObject((String)styleSchemeJson);
                styleSchemes.add(scheme);
            }
        }
        return styleSchemes;
    }

    private List<JSONObject> getListRemote() throws IOException {
        String directory = this.resourcePathService.projectStoreStyleScheme(new String[]{"/"}).getRemotePath();
        StorageResult result = this.storageService.list(directory, SCHEME_SUFFIX, true);
        if (result.isSuccess()) {
            List list = (List)result.getData();
            return list.stream().map(storageEntity -> {
                byte[] data = storageEntity.getContent();
                String content = new String(data, StandardCharsets.UTF_8);
                return JSON.parseObject((String)content);
            }).collect(Collectors.toList());
        }
        throw new IOException("remote: " + directory);
    }

    @Override
    public StyleScheme getByName(String name) throws IOException {
        String styleSchemeJson = this.read(name);
        return (StyleScheme)JSON.parseObject((String)styleSchemeJson, StyleScheme.class);
    }

    @Override
    @ExceptionCatcher
    public FormDesignResponse<Boolean> styleApply(String name, String pageType) {
        FormDesignResponse response = new FormDesignResponse();
        try {
            StyleScheme styleScheme = this.getByName(name);
            this.getList().forEach(json -> {
                try {
                    StyleScheme scheme = (StyleScheme)json.toJavaObject(StyleScheme.class);
                    scheme.setIsApply(Objects.equals(scheme.getName(), name));
                    this.saveOrUpdate(scheme);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            boolean isPublish = !styleScheme.getIsPublish();
            this.importCss(name, pageType, isPublish);
            response.setData((Object)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    @Override
    public void importDefault() throws LcdpException, IOException {
        List microAppInfoS = this.microAppInfoService.getMicroAppInfo();
        for (MicroAppInfo microAppInfo : microAppInfoS) {
            String mobilePath = this.speedCodeProperties.getWorkspace() + microAppInfo.getProjectPath();
            this.writeLines(mobilePath + "\\src\\custom.js");
        }
        this.writeLines(ToolUtil.pathFomatterByOS((String)(this.speedCodeProperties.getFrontProjectPath() + "\\src\\pages\\index\\custom.js")));
    }

    private void writeLines(String path) throws IOException {
        List customList;
        File custom = new File(ToolUtil.pathFomatterByOS((String)path));
        if (!custom.exists()) {
            FileUtils.touch((File)custom);
        }
        if (HussarUtils.isEmpty((Object)(customList = FileUtils.readLines((File)custom, (Charset)StandardCharsets.UTF_8)))) {
            customList.add("import '@/assets/css/default_value.css'");
        } else if (!((String)customList.get(0)).contains("import '@/assets/css/default_value.css'")) {
            customList.add(0, "import '@/assets/css/default_value.css'");
        }
        StringBuilder builder = new StringBuilder();
        for (String line : customList) {
            builder.append(line);
            builder.append(System.lineSeparator());
        }
        String content = builder.toString();
        this.filePublishService.writeStringToFileIfRequired(content, path);
    }

    @Override
    public FormDesignResponse<Boolean> importCss(String name, String pageType, boolean isPublish) throws LcdpException, IOException {
        FormDesignResponse response = new FormDesignResponse();
        String importLine = "import '@/assets/css/" + name + ".css'";
        if ("web".equals(pageType)) {
            File customJS;
            String webPath = this.speedCodeProperties.getFrontProjectPath();
            File styleCss = new File(ToolUtil.pathFomatterByOS((String)(webPath + "\\src\\assets\\css\\" + name + ".css")));
            if (isPublish || !styleCss.exists()) {
                FileUtils.touch((File)styleCss);
            }
            if (!(customJS = new File(ToolUtil.pathFomatterByOS((String)(webPath + "\\src\\pages\\index\\custom.js")))).exists()) {
                FileUtils.touch((File)customJS);
            }
            List customLineS = FileUtils.readLines((File)customJS, (Charset)StandardCharsets.UTF_8);
            customLineS.removeIf(customLine -> !customLine.equals("import '@/assets/css/default_value.css'"));
            AtomicBoolean isExist = new AtomicBoolean(false);
            for (String customLine2 : customLineS) {
                isExist.set(customLine2.equals(importLine));
                if (!isExist.get()) continue;
                break;
            }
            if (!isExist.get()) {
                if ("default_value".equals(name)) {
                    customLineS.add(0, importLine);
                } else {
                    customLineS.add(importLine);
                }
            }
            FileUtils.writeLines((File)customJS, (String)"utf-8", (Collection)customLineS);
            String mainJsPath = this.speedCodeProperties.getFrontProjectPath() + "\\src\\main.js";
            if (!new File(ToolUtil.pathFomatterByOS((String)mainJsPath)).exists()) {
                response.setErrorCode(500);
                response.setData((Object)false);
                response.setErrorMsg("main.js\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u9879\u76ee\u5de5\u7a0b\u8def\u5f84");
                return response;
            }
            this.importCustom(mainJsPath);
        } else {
            List microAppInfoS = this.microAppInfoService.getMicroAppInfo();
            for (MicroAppInfo microAppInfo : microAppInfoS) {
                String customJsPath;
                File customJs;
                String mobilePath = this.speedCodeProperties.getWorkspace() + microAppInfo.getProjectPath();
                String styleCssPath = mobilePath + "\\src\\assets\\css\\" + name + ".css";
                styleCssPath = ToolUtil.pathFomatterByOS((String)styleCssPath);
                File styleCss = new File(styleCssPath);
                if (isPublish || !styleCss.exists()) {
                    FileUtils.touch((File)styleCss);
                }
                if (!(customJs = new File(customJsPath = ToolUtil.pathFomatterByOS((String)(mobilePath + "\\src\\custom.js")))).exists()) {
                    FileUtils.touch((File)customJs);
                }
                List customLineS = FileUtils.readLines((File)customJs, (Charset)StandardCharsets.UTF_8);
                customLineS.removeIf(customLine -> !customLine.equals("import '@/assets/css/default_value.css'"));
                AtomicBoolean isExist = new AtomicBoolean(false);
                for (String customLine3 : customLineS) {
                    isExist.set(customLine3.equals(importLine));
                    if (!isExist.get()) continue;
                    break;
                }
                if (isExist.get()) continue;
                if ("default_value".equals(name)) {
                    customLineS.add(0, importLine);
                } else {
                    customLineS.add(importLine);
                }
                FileUtils.writeLines((File)customJs, (String)"utf-8", (Collection)customLineS);
                String mainJsPath = this.speedCodeProperties.getWorkspace() + microAppInfo.getProjectPath() + "\\src\\main.js";
                if (!new File(ToolUtil.pathFomatterByOS((String)mainJsPath)).exists()) {
                    response.setErrorCode(500);
                    response.setData((Object)false);
                    response.setErrorMsg("main.js\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u9879\u76ee\u5de5\u7a0b\u8def\u5f84");
                    return response;
                }
                this.importCustom(mainJsPath);
            }
        }
        response.setData((Object)true);
        response.setErrorCode(200);
        return response;
    }

    private void importCustom(String mainJsPath) throws IOException {
        mainJsPath = ToolUtil.pathFomatterByOS((String)mainJsPath);
        List mainJsList = FileUtils.readLines((File)new File(mainJsPath), (Charset)StandardCharsets.UTF_8);
        String importStr = "import './custom'";
        AtomicBoolean isExist = new AtomicBoolean(true);
        mainJsList.forEach(str -> {
            if (str.equals(importStr)) {
                isExist.set(false);
            }
        });
        if (isExist.get()) {
            mainJsList.add(importStr);
            FileUtils.writeLines((File)new File(mainJsPath), (String)"utf-8", (Collection)mainJsList);
        }
    }
}

