/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.jxdinfo.hussar.formdesign.back.adapter.ModelPublishAdapter;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.VueCodeGenerateService;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.VueCodePublishService;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.result.VueCodeResult;
import com.jxdinfo.hussar.formdesign.common.constant.StrategyType;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.service.DefaultStyleCacheService;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.facade.theme.dto.DefaultStyleDTO;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeVars;
import com.jxdinfo.hussar.formdesign.external.facade.theme.service.IHussarThemeCodeGenerateService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MicroAppInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.publish.service.PublishService;
import com.jxdinfo.hussar.formdesign.publish.service.ThemeVarsService;
import com.jxdinfo.hussar.formdesign.publish.util.MicroservicesCommon.PublishPreviewHandler;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.merge.util.StructuralMerger;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.speedcode.MenuService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class PublishServiceImpl
implements PublishService {
    private final PageInfoService pageInfoService;
    private static final Logger logger = LoggerFactory.getLogger(PublishServiceImpl.class);
    private final FormDesignProperties formDesignProperties;
    private final DefaultStyleCacheService defaultStyleCacheService;
    private final ThemeVarsService themeVarsService;
    private final VueCodeGenerateService vueCodeGenerateService;
    private final VueCodePublishService vueCodePublishService;
    private final FilePublishService filePublishService;
    private final MicroAppInfoService microAppInfoService;
    private final CodeMergeService codeMergeService;
    @Autowired
    private IHussarThemeCodeGenerateService hussarThemeCodeGenerateService;
    @Autowired(required=false)
    private MenuService menuService;

    @Autowired
    public PublishServiceImpl(PageInfoService pageInfoService, FormDesignProperties formDesignProperties, DefaultStyleCacheService defaultStyleCacheService, ThemeVarsService themeVarsService, VueCodeGenerateService vueCodeGenerateService, VueCodePublishService vueCodePublishService, FilePublishService filePublishService, MicroAppInfoService microAppInfoService, CodeMergeService codeMergeService) {
        this.pageInfoService = pageInfoService;
        this.formDesignProperties = formDesignProperties;
        this.defaultStyleCacheService = defaultStyleCacheService;
        this.themeVarsService = themeVarsService;
        this.vueCodeGenerateService = vueCodeGenerateService;
        this.vueCodePublishService = vueCodePublishService;
        this.filePublishService = filePublishService;
        this.microAppInfoService = microAppInfoService;
        this.codeMergeService = codeMergeService;
    }

    @Override
    public List<CodeResult> webVue(String id) throws IOException, LcdpException, CloneNotSupportedException {
        long start = System.currentTimeMillis();
        PublishCtx publishCtx = new PublishCtx();
        PublishPreviewHandler.beforePublish(id, (PublishCtx<CodeResult>)publishCtx);
        ModelPublishAdapter.generator((PublishCtx)publishCtx);
        ThemeVars themeVars = this.themeVarsService.get();
        Map webThemeVars = themeVars != null ? themeVars.getWebPage() : null;
        this.vueCodePublishService.webVue(publishCtx, webThemeVars);
        String useTime = ToolUtil.logTime((long)start);
        logger.info("web\u7aef\u53d1\u5e03\u603b\u8017\u65f6({})", (Object)useTime);
        return publishCtx.getGenCodeResults();
    }

    @Override
    public List<CodeResult> mobileVue(String id) throws IOException, LcdpException, CloneNotSupportedException {
        long start = System.currentTimeMillis();
        PageInfo pageInfo = (PageInfo)this.pageInfoService.get(id);
        PublishCtx publishCtx = new PublishCtx();
        publishCtx.setBaseFile((BaseFile)pageInfo);
        publishCtx.setStrategy(StrategyType.analyse());
        ModelPublishAdapter.generator((PublishCtx)publishCtx);
        ThemeVars themeVars = this.themeVarsService.get();
        Map mobileThemeVars = themeVars != null ? themeVars.getMobilePage() : null;
        publishCtx.setStrategy(this.formDesignProperties.isLocalUnReset() ? "HUSSAR_ENGINE" : "ORIGINAL");
        this.vueCodePublishService.mobileVue(publishCtx, mobileThemeVars);
        String useTime = ToolUtil.logTime((long)start);
        logger.info("mobile\u7aef\u53d1\u5e03\u603b\u8017\u65f6({})", (Object)useTime);
        return publishCtx.getGenCodeResults();
    }

    @Override
    public void defaultStyleGenerate(DefaultStyleDTO defaultStyleDTO) {
        this.defaultStyleCacheService.update(defaultStyleDTO);
    }

    @Override
    public void writeMergeCode(List<CodeResult> results) throws IOException, LcdpException {
        String pageId = results.get(0).getId();
        this.vueCodePublishService.delayWrite(pageId);
        for (CodeResult result : results) {
            com.jxdinfo.hussar.formdesign.common.service.CodeMergeService codeMergeService = null;
            try {
                codeMergeService = (com.jxdinfo.hussar.formdesign.common.service.CodeMergeService)SpringUtil.getBean((String)result.getResultType().getBean());
            }
            catch (Exception e) {
                logger.error("\u5199\u5165\u51b2\u7a81\u6587\u4ef6\u65f6\u83b7\u53d6({})\u5b9e\u4f8b\u5931\u8d25", (Object)result.getResultType().getBean());
            }
            if (ObjectUtils.isEmpty((Object)codeMergeService)) {
                return;
            }
            codeMergeService.writeMergeCode(codeMergeService.parseData(result.getData()));
        }
    }

    @Override
    public List<VueCodeResult> acceptLeftNoConflictCode(List<VueCodeResult> vueCodeResults) {
        String path = vueCodeResults.get(0).getFilePath();
        String type = vueCodeResults.get(0).getType();
        ExtractFileType extractFileType = ExtractFileType.valueOf((String)type.toUpperCase());
        String lastPublish = vueCodeResults.get(0).getLastPublish();
        String currentFile = vueCodeResults.get(0).getCurrentFile();
        String currentPublish = vueCodeResults.get(0).getCurrentPublish();
        StructuralMerger.Result result = StructuralMerger.hybridMerge((String)path, (ExtractFileType)extractFileType, (String)currentFile, (String)lastPublish, (String)currentPublish);
        vueCodeResults.get(0).setCurrentFile(result.getMerged());
        return vueCodeResults;
    }

    @Override
    public List<VueCodeResult> acceptRightNoConflictCode(List<VueCodeResult> vueCodeResults) {
        String path = vueCodeResults.get(0).getFilePath();
        String type = vueCodeResults.get(0).getType();
        ExtractFileType extractFileType = ExtractFileType.valueOf((String)type.toUpperCase());
        String lastPublish = vueCodeResults.get(0).getLastPublish();
        String currentFile = vueCodeResults.get(0).getCurrentFile();
        String currentPublish = vueCodeResults.get(0).getCurrentPublish();
        StructuralMerger.Result result = StructuralMerger.hybridMerge((String)path, (ExtractFileType)extractFileType, (String)currentFile, (String)lastPublish, (String)currentPublish);
        vueCodeResults.get(0).setCurrentFile(result.getConflicts());
        return vueCodeResults;
    }

    @Override
    public boolean isCodeConflict(List<VueCodeResult> vueCodeResults) {
        String lastPublish = vueCodeResults.get(0).getLastPublish();
        String currentFile = vueCodeResults.get(0).getCurrentFile();
        String currentPublish = vueCodeResults.get(0).getCurrentPublish();
        return this.codeMergeService.textMerge(lastPublish, currentFile, currentPublish, false).isConflict();
    }

    @Override
    public FormDesignResponse<String> deleteCacheByIdStopPublish(String id) throws LcdpException {
        FormDesignResponse response = new FormDesignResponse();
        if (HussarUtils.isNotEmpty((Object)id)) {
            this.filePublishService.deleteCacheById(id);
            response.setErrorCode(200);
            response.setErrorMsg("\u5df2\u7ec8\u6b62\u53d1\u5e03");
        } else {
            response.setErrorCode(10001);
            response.setErrorMsg("\u53d1\u5e03\u6807\u8bc6\u4e3a\u7a7a\uff0c\u7ec8\u6b62\u53d1\u5e03\u5931\u8d25");
        }
        return response;
    }

    @Override
    public void deleteCacheByIdBeforePublish(String id) {
        this.filePublishService.deleteCacheById(id);
    }
}

