/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.jxdinfo.hussar.formdesign.back.adapter.ModelPublishAdapter;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.VueCodePublishService;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.AppIsolation;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.MergeResult;
import com.jxdinfo.hussar.formdesign.publish.model.PublishDTO;
import com.jxdinfo.hussar.formdesign.publish.model.WorkGenCodeResult;
import com.jxdinfo.hussar.formdesign.publish.service.BackPublishService;
import com.jxdinfo.hussar.formdesign.publish.service.ResourcePublishService;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackPublishServiceImpl
implements BackPublishService {
    @Autowired
    private AppIsolation appIsolation;
    private final FilePublishService filePublishService;
    private final VersionManageService versionManageService;
    private final FormDesignProperties formDesignProperties;
    private final CodeMergeService codeMergeService;
    private final VueCodePublishService vueCodePublishService;
    @Autowired(required=false)
    private ResourcePublishService resourcePublishService;
    private static final Logger logger = LoggerFactory.getLogger(BackPublishServiceImpl.class);

    @Autowired
    public BackPublishServiceImpl(CodeMergeService codeMergeService, FilePublishService filePublishService, VersionManageService versionManageService, FormDesignProperties formDesignProperties, ResourcePathService resourcePathService, VueCodePublishService vueCodePublishService) {
        this.codeMergeService = codeMergeService;
        this.filePublishService = filePublishService;
        this.versionManageService = versionManageService;
        this.formDesignProperties = formDesignProperties;
        this.vueCodePublishService = vueCodePublishService;
    }

    @Override
    public void sync(Map<String, Object> param) throws IOException, LcdpException, CloneNotSupportedException {
        long start = System.currentTimeMillis();
        Object id = param.get("id");
        if (ToolUtil.isNotEmpty(param) && ToolUtil.isNotEmpty((Object)id)) {
            PublishCtx publishCtx = new PublishCtx();
            publishCtx.setBaseFile(null);
            publishCtx.addParams(param);
            ModelPublishAdapter.sync((String)id.toString());
        }
        long end = System.currentTimeMillis();
        String useTime = ToolUtil.timeBetween((long)start, (long)end);
        logger.info("\u540c\u6b65\u66f4\u65b0\u6570\u636e\u5e93\u540e\u7aef\u4ee3\u7801\u603b\u8017\u65f6\uff1a{}", (Object)useTime);
    }

    @Override
    public List<CodeResult> publishBackCode(Map<String, Object> param) throws IOException, LcdpException, CloneNotSupportedException {
        long start = System.currentTimeMillis();
        List<Object> codeResults = new ArrayList<CodeResult>();
        String id = param.get("id").toString();
        if (ToolUtil.isNotEmpty(param) && ToolUtil.isNotEmpty((Object)id)) {
            PublishCtx publishCtx = new PublishCtx();
            publishCtx.setBaseFile(null);
            publishCtx.addParams(param);
            ModelPublishAdapter.adaptor((String)id, (PublishCtx)publishCtx);
            codeResults = publishCtx.getGenCodeResults();
            PublishDTO publishDTO = ToolUtil.isEmpty((Object)publishCtx.getPublishDTO()) ? new PublishDTO() : publishCtx.getPublishDTO();
            publishDTO.setExtensionId(AppContextUtil.getUnionPrefix());
            if (this.appIsolation.isAppIsolation()) {
                this.vueCodePublishService.delayWrite(id);
                this.resourcePublishService.publishResource(publishDTO);
            } else {
                this.dealModelNoIsolation(codeResults, id, publishDTO);
            }
        }
        long end = System.currentTimeMillis();
        String useTime = ToolUtil.timeBetween((long)start, (long)end);
        logger.info("\u53d1\u5e03\u540e\u7aef\u4ee3\u7801\u603b\u8017\u65f6\uff1a{}", (Object)useTime);
        return codeResults;
    }

    private void dealModelNoIsolation(List<CodeResult> codeResults, String id, PublishDTO publishDTO) throws IOException, LcdpException {
        boolean isConflict = false;
        for (int i = 0; i < codeResults.size(); ++i) {
            if (!codeResults.get(i).isExistConflict()) continue;
            isConflict = true;
            break;
        }
        if (!isConflict) {
            this.vueCodePublishService.delayWrite(id);
            this.resourcePublishService.publishResource(publishDTO);
        } else {
            this.filePublishService.writePublishResourceToCache(id, null, publishDTO);
            this.filePublishService.writePublishSourceToCache(id, "dataModel");
        }
    }

    @Override
    public List<WorkGenCodeResult> publishBpmActivityVisitorCode(List<Map<String, String>> fileMessages, String workflowId) throws IOException, LcdpException {
        ArrayList<WorkGenCodeResult> results = new ArrayList<WorkGenCodeResult>();
        HashMap<String, String> writeNewFileLastPublish = new HashMap<String, String>();
        HashMap<String, String> writeNewFileCurrentFile = new HashMap<String, String>();
        HashMap<String, String> delayWriteLastPublish = new HashMap<String, String>();
        if (this.appIsolation.isAppIsolation()) {
            String string;
            for (Map<String, String> map : fileMessages) {
                String dataId = map.get("dataId");
                String newFilePath = map.get("newFilePath");
                String oldFilePath = map.get("oldFilePath");
                String newFile = map.get("fileContent");
                if (ToolUtil.isEmpty((Object)oldFilePath)) {
                    writeNewFileLastPublish.put(dataId, newFile);
                    writeNewFileCurrentFile.put(newFilePath, newFile);
                    continue;
                }
                delayWriteLastPublish.put(dataId, newFile);
            }
            for (Map.Entry entry : delayWriteLastPublish.entrySet()) {
                this.versionManageService.saveLastPublishCode((String)entry.getKey(), (String)entry.getValue());
            }
            String cacheName = workflowId + "PublishCacheName";
            if (HussarCacheUtil.containKey((String)cacheName, (Object)(string = workflowId + "PublishCacheKey"))) {
                this.vueCodePublishService.delayWrite(workflowId);
            }
            for (Map.Entry entry : writeNewFileLastPublish.entrySet()) {
                this.versionManageService.saveLastPublishCode((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : writeNewFileCurrentFile.entrySet()) {
                this.filePublishService.writeStringToFile((String)entry.getValue(), (String)entry.getKey());
            }
        } else {
            this.publishBpmActivityVisitorCodeNoAppIsolation(fileMessages, workflowId, results, writeNewFileLastPublish, writeNewFileCurrentFile, delayWriteLastPublish);
        }
        return results;
    }

    private void publishBpmActivityVisitorCodeNoAppIsolation(List<Map<String, String>> fileMessages, String workflowId, List<WorkGenCodeResult> results, Map<String, String> writeNewFileLastPublish, Map<String, String> writeNewFileCurrentFile, Map<String, String> delayWriteLastPublish) throws IOException, LcdpException {
        boolean isConflict = false;
        for (Map<String, String> map : fileMessages) {
            MergeResult mergeResult;
            String dataId = map.get("dataId");
            String newFilePath = map.get("newFilePath");
            String oldFilePath = map.get("oldFilePath");
            String newFile = map.get("fileContent");
            if (ToolUtil.isEmpty((Object)oldFilePath)) {
                writeNewFileLastPublish.put(dataId, newFile);
                writeNewFileCurrentFile.put(newFilePath, newFile);
                continue;
            }
            WorkGenCodeResult genCodeResult = new WorkGenCodeResult();
            String oldFile = this.filePublishService.readCurrentPublishedFile(oldFilePath);
            String versionCode = this.versionManageService.getAncestorCodeById(dataId);
            if (versionCode == null) {
                versionCode = oldFile;
            }
            if ((mergeResult = this.codeMergeService.textMerge(versionCode, oldFile, newFile, false)).isConflict()) {
                isConflict = true;
                genCodeResult.setDataId(dataId);
                genCodeResult.setId(workflowId);
                genCodeResult.setExistConflict(true);
                genCodeResult.setMergeCode(mergeResult.getMergedCode());
                genCodeResult.setConflictCode(mergeResult.getConflictsCode());
                genCodeResult.setLastPublish(mergeResult.getLastPublish());
                genCodeResult.setCurrentFile(mergeResult.getCurrentFile());
                genCodeResult.setCurrentPublish(mergeResult.getCurrentPublish());
                genCodeResult.setOriginCode(oldFile);
                genCodeResult.setNewCode(newFile);
                genCodeResult.setType("java");
                genCodeResult.setFilePath(newFilePath);
                genCodeResult.setResultType(ResultBeanEnum.MYSQL_RESULT);
                results.add(genCodeResult);
                continue;
            }
            delayWriteLastPublish.put(dataId, newFile);
        }
        if (!isConflict) {
            String string;
            for (Map.Entry entry : delayWriteLastPublish.entrySet()) {
                this.versionManageService.saveLastPublishCode((String)entry.getKey(), (String)entry.getValue());
            }
            String cacheName = workflowId + "PublishCacheName";
            if (HussarCacheUtil.containKey((String)cacheName, (Object)(string = workflowId + "PublishCacheKey"))) {
                this.vueCodePublishService.delayWrite(workflowId);
            }
            for (Map.Entry<String, String> entry : writeNewFileLastPublish.entrySet()) {
                this.versionManageService.saveLastPublishCode(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : writeNewFileCurrentFile.entrySet()) {
                this.filePublishService.writeStringToFile(entry.getValue(), entry.getKey());
            }
        } else {
            String lastPublishFilePath;
            String projectPath = this.formDesignProperties.getProjectPath();
            String string = this.formDesignProperties.getProjectRootPath();
            for (Map.Entry<String, String> entry : delayWriteLastPublish.entrySet()) {
                lastPublishFilePath = projectPath + string + "/publish/version/ancestor/" + entry.getKey().replace("_", "/") + "/last_publish.version";
                this.filePublishService.writeStringToFile(entry.getValue(), lastPublishFilePath, workflowId);
            }
            for (Map.Entry<String, String> entry : writeNewFileLastPublish.entrySet()) {
                lastPublishFilePath = projectPath + string + "/publish/version/ancestor/" + entry.getKey().replace("_", "/") + "/last_publish.version";
                this.filePublishService.writeStringToFile(entry.getValue(), lastPublishFilePath, workflowId);
            }
        }
    }
}

