/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.ModelBeanUtil;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WorkflowService;
import com.jxdinfo.hussar.formdesign.publish.model.WorkGenCodeResult;
import com.jxdinfo.hussar.formdesign.publish.service.BackPublishService;
import com.jxdinfo.hussar.formdesign.publish.service.WorkFlowPublishService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.manage.bpm.model.service.GodAxeModelService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Service;

@Service
public class WorkFlowPublishServiceImpl
implements WorkFlowPublishService {
    @Resource
    private WorkflowService workflowService;
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private GodAxeModelService godAxeModelService;
    @Resource
    private BackPublishService backPublishService;
    @Resource
    protected FormDesignProperties formDesignProperties;

    @Override
    public FormDesignResponse<Object> publish(String id, boolean isOverride) throws IOException, LcdpException, CloneNotSupportedException {
        WorkflowInfo workflowInfo = (WorkflowInfo)this.workflowService.get(id);
        this.bindWorkFlowDataModel(workflowInfo);
        String modelId = "";
        if (ToolUtil.isNotEmpty((Object)workflowInfo.getRelateFiles())) {
            for (Map.Entry set : workflowInfo.getRelateFiles().entrySet()) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", set.getKey());
                params.put("publishIds", "WebPage");
                modelId = (String)set.getKey();
                this.backPublishService.sync(params);
                this.backPublishService.publishBackCode(params);
            }
        }
        String tenantId = BaseSecurityUtil.getUser().getStringTenantId();
        return this.publish(tenantId, workflowInfo, modelId, isOverride);
    }

    private FormDesignResponse<Object> publish(String tenantId, WorkflowInfo workflowInfo, String modelId, boolean isOverride) throws IOException, LcdpException {
        List result;
        DataModelProvider dataModelProvider;
        String processDefKey;
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        workflowInfo.setVersion(this.workflowService.get(workflowInfo.getId()) != null ? ((WorkflowInfo)this.workflowService.get(workflowInfo.getId())).getVersion() : null);
        ApiResponse obj = this.godAxeModelService.saveAndPublish(this.dealData(workflowInfo), tenantId, isOverride);
        if (obj.isSuccess()) {
            processDefKey = obj.getMsg();
            String version = processDefKey.split(":")[1];
            workflowInfo.setVersion(version);
            String rootPath = this.formDesignProperties.getProjectAndCodePath();
            String path = this.getDataPath(workflowInfo.getId());
            File file = new File(this.relativeToAbsolute(path, rootPath));
            File metaFile = new File(this.addMeta(file.getAbsolutePath()));
            if (!file.exists()) {
                throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, workflowInfo.getId());
            }
            if (!metaFile.exists()) {
                throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, workflowInfo.getId());
            }
            boolean needRename = this.checkRename(workflowInfo, metaFile);
            this.writeSingleFile(file, JSON.parseObject((String)workflowInfo.getData()));
            workflowInfo.setData(null);
            this.writeSingleFile(metaFile, (JSONObject)JSON.toJSON((Object)workflowInfo));
            if (needRename) {
                this.renameTwoWorkflowFile(workflowInfo, file, metaFile, rootPath);
            }
        } else {
            if (obj.getCode() == 10010) {
                speedCodeResponse.setErrorMsg(obj.getMsg());
                speedCodeResponse.setErrorCode(obj.getCode());
            } else {
                speedCodeResponse.setErrorMsg("\u4fdd\u5b58\u5e76\u53d1\u5e03\u65f6\u51fa\u9519\uff1a" + obj.getMsg());
                speedCodeResponse.setErrorCode(500);
            }
            return speedCodeResponse;
        }
        this.fileMappingService.fileMappingCacheEvict();
        if (ToolUtil.isNotEmpty((Object)modelId)) {
            dataModelProvider = ModelProvideAdapter.adaptor((String)modelId);
        } else if (!((FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class)).isLocalUnReset() && !((FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class)).isOfflineLr()) {
            dataModelProvider = ModelBeanUtil.getModelProviderBean((String)"MYSQL");
        } else {
            return speedCodeResponse;
        }
        try {
            result = dataModelProvider.visitorGeneration(processDefKey, workflowInfo.geteName(), this.fileMappingService.getFormatPath(workflowInfo.getParentId()), modelId, workflowInfo.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        if (result == null) {
            speedCodeResponse.setErrorMsg("\u5de5\u4f5c\u6d41\u751f\u6210\u4ee3\u7801\u65f6\u51fa\u9519\uff1a\u5b58\u5728\u53d8\u91cf\u5173\u8054\u5f02\u5e38\u7684\u6570\u636e\u6e90");
            speedCodeResponse.setErrorCode(500);
            return speedCodeResponse;
        }
        List<WorkGenCodeResult> genCodeResult = this.backPublishService.publishBpmActivityVisitorCode(result, workflowInfo.getId());
        speedCodeResponse.setData(genCodeResult);
        return speedCodeResponse;
    }

    private void bindWorkFlowDataModel(WorkflowInfo workflowInfo) {
        JSONObject processBinding;
        JSONObject props;
        JSONObject workFlowData = JSON.parseObject((String)workflowInfo.getData());
        if (ToolUtil.isNotEmpty((Object)workFlowData) && ToolUtil.isNotEmpty((Object)workFlowData.get((Object)"props")) && ToolUtil.isNotEmpty((Object)(props = workFlowData.getJSONObject("props"))) && ToolUtil.isNotEmpty((Object)props.get((Object)"processBinding")) && ToolUtil.isNotEmpty((Object)(processBinding = props.getJSONObject("processBinding")).getString("id"))) {
            HashMap<String, Integer> relateFiles = new HashMap<String, Integer>();
            relateFiles.put(processBinding.getString("id"), 1);
            workflowInfo.setRelateFiles(relateFiles);
        }
    }

    private void renameTwoWorkflowFile(WorkflowInfo workflowInfo, File file, File metaFile, String rootPath) throws LcdpException {
        File newFile;
        String parentPath = "";
        if (!ToolUtil.isEmpty((Object)workflowInfo.getParentId()) && !"#".equals(workflowInfo.getParentId())) {
            parentPath = this.getDataPath(workflowInfo.getParentId());
        }
        if ((newFile = new File(rootPath + parentPath + File.separator + workflowInfo.geteName() + FileUtil.transFileSuffix((String)workflowInfo.getType()))).exists()) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, newFile.getAbsolutePath());
        }
        File newMetaFile = new File(newFile.getAbsolutePath() + ".meta");
        if (newMetaFile.exists()) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, newMetaFile.getAbsolutePath());
        }
        this.fixName(file, newFile);
        this.fixName(metaFile, newMetaFile);
    }

    protected boolean fixName(File oldFile, File newFile) {
        return oldFile.renameTo(newFile);
    }

    String getDataPath(String id) throws LcdpException {
        return this.getMetaPath(id).replace(".meta", "");
    }

    private String getMetaPath(String id) throws LcdpException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String addMeta(String absolutePath) {
        String real = absolutePath.replace("/", File.separator).replace("\\", File.separator);
        return real + ".meta";
    }

    private boolean checkRename(WorkflowInfo newBaseFile, File oldFile) throws LcdpException {
        boolean needRename = true;
        try {
            WorkflowInfo baseFile = (WorkflowInfo)JSON.parseObject((String)FileUtils.readFileToString((File)oldFile, (Charset)StandardCharsets.UTF_8), WorkflowInfo.class);
            if (newBaseFile.geteName().equals(baseFile.geteName())) {
                needRename = false;
            }
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, oldFile.getAbsolutePath());
        }
        return needRename;
    }

    void writeSingleFile(File file, JSONObject jsonObject) throws LcdpException {
        try {
            if (!file.exists()) {
                throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, file.getAbsolutePath());
            }
            if (ToolUtil.isEmpty((Object)jsonObject)) {
                FileUtils.writeStringToFile((File)file, (String)"", (Charset)StandardCharsets.UTF_8, (boolean)false);
            } else {
                FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (Charset)StandardCharsets.UTF_8, (boolean)false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, file.getAbsolutePath());
        }
    }

    private WorkFlow dealData(WorkflowInfo workflowService) {
        WorkFlow workFlow = new WorkFlow();
        workFlow.setId(workflowService.getId());
        workFlow.setData(workflowService.getData());
        workFlow.setDesc(workflowService.getDesc());
        workFlow.setName(workflowService.getName());
        workFlow.setType(workflowService.getType());
        workFlow.setModelId(workflowService.getModelId());
        workFlow.setIdentity(workflowService.getIdentity());
        workFlow.setProcDefId(workflowService.getProcDefId());
        workFlow.setVersion(workflowService.getVersion());
        workFlow.setCategory(AppContextUtil.getUnionPrefix());
        return workFlow;
    }
}

