/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.annotation.StorageEnvironment;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeVars;
import com.jxdinfo.hussar.formdesign.publish.service.ThemeVarsService;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CodeEnum;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@StorageEnvironment(value="${properties.workspace > '' ? properties.workspace : 'default'}")
public class ThemeVarsServiceImpl
implements ThemeVarsService {
    private static final String THEME_VARS_FOLDER = "theme-vars";
    private static final String CURRENT_APPLIED = ".current";
    private static final String SUFFIX = ".vars";
    private final FormDesignProperties speedCodeProperties;
    private final ResourcePathService resourcePathService;
    private final StorageService storageService;

    @Autowired
    public ThemeVarsServiceImpl(FormDesignProperties speedCodeProperties, ResourcePathService resourcePathService, StorageService storageService) {
        this.speedCodeProperties = speedCodeProperties;
        this.resourcePathService = resourcePathService;
        this.storageService = storageService;
    }

    @Override
    public ThemeVars get() throws IOException {
        return this.get(CURRENT_APPLIED);
    }

    @Override
    public ThemeVars get(String name) throws IOException {
        if (this.speedCodeProperties.getScenes().isSharedStorage()) {
            return this.getRemote(name);
        }
        return this.getLocal(name);
    }

    private ThemeVars getLocal(String name) throws IOException {
        File file = new File(this.resourcePathService.projectStore(new String[]{THEME_VARS_FOLDER, name}).getLocalPath());
        if (!file.exists()) {
            return null;
        }
        String themeVarsJson = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        return (ThemeVars)JSON.parseObject((String)themeVarsJson, ThemeVars.class);
    }

    private ThemeVars getRemote(String name) throws IOException {
        String path = this.resourcePathService.projectStore(new String[]{THEME_VARS_FOLDER, name}).getRemotePath();
        StorageResult result = this.storageService.downloadByPath(path);
        if (result.isSuccess()) {
            String themeVarsJson = new String((byte[])result.getData(), StandardCharsets.UTF_8);
            return (ThemeVars)JSON.parseObject((String)themeVarsJson, ThemeVars.class);
        }
        if (result.getCode() == CodeEnum.CODE_NOT_FILE_FOUND.getCode().intValue()) {
            return null;
        }
        throw new IOException(result.getMsg());
    }

    @Override
    public void saveOrUpdate(ThemeVars themeVars) throws IOException {
        this.saveOrUpdate(CURRENT_APPLIED, themeVars);
    }

    @Override
    public void saveOrUpdate(String name, ThemeVars themeVars) throws IOException {
        if (this.speedCodeProperties.getScenes().isSharedStorage()) {
            this.saveOrUpdateRemote(name, themeVars);
        } else {
            this.saveOrUpdateLocal(name, themeVars);
        }
    }

    private void saveOrUpdateLocal(String name, ThemeVars themeVars) throws IOException {
        File file = new File(this.resourcePathService.projectStore(new String[]{THEME_VARS_FOLDER, name}).getLocalPath());
        String themeVarsJson = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)themeVars);
        FileUtils.writeStringToFile((File)file, (String)themeVarsJson, (Charset)StandardCharsets.UTF_8);
    }

    private void saveOrUpdateRemote(String name, ThemeVars themeVars) throws IOException {
        String themeVarsJson;
        byte[] content;
        String path = this.resourcePathService.projectStore(new String[]{THEME_VARS_FOLDER, name}).getRemotePath();
        StorageResult result = this.storageService.uploadByPath(path, content = (themeVarsJson = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)themeVars)).getBytes(StandardCharsets.UTF_8), true);
        if (!result.isSuccess()) {
            throw new IOException(result.getMsg());
        }
    }

    @Override
    public void delete() throws IOException {
        this.delete(CURRENT_APPLIED);
    }

    @Override
    public void delete(String name) throws IOException {
        if (this.speedCodeProperties.getScenes().isSharedStorage()) {
            this.deleteRemote(name);
        } else {
            this.deleteLocal(name);
        }
    }

    private void deleteLocal(String name) throws IOException {
        File file = new File(this.resourcePathService.projectStore(new String[]{THEME_VARS_FOLDER, name}).getLocalPath());
        if (!file.exists()) {
            return;
        }
        FileUtils.forceDelete((File)file);
    }

    private void deleteRemote(String name) throws IOException {
        String path = this.resourcePathService.projectStore(new String[]{THEME_VARS_FOLDER, name}).getRemotePath();
        StorageResult result = this.storageService.deleteByPath(path, true);
        if (!result.isSuccess() && result.getCode() != CodeEnum.CODE_NOT_FILE_FOUND.getCode().intValue()) {
            throw new IOException(result.getMsg());
        }
    }
}

