/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.util;

import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileUtil {
    private static String KEY_JAVA_FILE = "javaFile";
    private static String KEY_OTHER_FILE = "otherFile";
    private static final Logger logger = LoggerFactory.getLogger(CompileUtil.class);

    public static void compileAndCopyFiles(String src, String dest, List<String> options, String charSet, String packagePath) throws Exception {
        logger.info("start compile {}.....", (Object)src);
        long start = System.currentTimeMillis();
        CompileUtil.mkDirs(dest);
        Map<String, List<File>> allFiles = CompileUtil.getFiles(src);
        List<File> files = allFiles.get(KEY_JAVA_FILE);
        JavaCompiler cmp = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = cmp.getStandardFileManager(null, null, Charset.forName(charSet));
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
        cmp.getTask(null, fileManager, null, options, null, compilationUnits).call();
        fileManager.close();
        logger.info("end compileAndCopyFiles.Files amount:{}.Total spend time : {} s", (Object)allFiles.size(), (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    private static void copyOtherFiles(List<File> files, String dest, String packagePath) throws Exception {
        for (File file : files) {
            String fileAbsolutePath = file.getAbsolutePath();
            String destPath = dest + fileAbsolutePath.substring(packagePath.length());
            FileUtils.copyFile((File)file, (File)new File(destPath), (boolean)true);
        }
    }

    private static Map<String, List<File>> getFiles(String src) {
        List<File> files = CompileUtil.getAllFiles(src);
        String suffix = ".java";
        HashMap<String, List<File>> map = new HashMap<String, List<File>>();
        ArrayList<File> javaFile = new ArrayList<File>();
        ArrayList<File> otherFile = new ArrayList<File>();
        for (File file : files) {
            String fileName = file.getName();
            if (fileName.endsWith(suffix)) {
                javaFile.add(file);
                continue;
            }
            otherFile.add(file);
        }
        map.put(KEY_JAVA_FILE, javaFile);
        map.put(KEY_OTHER_FILE, otherFile);
        return map;
    }

    public static List<File> getAllFiles(String path) {
        ArrayList<File> files = new ArrayList<File>();
        File file = new File(path);
        if (file.exists() && !file.isHidden()) {
            if (file.isDirectory()) {
                File[] fs;
                for (File f : fs = file.listFiles()) {
                    if (file.isHidden()) continue;
                    if (f.isDirectory()) {
                        files.addAll(CompileUtil.getAllFiles(path + File.separator + f.getName()));
                    }
                    if (!f.isFile()) continue;
                    files.add(f);
                }
            } else if (file.isFile()) {
                files.add(file);
            }
        }
        return files;
    }

    public static void copy(String from, String to) {
        try (FileInputStream in = new FileInputStream(from);
             FileOutputStream out = new FileOutputStream(to);){
            byte[] buff = new byte[1024];
            int len = 0;
            while ((len = ((InputStream)in).read(buff)) != -1) {
                ((OutputStream)out).write(buff, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void mkDirs(String path) {
        File destFile = new File(path);
        if (!destFile.exists()) {
            destFile.mkdirs();
        }
    }

    public static void compile(FormDesignProperties speedCodeProperties, String path, boolean isAbsolute) {
        FormDesignResponse response = new FormDesignResponse();
        String javaCodePath = speedCodeProperties.getJavaCodePath();
        String javaPath = speedCodeProperties.getJavaPath();
        if (!isAbsolute) {
            path = speedCodeProperties.getBackProjectPath() + javaCodePath + javaPath + path;
        }
        String dest = speedCodeProperties.getBackProjectPath() + "\\target\\classes\\";
        dest = ToolUtil.pathFomatterByOS((String)dest);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(dest);
        try {
            String javaSourceFilePath = speedCodeProperties.getProjectPath() + "\\src\\main\\java\\";
            javaSourceFilePath = ToolUtil.pathFomatterByOS((String)javaSourceFilePath);
            CompileUtil.compileAndCopyFiles(path, dest, options, "UTF-8", javaSourceFilePath);
            response.setErrorCode(200);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setErrorCode(500);
            response.setErrorMsg("\u7f16\u8bd1\u5931\u8d25\uff01");
        }
    }
}

