/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.util.MicroservicesCommon;

import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.publish.service.ThemeVarsService;
import java.io.IOException;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PublishPreviewHandler {
    private static ResourcePathService resourcePathService;
    private static FormDesignProperties formDesignProperties;
    private static FilePublishService filePublishService;
    private static PageInfoService pageInfoService;
    private static ThemeVarsService themeVarsService;
    private static final String PREFIX_COMMON_JS = "prefixCommon.js";
    private static final String COMMON_FTL = "prefixCommon/prefixCommon.ftl";
    private static final String PREFIX_PATH = "/src/pages/index";

    @Autowired
    PublishPreviewHandler(ResourcePathService resourcePathService, FormDesignProperties formDesignProperties, FilePublishService filePublishService, PageInfoService pageInfoService, ThemeVarsService themeVarsService) {
        PublishPreviewHandler.resourcePathService = resourcePathService;
        PublishPreviewHandler.formDesignProperties = formDesignProperties;
        PublishPreviewHandler.filePublishService = filePublishService;
        PublishPreviewHandler.pageInfoService = pageInfoService;
        PublishPreviewHandler.themeVarsService = themeVarsService;
    }

    public static void getCommon() throws LcdpException {
        HashMap<String, String> map = new HashMap<String, String>(2);
        String prefix = AppContextUtil.getUnionPrefix();
        prefix = ToolUtil.isNotEmpty((Object)prefix) ? FileUtil.posixPath((String[])new String[]{prefix}) : prefix;
        String modules = formDesignProperties.getModules();
        map.put("name", prefix);
        map.put("pathName", ToolUtil.isEmpty((Object)prefix) ? "" : FileUtil.posixPath((String[])new String[]{"/", prefix}));
        String newCode = RenderUtil.renderTemplate((String)COMMON_FTL, map);
        String filePath = resourcePathService.webProject(new String[]{PREFIX_PATH, AppContextUtil.posixFilePathPrefix(), PREFIX_COMMON_JS}).getLocalPath();
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        filePublishService.writeStringToFile(newCode, filePath, true);
    }

    public static void beforePublish(String pageId, PublishCtx<CodeResult> publishCtx) throws IOException, LcdpException {
        PageInfo pageInfo = (PageInfo)pageInfoService.get(pageId);
        publishCtx.setBaseFile((BaseFile)pageInfo);
        publishCtx.setStrategy(formDesignProperties.isOfflineLr() || formDesignProperties.isLocalUnReset() ? "HUSSAR_ENGINE" : "ORIGINAL");
        PublishPreviewHandler.getCommon();
    }
}

