/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.jxdinfo.hussar.formdesign.back.adapter.ModelPublishAdapter;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.VueCodeGenerateService;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.VueCodePublishService;
import com.jxdinfo.hussar.formdesign.common.constant.StrategyType;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.common.service.DefaultStyleCacheService;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.facade.theme.dto.DefaultStyleDTO;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.DefaultStyle;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeVars;
import com.jxdinfo.hussar.formdesign.external.facade.theme.service.IHussarThemeCodeGenerateService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.MicroAppInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.publish.service.PublishService;
import com.jxdinfo.hussar.formdesign.publish.service.ThemeVarsService;
import com.jxdinfo.hussar.formdesign.publish.util.MicroservicesCommon.PublishPreviewHandler;
import com.jxdinfo.hussar.speedcode.MenuService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class PublishServiceImpl
implements PublishService {
    private final PageInfoService pageInfoService;
    private static final Logger logger = LoggerFactory.getLogger(PublishServiceImpl.class);
    private final FormDesignProperties formDesignProperties;
    private final DefaultStyleCacheService defaultStyleCacheService;
    private final ThemeVarsService themeVarsService;
    private final VueCodeGenerateService vueCodeGenerateService;
    private final VueCodePublishService vueCodePublishService;
    private final FilePublishService filePublishService;
    private final MicroAppInfoService microAppInfoService;
    @Autowired
    private IHussarThemeCodeGenerateService hussarThemeCodeGenerateService;
    @Autowired(required=false)
    private MenuService menuService;

    @Autowired
    public PublishServiceImpl(PageInfoService pageInfoService, FormDesignProperties formDesignProperties, DefaultStyleCacheService defaultStyleCacheService, ThemeVarsService themeVarsService, VueCodeGenerateService vueCodeGenerateService, VueCodePublishService vueCodePublishService, FilePublishService filePublishService, MicroAppInfoService microAppInfoService) {
        this.pageInfoService = pageInfoService;
        this.formDesignProperties = formDesignProperties;
        this.defaultStyleCacheService = defaultStyleCacheService;
        this.themeVarsService = themeVarsService;
        this.vueCodeGenerateService = vueCodeGenerateService;
        this.vueCodePublishService = vueCodePublishService;
        this.filePublishService = filePublishService;
        this.microAppInfoService = microAppInfoService;
    }

    @Override
    public List<CodeResult> webVue(String id) throws IOException, LcdpException, CloneNotSupportedException {
        long start = System.currentTimeMillis();
        PublishCtx publishCtx = new PublishCtx();
        PublishPreviewHandler.beforePublish(id, (PublishCtx<CodeResult>)publishCtx);
        ModelPublishAdapter.generator((PublishCtx)publishCtx);
        ThemeVars themeVars = this.themeVarsService.get();
        Map webThemeVars = themeVars != null ? themeVars.getWebPage() : null;
        this.vueCodePublishService.webVue(publishCtx, webThemeVars);
        logger.info("web\u7aef\u53d1\u5e03\u603b\u8017\u65f6({})", (Object)ToolUtil.logTime((long)start));
        return publishCtx.getGenCodeResults();
    }

    @Override
    public List<CodeResult> mobileVue(String id) throws IOException, LcdpException, CloneNotSupportedException {
        long start = System.currentTimeMillis();
        PageInfo pageInfo = (PageInfo)this.pageInfoService.get(id);
        PublishCtx publishCtx = new PublishCtx();
        publishCtx.setBaseFile((BaseFile)pageInfo);
        publishCtx.setStrategy(StrategyType.analyse());
        ModelPublishAdapter.generator((PublishCtx)publishCtx);
        ThemeVars themeVars = this.themeVarsService.get();
        Map mobileThemeVars = themeVars != null ? themeVars.getMobilePage() : null;
        publishCtx.setStrategy(this.formDesignProperties.isLocalUnReset() ? "HUSSAR_ENGINE" : "ORIGINAL");
        this.vueCodePublishService.mobileVue(publishCtx, mobileThemeVars);
        logger.info("mobile\u7aef\u53d1\u5e03\u603b\u8017\u65f6({})", (Object)ToolUtil.logTime((long)start));
        return publishCtx.getGenCodeResults();
    }

    @Override
    public void defaultStyleGenerate(DefaultStyleDTO defaultStyleDTO) throws Exception, IOException {
        Map webDefaultStyle = defaultStyleDTO.getWebPage();
        Map mobileDefaultStyle = defaultStyleDTO.getMobilePage();
        this.defaultStyleCacheService.clear();
        for (Map.Entry entry : webDefaultStyle.entrySet()) {
            this.defaultStyleCacheService.update("WebPage", (String)entry.getKey(), (DefaultStyle)entry.getValue());
        }
        for (Map.Entry entry : mobileDefaultStyle.entrySet()) {
            this.defaultStyleCacheService.update("MobilePage", (String)entry.getKey(), (DefaultStyle)entry.getValue());
        }
        ThemeVars themeVars = this.themeVarsService.get();
        Map webThemeVars = themeVars != null ? themeVars.getWebPage() : null;
        Map mobileThemeVars = themeVars != null ? themeVars.getMobilePage() : null;
        String webDefaultStylesJson = this.hussarThemeCodeGenerateService.defaultStyleGenerate(mobileDefaultStyle, mobileThemeVars);
        String mobileDefaultStylesJson = this.hussarThemeCodeGenerateService.defaultStyleGenerate(webDefaultStyle, webThemeVars);
        this.filePublishService.writeWebDefaultStyle(webDefaultStylesJson);
        this.filePublishService.writeMobileDefaultStyle(mobileDefaultStylesJson, this.formDesignProperties.getMobProjectPath());
    }

    @Override
    public void writeMergeCode(List<CodeResult> results) throws IOException {
        for (CodeResult result : results) {
            CodeMergeService codeMergeService = null;
            try {
                codeMergeService = (CodeMergeService)SpringUtil.getBean((String)result.getResultType().getBean());
            }
            catch (Exception e) {
                logger.error("\u5199\u5165\u51b2\u7a81\u6587\u4ef6\u65f6\u83b7\u53d6({})\u5b9e\u4f8b\u5931\u8d25", (Object)result.getResultType().getBean());
            }
            if (ObjectUtils.isEmpty((Object)codeMergeService)) {
                return;
            }
            codeMergeService.writeMergeCode(codeMergeService.parseData(result.getData()));
        }
    }
}

