/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.formdesign.common.constant.ExportResourceConstant;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ZipUtil;
import com.jxdinfo.hussar.formdesign.publish.service.ExportNewService;
import com.jxdinfo.hussar.formdesign.publish.util.TarUtil;
import com.jxdinfo.hussar.platform.core.utils.WebUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportNewServiceImpl
implements ExportNewService {
    private static Logger LOGGER = LoggerFactory.getLogger(ExportNewService.class);
    @Autowired
    private FormDesignProperties formDesignProperties;

    @Override
    public void export(HttpServletResponse response) throws Exception {
        long start = System.currentTimeMillis();
        String appId = WebUtil.getHeader((String)"appId");
        String prefix = AppContextUtil.getUnionPrefix();
        String modules = this.formDesignProperties.getModules();
        String appName = AppContextUtil.getAppCode();
        String frontPrefix = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getFrontApiAbPath(), modules, prefix});
        String projectStorePathPrefix = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), ExportResourceConstant.PROJECTSTORE});
        List<String> forntPaths = this.ergodic(new File(frontPrefix), new ArrayList<String>());
        String front = StringUtils.join(forntPaths, (String)",");
        List<String> fileProjectStorePaths = this.ergodic(new File(projectStorePathPrefix), new ArrayList<String>());
        String projectStores = StringUtils.join(fileProjectStorePaths, (String)",");
        String hussar = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), ExportResourceConstant.RESOURCE_CACHE, ToolUtil.splicingBySeparator((String)ExportResourceConstant.UNDERLINE, (String[])new String[]{appName, new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())})});
        String tar = FileUtil.posixPath((String[])new String[]{hussar, appName});
        String frontPath = FileUtil.posixPath((String[])new String[]{tar, appName});
        String projectStorePath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.PROJECTSTORE});
        File tarDir = new File(tar);
        File hussarDir = new File(hussar);
        String zipFilePath = hussarDir.getAbsolutePath() + ExportResourceConstant._HUSSAR;
        int as = zipFilePath.lastIndexOf(File.separator) + 1;
        String tempPath = zipFilePath.substring(0, as) + appName + start;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tempPath", tempPath);
        map.put("filePath", zipFilePath);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        CompletableFuture<Integer> future = CompletableFuture.supplyAsync(() -> {
            try {
                this.copyFilesToTemp(projectStores, FileUtil.addSuffix((String)projectStorePathPrefix), projectStorePath);
                this.copyFilesToTemp(front, FileUtil.addSuffix((String)frontPrefix), frontPath);
                this.zipAndDownload(tarDir, hussarDir, appName, hussar, response, appId, tempPath);
                long end = System.currentTimeMillis();
                LOGGER.info("\u5bfc\u51fa\u81f3\u751f\u4ea7\u8017\u65f6========================>" + String.format("%.3fs", (double)Math.abs(end - start) / 1000.0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 3;
        }, executor);
        future.thenAccept(System.out::println);
        try {
            future.get();
            this.downSingleFile(response, hussarDir.getName(), hussarDir.getAbsolutePath() + ExportResourceConstant._HUSSAR);
            FileUtils.deleteQuietly((File)new File(hussarDir.getAbsolutePath() + ExportResourceConstant._HUSSAR));
            FileUtils.deleteQuietly((File)new File(tempPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void zipAndDownload(File tarDir, File hussarDir, String appName, String hussar, HttpServletResponse response, String appId, String tempPath) throws Exception {
        String tarPath = tarDir.getAbsolutePath() + ExportResourceConstant._TAR;
        File[] files = tarDir.listFiles();
        if (ToolUtil.isNotEmpty((Object)files)) {
            List<String> filePaths = Arrays.stream(files).map(File::getAbsolutePath).collect(Collectors.toList());
            TarUtil.execute(filePaths, tarPath);
        }
        FileUtils.deleteDirectory((File)tarDir);
        JSONObject meta = new JSONObject();
        meta.put("appName", (Object)appName);
        meta.put("appId", (Object)appId);
        File metaFile = new File(FileUtil.posixPath((String[])new String[]{hussar, ExportResourceConstant.META_JSON}));
        FileUtils.writeByteArrayToFile((File)metaFile, (byte[])SerializeUtils.serialize((Object)meta));
        this.zipFile(hussarDir, ExportResourceConstant._HUSSAR, tempPath);
    }

    public void zipFile(File zipTempFile, String zipSuffix, String tempPath) throws Exception {
        String zipFilePath = zipTempFile.getAbsolutePath() + zipSuffix;
        File zipFile = new File(zipFilePath);
        if (!zipFile.exists()) {
            zipFile.getParentFile().mkdir();
        }
        ZipUtil.zip((String)zipTempFile.getAbsolutePath(), (String)zipFilePath);
        File file = new File(tempPath);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileUtils.deleteDirectory((File)zipTempFile);
    }

    private void copyFilesToTemp(String absolutePaths, String prefix, String tempPath) throws IOException {
        if (ToolUtil.isNotEmpty((Object)absolutePaths)) {
            List codeFilePaths = ToolUtil.stringToList((String)absolutePaths);
            for (String path : codeFilePaths) {
                File file = new File(path);
                if (!file.exists()) continue;
                String relativePath = path.substring(prefix.length() - 1, path.length() - file.getName().length());
                File tempDir = new File(FileUtil.posixPath((String[])new String[]{tempPath, relativePath}));
                this.mkdir(tempDir);
                if (file.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)file, (File)tempDir);
                    continue;
                }
                FileUtils.copyFileToDirectory((File)file, (File)tempDir);
            }
        }
    }

    public void mkdir(File ... files) throws IOException {
        for (File file : files) {
            if (file.exists()) continue;
            FileUtils.forceMkdir((File)file);
        }
    }

    private List<String> ergodic(File file, List<String> resultFileName) {
        File[] files = file.listFiles();
        if (files == null) {
            return resultFileName;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                resultFileName.add(f.getPath());
                this.ergodic(f, resultFileName);
                continue;
            }
            resultFileName.add(f.getPath());
        }
        return resultFileName;
    }

    public HttpServletResponse download(String path, HttpServletResponse response) {
        try {
            File file = new File(path);
            String filename = file.getName();
            String ext = filename.substring(filename.lastIndexOf(".") + 1).toUpperCase();
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(path));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(filename.getBytes()));
            response.addHeader("Content-Length", "" + file.length());
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/octet-stream");
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downSingleFile(HttpServletResponse response, String filename, String path) {
        if (filename != null) {
            FileInputStream is = null;
            BufferedInputStream bs = null;
            OutputStream os = null;
            try {
                File file = new File(path);
                if (file.exists()) {
                    response.setHeader("Content-Type", "application/octet-stream");
                    response.setHeader("Content-Disposition", "attachment;filename=" + new String(filename.getBytes("gb2312"), "ISO8859-1"));
                    response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
                    response.setContentType("application/octet-stream");
                    is = new FileInputStream(file);
                    bs = new BufferedInputStream(is);
                    os = response.getOutputStream();
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    while ((len = bs.read(buffer)) != -1) {
                        os.write(buffer, 0, len);
                    }
                } else {
                    System.err.println("\u4e0b\u8f7d\u7684\u6587\u4ef6\u8d44\u6e90\u4e0d\u5b58\u5728");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (bs != null) {
                        bs.close();
                    }
                    if (os != null) {
                        os.flush();
                        os.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

