/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.util;

import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarOutputStream;

public class TarUtil {
    private static int BUFFER = 4096;
    private static byte[] B_ARRAY = new byte[BUFFER];

    public static void execute(String inputFileName, String targetFileName) throws IOException {
        File inputFile = new File(inputFileName);
        String base = inputFileName.substring(inputFileName.lastIndexOf("/") + 1);
        TarOutputStream out = TarUtil.getTarOutputStream(targetFileName);
        TarUtil.tarPack(out, inputFile, base);
        try {
            if (null != out) {
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void execute(List<String> inputFileNameList, String targetFileName) throws IOException {
        TarOutputStream out = TarUtil.getTarOutputStream(targetFileName);
        for (String inputFileName : inputFileNameList) {
            File inputFile = new File(inputFileName);
            String base = inputFileName.substring(inputFileName.lastIndexOf("\\") + 1);
            TarUtil.tarPack(out, inputFile, base);
        }
        if (null != out) {
            out.close();
        }
    }

    private static void tarPack(TarOutputStream out, File inputFile, String base) throws IOException {
        if (inputFile.isDirectory()) {
            TarUtil.packFolder(out, inputFile, base);
        } else {
            TarUtil.packFile(out, inputFile, base);
        }
    }

    private static void packFolder(TarOutputStream out, File inputFile, String base) throws IOException {
        File[] fileList = inputFile.listFiles();
        out.putNextEntry(new TarEntry(base + "/"));
        String string = base = base.length() == 0 ? "" : base + "/";
        if (ToolUtil.isNotEmpty((Object)fileList)) {
            for (File file : fileList) {
                TarUtil.tarPack(out, file, base + file.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void packFile(TarOutputStream out, File inputFile, String base) throws IOException {
        TarEntry tarEntry = new TarEntry(base);
        tarEntry.setSize(inputFile.length());
        out.putNextEntry(tarEntry);
        FileInputStream in = new FileInputStream(inputFile);
        int b = 0;
        try {
            while ((b = in.read(B_ARRAY, 0, BUFFER)) != -1) {
                out.write(B_ARRAY, 0, b);
            }
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
                if (null != out) {
                    out.closeEntry();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compress(File srcFile) throws IOException {
        File target = new File(srcFile.getAbsolutePath() + ".gz");
        FileInputStream in = null;
        DeflaterOutputStream out = null;
        try {
            in = new FileInputStream(srcFile);
            out = new GZIPOutputStream(new FileOutputStream(target));
            int number = 0;
            while ((number = in.read(B_ARRAY, 0, BUFFER)) != -1) {
                ((GZIPOutputStream)out).write(B_ARRAY, 0, number);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static TarOutputStream getTarOutputStream(String targetFileName) throws IOException {
        targetFileName = targetFileName.endsWith(".tar") ? targetFileName : targetFileName + ".tar";
        FileOutputStream fileOutputStream = new FileOutputStream(targetFileName);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        TarOutputStream out = new TarOutputStream((OutputStream)bufferedOutputStream, StandardCharsets.UTF_8.name());
        out.setLongFileMode(2);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unTar(File file, String outputDir) throws IOException {
        TarInputStream tarIns = null;
        FileInputStream ins = null;
        OutputStream out = null;
        try {
            ins = new FileInputStream(file);
            tarIns = new TarInputStream((InputStream)ins, StandardCharsets.UTF_8.name());
            TarUtil.createDirectory(outputDir, null);
            TarEntry entry = null;
            while ((entry = tarIns.getNextEntry()) != null && !"".equals(entry.getName())) {
                if (entry.isDirectory()) {
                    TarUtil.createDirectory(outputDir, entry.getName());
                    continue;
                }
                File tmpFile = new File(outputDir + "/" + entry.getName());
                TarUtil.createDirectory(tmpFile.getParent() + "/", null);
                out = new FileOutputStream(tmpFile);
                int len = 0;
                byte[] bytes = new byte[1024];
                while ((len = tarIns.read(bytes)) != -1) {
                    out.write(bytes, 0, len);
                }
                out.close();
            }
        }
        finally {
            out.close();
            ((InputStream)ins).close();
            tarIns.close();
        }
    }

    private static void createDirectory(String outputDir, String subDir) {
        File file = new File(outputDir);
        if (subDir != null && !subDir.trim().equals("")) {
            file = new File(outputDir + "/" + subDir);
        }
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.mkdirs();
        }
    }
}

