/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.jxdinfo.hussar.engine.metadata.exception.EngineException;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelPublishAdapter;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.publish.model.PublishDTO;
import com.jxdinfo.hussar.formdesign.publish.model.WorkGenCodeResult;
import com.jxdinfo.hussar.formdesign.publish.service.BackPublishService;
import com.jxdinfo.hussar.formdesign.publish.service.ResourcePublishService;
import com.jxdinfo.hussar.formdesign.publish.service.impl.PublishServiceImpl;
import com.jxdinfo.hussar.formdesign.structural.merge.model.MergeResult;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackPublishServiceImpl
implements BackPublishService {
    private final FilePublishService filePublishService;
    private final VersionManageService versionManageService;
    private final FormDesignProperties formDesignProperties;
    private final CodeMergeService codeMergeService;
    @Autowired(required=false)
    private ResourcePublishService resourcePublishService;
    private static final Logger logger = LoggerFactory.getLogger(PublishServiceImpl.class);

    @Autowired
    public BackPublishServiceImpl(CodeMergeService codeMergeService, FilePublishService filePublishService, VersionManageService versionManageService, FormDesignProperties formDesignProperties, ResourcePathService resourcePathService) {
        this.codeMergeService = codeMergeService;
        this.filePublishService = filePublishService;
        this.versionManageService = versionManageService;
        this.formDesignProperties = formDesignProperties;
    }

    @Override
    public void sync(Map<String, Object> param) throws IOException, LcdpException, CloneNotSupportedException, EngineException {
        long start = System.currentTimeMillis();
        Object id = param.get("id");
        if (ToolUtil.isNotEmpty(param) && ToolUtil.isNotEmpty((Object)id)) {
            PublishCtx publishCtx = new PublishCtx();
            publishCtx.setBaseFile(null);
            publishCtx.addParams(param);
            ModelPublishAdapter.sync((String)id.toString());
        }
        long end = System.currentTimeMillis();
        logger.info("\u540c\u6b65\u66f4\u65b0\u6570\u636e\u5e93\u540e\u7aef\u4ee3\u7801\u603b\u8017\u65f6\uff1a" + ToolUtil.timeBetween((long)start, (long)end));
    }

    @Override
    public List<CodeResult> publishBackCode(Map<String, Object> param) throws IOException, LcdpException, CloneNotSupportedException {
        long start = System.currentTimeMillis();
        List<Object> codeResults = new ArrayList<CodeResult>();
        Object id = param.get("id");
        if (ToolUtil.isNotEmpty(param) && ToolUtil.isNotEmpty((Object)id)) {
            PublishCtx publishCtx = new PublishCtx();
            publishCtx.setBaseFile(null);
            publishCtx.addParams(param);
            ModelPublishAdapter.adaptor((String)id.toString(), (PublishCtx)publishCtx);
            codeResults = publishCtx.getGenCodeResults();
            PublishDTO publishDTO = ToolUtil.isEmpty((Object)publishCtx.getPublishDTO()) ? new PublishDTO() : publishCtx.getPublishDTO();
            publishDTO.setExtensionId(AppContextUtil.getUnionPrefix());
            this.resourcePublishService.publishResource(publishDTO);
        }
        long end = System.currentTimeMillis();
        logger.info("\u53d1\u5e03\u540e\u7aef\u4ee3\u7801\u603b\u8017\u65f6\uff1a" + ToolUtil.timeBetween((long)start, (long)end));
        return codeResults;
    }

    @Override
    public List<WorkGenCodeResult> publishBpmActivityVisitorCode(List<Map<String, String>> fileMessages) throws IOException {
        ArrayList<WorkGenCodeResult> results = new ArrayList<WorkGenCodeResult>();
        for (Map<String, String> map : fileMessages) {
            MergeResult mergeResult;
            String dataId = map.get("dataId");
            String newFilePath = map.get("newFilePath");
            String oldFilePath = map.get("oldFilePath");
            String newFile = this.filePublishService.readCurrentPublishedFile(newFilePath);
            if (ToolUtil.isEmpty((Object)oldFilePath)) {
                this.versionManageService.saveNewVersionCode(dataId, newFile);
                continue;
            }
            WorkGenCodeResult genCodeResult = new WorkGenCodeResult();
            String oldFile = this.filePublishService.readCurrentPublishedFile(oldFilePath);
            String versionCode = this.versionManageService.getAncestorCodeById(dataId);
            if (versionCode == null) {
                versionCode = oldFile;
            }
            if ((mergeResult = this.codeMergeService.textMerge(versionCode, newFile, oldFile, false)).isConflict()) {
                genCodeResult.setDataId(dataId);
                genCodeResult.setExistConflict(true);
                genCodeResult.setMergeCode(mergeResult.getMergedCode());
                genCodeResult.setConflictCode(mergeResult.getConflictsCode());
                genCodeResult.setOriginCode(oldFile);
                genCodeResult.setNewCode(newFile);
                genCodeResult.setType("java");
                genCodeResult.setFilePath(newFilePath);
                genCodeResult.setResultType(ResultBeanEnum.MYSQL_RESULT);
                results.add(genCodeResult);
                continue;
            }
            this.filePublishService.writeStringToFile(mergeResult.getMergedCode(), newFilePath, true);
            this.versionManageService.saveNewVersionCode(dataId, newFile);
        }
        return results;
    }
}

